/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.parts;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kr.co.goms.epub.solution.tts.FakeTtsService;
import kr.co.goms.epub.solution.tts.ITtsService;
import kr.co.goms.epub.solution.tts.TTSMp3Player;
import kr.co.goms.epub.solution.utils.GoogleTtsUtil;
import kr.co.goms.epub.solution.utils.Mp3Util;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class EpubTTSViewPart {
    private Combo genderCombo;
    private StyledText textArea;
    private Text inputField;
    private Button ttsButton;
    private TableViewer mp3Table;
    private Button batchButton;
    private Button fileButton;
    private Text imagePromptText;
    private volatile GoogleTtsUtil.VoiceGender uiGender = GoogleTtsUtil.VoiceGender.FEMALE;
    private final List<Mp3Item> mp3Items = new ArrayList<Mp3Item>();
    private ITtsService ttsService;
    private TTSMp3Player player;
    private Path outputDir;
    private final List<TableEditor> rowEditors = new ArrayList<TableEditor>();
    private final List<Button> rowButtons = new ArrayList<Button>();
    private ProgressBar progressBar;
    private Label progressLabel;
    private ScheduledExecutorService progressExec;
    private ScheduledFuture<?> progressTask;
    private volatile long playStartMs = 0L;
    private volatile long playTotalMs = 0L;
    private volatile File playingFile = null;
    private Menu tableContextMenu;
    private Shell shell;
    private Map<String, Image> thumbnailCache = new HashMap<String, Image>();
    private ExecutorService imagePool = Executors.newFixedThreadPool(3);
    private String ollamaUrl = "http://localhost:11434/api/generate";
    private String ollamaModel = "flux";
    private final AtomicInteger seqCounter = new AtomicInteger(1);

    @PostConstruct
    public void createControls(Composite parent) {
        this.shell = parent.getShell();
        parent.setLayout((Layout)new GridLayout(1, false));
        final Composite topBar = new Composite(parent, 0);
        topBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        topBar.setLayout((Layout)new GridLayout(2, false));
        this.fileButton = new Button(topBar, 8);
        this.fileButton.setText("\ud30c\uc77c \uc5f4\uae30 (*.txt)...");
        this.fileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EpubTTSViewPart.this.openTextFile(topBar.getShell());
            }
        });
        Label tip = new Label(topBar, 0);
        tip.setText("\ud55c \uc904\ub9c8\ub2e4 \ud55c \ud56d\ubaa9\uc73c\ub85c \ucc98\ub9ac\ub429\ub2c8\ub2e4.");
        this.textArea = new StyledText(parent, 2816);
        this.textArea.setLayoutData((Object)new GridData(4, 4, true, true));
        GridData gdTextArea = new GridData(4, 4, true, true);
        gdTextArea.heightHint = 80;
        gdTextArea.minimumHeight = 60;
        this.textArea.setLayoutData((Object)gdTextArea);
        this.textArea.setAlwaysShowScrollBars(false);
        Composite inputRow = new Composite(parent, 0);
        inputRow.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        inputRow.setLayout((Layout)new GridLayout(2, false));
        this.inputField = new Text(inputRow, 2048);
        this.inputField.setMessage("\uc774\uacf3\uc5d0 \ud14d\uc2a4\ud2b8\ub97c \uc785\ub825 \ud6c4 [TTS \ubcc0\ud658]\uc744 \ub204\ub974\uc138\uc694");
        this.inputField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.ttsButton = new Button(inputRow, 8);
        this.ttsButton.setText("TTS \ubcc0\ud658");
        this.ttsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String s = EpubTTSViewPart.this.inputField.getText().trim();
                if (!s.isEmpty()) {
                    EpubTTSViewPart.this.synthOne(EpubTTSViewPart.this.shell, s);
                }
            }
        });
        Composite genderRow = new Composite(parent, 0);
        genderRow.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        genderRow.setLayout((Layout)new GridLayout(2, false));
        new Label(genderRow, 0).setText("\ubcf4\uc774\uc2a4 \uc131\ubcc4:");
        this.genderCombo = new Combo(genderRow, 12);
        this.genderCombo.setItems(new String[]{"FEMALE", "MALE", "NEUTRAL"});
        this.genderCombo.select(0);
        this.genderCombo.addListener(13, e -> {
            String sel;
            this.uiGender = switch (sel = this.genderCombo.getText()) {
                case "MALE" -> GoogleTtsUtil.VoiceGender.MALE;
                case "NEUTRAL" -> GoogleTtsUtil.VoiceGender.NEUTRAL;
                default -> GoogleTtsUtil.VoiceGender.FEMALE;
            };
        });
        Group imageGrp = new Group(parent, 0);
        imageGrp.setText("\uc774\ubbf8\uc9c0 \ud504\ub86c\ud504\ud2b8 (\uc804\uc5ed)");
        imageGrp.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 8;
        gl.marginHeight = 6;
        gl.horizontalSpacing = 8;
        gl.verticalSpacing = 6;
        imageGrp.setLayout((Layout)gl);
        Label lbl = new Label((Composite)imageGrp, 0);
        lbl.setText("\ud504\ub86c\ud504\ud2b8:");
        lbl.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.imagePromptText = new Text((Composite)imageGrp, 2626);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 80;
        gd.minimumHeight = 60;
        this.imagePromptText.setLayoutData((Object)gd);
        this.imagePromptText.setMessage("\uc608) hybrid Korean ink wash + pastel, cinematic realism, soft lighting, 16:9 ...");
        Group mp3Group = new Group(parent, 0);
        mp3Group.setText("MP3 \uacb0\uacfc (\ub354\ube14\ud074\ub9ad = \uc7ac\uc0dd / \uc815\uc9c0)");
        mp3Group.setLayoutData((Object)new GridData(4, 4, true, true));
        mp3Group.setLayout((Layout)new GridLayout(1, false));
        this.mp3Table = new TableViewer((Composite)mp3Group, 67586);
        Table table = this.mp3Table.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        TableViewerColumn col0 = new TableViewerColumn(this.mp3Table, 0);
        col0.getColumn().setText("\uc21c\ubc88");
        col0.getColumn().setWidth(50);
        col0.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                return String.format("%03d", ((Mp3Item)e).seq);
            }
        });
        TableViewerColumn col1 = new TableViewerColumn(this.mp3Table, 0);
        col1.getColumn().setText("\uc6d0\ubb38");
        col1.getColumn().setWidth(420);
        col1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                return ((Mp3Item)e).text;
            }
        });
        TableViewerColumn col2 = new TableViewerColumn(this.mp3Table, 0);
        col2.getColumn().setText("MP3 \ud30c\uc77c");
        col2.getColumn().setWidth(320);
        col2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                return ((Mp3Item)e).file.getName();
            }
        });
        this.mp3Table.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.mp3Table.setInput(this.mp3Items);
        table.addListener(8, ev -> {
            IStructuredSelection sel = this.mp3Table.getStructuredSelection();
            Mp3Item item = (Mp3Item)sel.getFirstElement();
            if (item != null) {
                this.togglePlay(item);
            }
        });
        Composite bottomBar = new Composite(parent, 0);
        bottomBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        bottomBar.setLayout((Layout)new GridLayout(2, false));
        this.batchButton = new Button(bottomBar, 8);
        this.batchButton.setText("\uc77c\uad04 \ubcc0\ud658");
        this.batchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EpubTTSViewPart.this.batchConvert(EpubTTSViewPart.this.shell);
            }
        });
        Button stopBtn = new Button(bottomBar, 8);
        stopBtn.setText("\uc7ac\uc0dd \uc815\uc9c0");
        stopBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EpubTTSViewPart.this.stopPlay();
            }
        });
        TableColumn colPlay = new TableColumn(table, 0x1000000);
        colPlay.setText("\uc7ac\uc0dd");
        colPlay.setWidth(80);
        TableColumn colDown = new TableColumn(table, 0x1000000);
        colDown.setText("\ub2e4\uc6b4\ub85c\ub4dc");
        colDown.setWidth(100);
        TableViewerColumn colImgPrompt = new TableViewerColumn(this.mp3Table, 16384);
        colImgPrompt.getColumn().setText("Image Prompt");
        colImgPrompt.getColumn().setWidth(300);
        colImgPrompt.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                return ((Mp3Item)e).getImagePrompt();
            }
        });
        colImgPrompt.setEditingSupport(new EditingSupport((ColumnViewer)this.mp3Table){
            private final TextCellEditor editor;
            {
                this.editor = new TextCellEditor((Composite)EpubTTSViewPart.this.mp3Table.getTable());
            }

            protected CellEditor getCellEditor(Object element) {
                return this.editor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                String v = ((Mp3Item)element).getImagePrompt();
                return v == null ? "" : v;
            }

            protected void setValue(Object element, Object value) {
                ((Mp3Item)element).setImagePrompt(String.valueOf(value));
                EpubTTSViewPart.this.mp3Table.update(element, null);
            }
        });
        TableViewerColumn colPreview = new TableViewerColumn(this.mp3Table, 16384);
        colPreview.getColumn().setText("Preview");
        colPreview.getColumn().setWidth(180);
        colPreview.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object e) {
                Mp3Item it = (Mp3Item)e;
                String p = it.getImagePath();
                if (p == null) {
                    return null;
                }
                return EpubTTSViewPart.this.thumbnailCache.computeIfAbsent(p, k -> this.loadThumbnail((String)k, 170, 100));
            }

            public String getText(Object e) {
                Mp3Item it = (Mp3Item)e;
                return it.getImagePath() == null ? "" : new File(it.getImagePath()).getName();
            }

            private Image loadThumbnail(String path, int maxW, int maxH) {
                try {
                    Image img = new Image((Device)Display.getDefault(), path);
                    Rectangle b = img.getBounds();
                    double scale = Math.min((double)maxW / (double)b.width, (double)maxH / (double)b.height);
                    if (scale >= 1.0) {
                        return img;
                    }
                    Image scaled = new Image((Device)Display.getDefault(), (int)((double)b.width * scale), (int)((double)b.height * scale));
                    GC gc = new GC((Drawable)scaled);
                    gc.setAntialias(1);
                    gc.setInterpolation(2);
                    gc.drawImage(img, 0, 0, b.width, b.height, 0, 0, scaled.getBounds().width, scaled.getBounds().height);
                    gc.dispose();
                    img.dispose();
                    return scaled;
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
        TableViewerColumn colActions = new TableViewerColumn(this.mp3Table, 16384);
        colActions.getColumn().setText("Actions");
        colActions.getColumn().setWidth(220);
        colActions.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public void update(ViewerCell cell) {
                super.update(cell);
                Table table = EpubTTSViewPart.this.mp3Table.getTable();
                TableItem ti = (TableItem)cell.getItem();
                Composite panel = new Composite((Composite)table, 0);
                panel.setLayout((Layout)new RowLayout());
                Button gen = new Button(panel, 8);
                gen.setText("\uc774\ubbf8\uc9c0 \uc0dd\uc131(1280\u00d7720)");
                Button open = new Button(panel, 8);
                open.setText("\uc6d0\ubcf8 \uc5f4\uae30");
                Mp3Item row = (Mp3Item)cell.getElement();
                gen.addListener(13, ev -> EpubTTSViewPart.this.generateImageForRow(row));
                open.addListener(13, ev -> {
                    if (row.getImagePath() != null) {
                        Program.launch((String)row.getImagePath());
                    }
                });
                TableEditor ed = new TableEditor(table);
                ed.grabHorizontal = true;
                ed.setEditor((Control)panel, ti, cell.getColumnIndex());
                panel.pack();
            }
        });
        Composite progressRow = new Composite(parent, 0);
        progressRow.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        progressRow.setLayout((Layout)new GridLayout(2, false));
        this.progressLabel = new Label(progressRow, 0);
        this.progressLabel.setText("\ub300\uae30 \uc911");
        this.progressLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.progressBar = new ProgressBar(progressRow, 0);
        GridData gdPb = new GridData(4, 0x1000000, false, false);
        gdPb.widthHint = 240;
        this.progressBar.setLayoutData((Object)gdPb);
        this.progressExec = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "tts-progress");
            t.setDaemon(true);
            return t;
        });
        this.player = new TTSMp3Player();
        this.ttsService = new FakeTtsService();
        this.outputDir = this.makeOutputDir();
        this.createContextMenuForTable();
    }

    private void createContextMenuForTable() {
        Table table = this.mp3Table.getTable();
        this.tableContextMenu = new Menu((Control)table);
        table.setMenu(this.tableContextMenu);
        Runnable ensureSelection = () -> {
            if (table.getSelectionCount() == 0 && table.getItemCount() > 0) {
                table.setSelection(0);
            }
        };
        MenuItem miPlayToggle = new MenuItem(this.tableContextMenu, 8);
        miPlayToggle.setText("\uc7ac\uc0dd/\uc815\uc9c0");
        miPlayToggle.addListener(13, e -> {
            TableItem it;
            ensureSelection.run();
            TableItem tableItem = it = table.getSelectionIndex() >= 0 ? table.getItem(table.getSelectionIndex()) : null;
            if (it == null) {
                return;
            }
            Mp3Item data = (Mp3Item)it.getData();
            if (data == null) {
                return;
            }
            if (this.player.isPlayingThis(data.file)) {
                this.stopPlay();
            } else {
                this.resetAllPlayButtonsToPlay();
                this.play(data.file);
            }
        });
        new MenuItem(this.tableContextMenu, 2);
        MenuItem miOpen = new MenuItem(this.tableContextMenu, 8);
        miOpen.setText("\ud30c\uc77c \uc5f4\uae30");
        miOpen.addListener(13, e -> {
            ensureSelection.run();
            TableItem[] tableItemArray = table.getSelection();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem it = tableItemArray[n2];
                Mp3Item d = (Mp3Item)it.getData();
                if (d != null) {
                    this.openWithOS(d.file);
                }
                ++n2;
            }
        });
        MenuItem miReveal = new MenuItem(this.tableContextMenu, 8);
        miReveal.setText("\ud3f4\ub354\uc5d0\uc11c \ubcf4\uae30");
        miReveal.addListener(13, e -> {
            TableItem it;
            ensureSelection.run();
            TableItem tableItem = it = table.getSelectionIndex() >= 0 ? table.getItem(table.getSelectionIndex()) : null;
            if (it == null) {
                return;
            }
            Mp3Item d = (Mp3Item)it.getData();
            if (d == null) {
                return;
            }
            this.revealInOS(d.file.getParentFile());
        });
        MenuItem miCopyPath = new MenuItem(this.tableContextMenu, 8);
        miCopyPath.setText("\ud30c\uc77c \uacbd\ub85c \ubcf5\uc0ac");
        miCopyPath.addListener(13, e -> {
            ensureSelection.run();
            StringBuilder sb = new StringBuilder();
            TableItem[] tableItemArray = table.getSelection();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem it = tableItemArray[n2];
                Mp3Item d = (Mp3Item)it.getData();
                if (d != null) {
                    sb.append(d.file.getAbsolutePath()).append(System.lineSeparator());
                }
                ++n2;
            }
            this.copyToClipboard(sb.toString());
        });
        new MenuItem(this.tableContextMenu, 2);
        MenuItem miBatchDownload = new MenuItem(this.tableContextMenu, 8);
        miBatchDownload.setText("\uc120\ud0dd \ud56d\ubaa9 \uc77c\uad04 \ub2e4\uc6b4\ub85c\ub4dc\u2026");
        miBatchDownload.addListener(13, e -> this.handleBatchDownload());
        MenuItem miDelete = new MenuItem(this.tableContextMenu, 8);
        miDelete.setText("\uc120\ud0dd \ud56d\ubaa9 \uc0ad\uc81c");
        miDelete.addListener(13, e -> this.handleDeleteSelected());
    }

    private void openWithOS(File f) {
        try {
            if (f.exists()) {
                Program.launch((String)f.getAbsolutePath());
            }
        }
        catch (Exception exception) {}
    }

    private void revealInOS(File dir) {
        try {
            if (dir != null && dir.exists()) {
                Program.launch((String)dir.getAbsolutePath());
            }
        }
        catch (Exception exception) {}
    }

    private void copyToClipboard(String text) {
        Clipboard cb = new Clipboard(Display.getDefault());
        cb.setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
        cb.dispose();
    }

    private void handleBatchDownload() {
        Table table = this.mp3Table.getTable();
        if (table.getSelectionCount() == 0) {
            MessageDialog.openInformation((Shell)this.shell, (String)"\uc54c\ub9bc", (String)"\uba3c\uc800 \ud56d\ubaa9\uc744 \uc120\ud0dd\ud558\uc138\uc694.");
            return;
        }
        DirectoryDialog dd = new DirectoryDialog(this.shell);
        dd.setMessage("\uc800\uc7a5\ud560 \ud3f4\ub354\ub97c \uc120\ud0dd\ud558\uc138\uc694.");
        String targetDir = dd.open();
        if (targetDir == null) {
            return;
        }
        int ok = 0;
        int fail = 0;
        TableItem[] tableItemArray = table.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem it = tableItemArray[n2];
            Mp3Item d = (Mp3Item)it.getData();
            if (d != null) {
                try {
                    Path dest = Path.of(targetDir, d.file.getName());
                    Files.copy(d.file.toPath(), dest, StandardCopyOption.REPLACE_EXISTING);
                    ++ok;
                }
                catch (Exception exception) {
                    ++fail;
                }
            }
            ++n2;
        }
        MessageDialog.openInformation((Shell)this.shell, (String)"\uc644\ub8cc", (String)("\ub2e4\uc6b4\ub85c\ub4dc \uc644\ub8cc\n\uc131\uacf5: " + ok + "  \uc2e4\ud328: " + fail + "\n\ud3f4\ub354: " + targetDir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDeleteSelected() {
        Table table = this.mp3Table.getTable();
        if (table.getSelectionCount() == 0) {
            MessageDialog.openInformation((Shell)this.shell, (String)"\uc54c\ub9bc", (String)"\uc0ad\uc81c\ud560 \ud56d\ubaa9\uc744 \uc120\ud0dd\ud558\uc138\uc694.");
            return;
        }
        boolean yes = MessageDialog.openConfirm((Shell)this.shell, (String)"\uc0ad\uc81c \ud655\uc778", (String)"\uc120\ud0dd\ud55c MP3 \ud30c\uc77c\uc744 \uc2e4\uc81c \ub514\uc2a4\ud06c\uc5d0\uc11c \uc0ad\uc81c\ud558\uc2dc\uaca0\uc2b5\ub2c8\uae4c?");
        if (!yes) {
            return;
        }
        int ok = 0;
        int fail = 0;
        ArrayList<Mp3Item> toRemove = new ArrayList<Mp3Item>();
        TableItem[] tableItemArray = table.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem it = tableItemArray[n2];
            Mp3Item d = (Mp3Item)it.getData();
            if (d != null) {
                try {
                    boolean deleted;
                    if (this.playingFile != null && d.file.equals(this.playingFile)) {
                        this.stopPlay();
                    }
                    if (deleted = d.file.delete()) {
                        ++ok;
                        toRemove.add(d);
                    } else {
                        ++fail;
                    }
                }
                catch (Exception exception) {
                    ++fail;
                }
            }
            ++n2;
        }
        List<Mp3Item> list = this.mp3Items;
        synchronized (list) {
            this.mp3Items.removeAll(toRemove);
        }
        this.refreshTable();
        MessageDialog.openInformation((Shell)this.shell, (String)"\uc0ad\uc81c \uacb0\uacfc", (String)("\uc0ad\uc81c \uc131\uacf5: " + ok + "  \uc2e4\ud328: " + fail));
    }

    private Path makeOutputDir() {
        try {
            String ts = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
            Path dir = Path.of(System.getProperty("user.home"), "TtsOutputs", ts);
            Files.createDirectories(dir, new FileAttribute[0]);
            return dir;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void refreshTable() {
        this.mp3Table.refresh();
        this.installRowEditors();
    }

    private void openTextFile(Shell shell) {
        FileDialog dlg = new FileDialog(shell, 4096);
        dlg.setFilterExtensions(new String[]{"*.txt"});
        dlg.setText("\ud14d\uc2a4\ud2b8 \ud30c\uc77c \uc120\ud0dd");
        String path = dlg.open();
        if (path == null) {
            return;
        }
        try {
            String content = Files.readString(Path.of(path, new String[0]), StandardCharsets.UTF_8);
            this.textArea.setText(content);
            MessageDialog.openInformation((Shell)shell, (String)"\uc644\ub8cc", (String)"*.txt \ub0b4\uc6a9\uc774 textarea\uc5d0 \ub85c\ub4dc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.\n\uc904\ubc14\uafc8(\\n) \uae30\uc900\uc73c\ub85c \uc77c\uad04 \ubcc0\ud658\ub429\ub2c8\ub2e4.");
        }
        catch (Exception ex) {
            MessageDialog.openError((Shell)shell, (String)"\uc624\ub958", (String)("\ud30c\uc77c\uc744 \uc77d\ub294 \uc911 \uc624\ub958: " + ex.getMessage()));
        }
    }

    private void synthOne(Shell shell, String text) {
        new Thread(() -> {
            try {
                int seq = this.seqCounter.getAndIncrement();
                String fname = EpubTTSViewPart.buildFileName(seq, text);
                String out = this.outputDir.resolve(fname).toString();
                boolean ok = GoogleTtsUtil.synthesizeToFile(text, out, this.uiGender);
                if (!ok) {
                    throw new RuntimeException("Google TTS \uc2e4\ud328");
                }
                Mp3Item item = new Mp3Item(seq, text, new File(out));
                List<Mp3Item> list = this.mp3Items;
                synchronized (list) {
                    this.mp3Items.add(item);
                }
                Display.getDefault().asyncExec(this::refreshTable);
            }
            catch (Exception ex) {
                Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)shell, (String)"TTS \uc624\ub958", (String)ex.getMessage()));
            }
        }, "tts-one").start();
    }

    private void batchConvert(Shell shell) {
        String all = this.textArea.getText();
        if (all == null || all.isBlank()) {
            MessageDialog.openInformation((Shell)shell, (String)"\uc54c\ub9bc", (String)"textarea\uc5d0 \ub0b4\uc6a9\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
            return;
        }
        String[] lines = all.split("\\R");
        ArrayList<String> targets = new ArrayList<String>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String raw = stringArray[n2];
            String s = raw.strip();
            if (!s.isEmpty()) {
                targets.add(s);
            }
            ++n2;
        }
        targets.size();
        new Thread(() -> {
            int success = 0;
            int fail = 0;
            for (String s : targets) {
                try {
                    int seq = this.seqCounter.getAndIncrement();
                    String fname = EpubTTSViewPart.buildFileName(seq, s);
                    String out = this.outputDir.resolve(fname).toString();
                    boolean ok = GoogleTtsUtil.synthesizeToFile(s, out, this.uiGender);
                    if (!ok) {
                        ++fail;
                        continue;
                    }
                    List<Mp3Item> list2 = this.mp3Items;
                    synchronized (list2) {
                        String fileName = new File(out).toString();
                        System.out.println("seq : " + seq + ", text : " + s + ", fileName : " + fileName);
                        this.mp3Items.add(new Mp3Item(seq, s, new File(out)));
                    }
                    ++success;
                    Display.getDefault().asyncExec(this::refreshTable);
                    Thread.sleep(120L);
                }
                catch (Exception ex) {
                    ++fail;
                    Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)shell, (String)"\uc77c\uad04 \ubcc0\ud658 \uc624\ub958", (String)ex.getMessage()));
                }
            }
            int sOk = success;
            int sFail = fail;
            Display.getDefault().asyncExec(() -> MessageDialog.openInformation((Shell)shell, (String)"\uc644\ub8cc", (String)("\uc77c\uad04 \ubcc0\ud658 \uc644\ub8cc\n\uc131\uacf5: " + sOk + "  \uc2e4\ud328: " + sFail + "\n\ucd9c\ub825 \ud3f4\ub354: " + String.valueOf(this.outputDir))));
        }, "tts-batch").start();
    }

    private void togglePlay(Mp3Item item) {
        if (this.player.isPlayingThis(item.file)) {
            this.stopPlay();
        } else {
            this.play(item.file);
        }
    }

    private void play(File file) {
        this.resetAllPlayButtonsToPlay();
        long totalMs = 0L;
        try {
            totalMs = Mp3Util.getDurationMillis(file);
        }
        catch (Exception exception) {}
        long total = totalMs > 0L ? totalMs : 0L;
        this.onPlayStarted(file, total);
        this.player.playAsync(file, () -> Display.getDefault().asyncExec(this::onPlayStopped));
    }

    private void stopPlay() {
        this.player.stop();
        this.onPlayStopped();
    }

    @Focus
    public void setFocus() {
        this.textArea.setFocus();
    }

    @PreDestroy
    public void preDestroy() {
        this.thumbnailCache.values().forEach(img -> {
            if (img != null && !img.isDisposed()) {
                img.dispose();
            }
        });
        this.thumbnailCache.clear();
        if (this.imagePool != null) {
            this.imagePool.shutdownNow();
        }
        this.cleanupResources();
    }

    private void cleanupResources() {
        try {
            this.stopPlay();
        }
        catch (Exception exception) {}
        this.cancelProgressTask();
        if (this.progressExec != null) {
            this.progressExec.shutdownNow();
            this.progressExec = null;
        }
        this.disposeRowEditors();
    }

    private void disposeRowEditors() {
        for (Button b : this.rowButtons) {
            if (b == null || b.isDisposed()) continue;
            b.dispose();
        }
        for (TableEditor ed : this.rowEditors) {
            if (ed != null && !ed.getEditor().isDisposed()) {
                ed.getEditor().dispose();
            }
            if (ed == null) continue;
            ed.dispose();
        }
        this.rowButtons.clear();
        this.rowEditors.clear();
    }

    private void installRowEditors() {
        this.disposeRowEditors();
        Table table = this.mp3Table.getTable();
        int playColIndex = 3;
        int downColIndex = 4;
        int i = 0;
        while (i < table.getItemCount()) {
            TableItem item = table.getItem(i);
            Mp3Item data = (Mp3Item)item.getData();
            if (data != null) {
                Button playBtn = new Button((Composite)table, 8);
                playBtn.setText(this.player.isPlayingThis(data.file) ? "\uc815\uc9c0" : "\uc7ac\uc0dd");
                playBtn.addListener(13, ev -> {
                    if (this.player.isPlayingThis(mp3Item.file)) {
                        this.player.stop();
                        playBtn.setText("\uc7ac\uc0dd");
                    } else {
                        this.resetAllPlayButtonsToPlay();
                        this.player.playAsync(mp3Item.file, () -> Display.getDefault().asyncExec(() -> {
                            if (!playBtn.isDisposed()) {
                                playBtn.setText("\uc7ac\uc0dd");
                            }
                        }));
                        playBtn.setText("\uc815\uc9c0");
                    }
                });
                TableEditor ed1 = new TableEditor(table);
                ed1.grabHorizontal = true;
                ed1.minimumWidth = 70;
                ed1.horizontalAlignment = 0x1000000;
                ed1.setEditor((Control)playBtn, item, playColIndex);
                this.rowEditors.add(ed1);
                this.rowButtons.add(playBtn);
                Button downBtn = new Button((Composite)table, 8);
                downBtn.setText("\ub2e4\uc6b4\ub85c\ub4dc");
                downBtn.addListener(13, ev -> {
                    FileDialog fd = new FileDialog(this.shell, 8192);
                    fd.setOverwrite(true);
                    fd.setFilterExtensions(new String[]{"*.mp3"});
                    fd.setFileName(mp3Item.file.getName());
                    String target = fd.open();
                    if (target != null) {
                        try {
                            Files.copy(mp3Item.file.toPath(), Path.of(target, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                            MessageDialog.openInformation((Shell)this.shell, (String)"\uc800\uc7a5 \uc644\ub8cc", (String)("\ud30c\uc77c\uc774 \uc800\uc7a5\ub418\uc5c8\uc5b4\uc694:\n" + target));
                        }
                        catch (Exception ex) {
                            MessageDialog.openError((Shell)this.shell, (String)"\uc624\ub958", (String)("\uc800\uc7a5 \uc2e4\ud328: " + ex.getMessage()));
                        }
                    }
                });
                TableEditor ed2 = new TableEditor(table);
                ed2.grabHorizontal = true;
                ed2.minimumWidth = 90;
                ed2.horizontalAlignment = 0x1000000;
                ed2.setEditor((Control)downBtn, item, downColIndex);
                this.rowEditors.add(ed2);
                this.rowButtons.add(downBtn);
            }
            ++i;
        }
    }

    private void resetAllPlayButtonsToPlay() {
        for (Button b : this.rowButtons) {
            if (b == null || b.isDisposed() || !"\uc815\uc9c0".equals(b.getText())) continue;
            b.setText("\uc7ac\uc0dd");
        }
    }

    private void onPlayStarted(File f, long totalMs) {
        this.playingFile = f;
        this.playTotalMs = totalMs;
        this.playStartMs = System.currentTimeMillis();
        Display.getDefault().asyncExec(() -> {
            this.progressLabel.setText("\uc7ac\uc0dd \uc911: " + f.getName() + (String)(totalMs > 0L ? " (" + EpubTTSViewPart.formatMs(totalMs) + ")" : ""));
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum((int)(totalMs > 0L ? totalMs : 100L));
            this.progressBar.setSelection(0);
        });
        this.cancelProgressTask();
        this.progressTask = this.progressExec.scheduleAtFixedRate(() -> {
            if (this.playingFile == null) {
                return;
            }
            long elapsed = System.currentTimeMillis() - this.playStartMs;
            Display.getDefault().asyncExec(() -> {
                if (this.progressBar.isDisposed() || this.progressLabel.isDisposed()) {
                    return;
                }
                if (this.playTotalMs > 0L) {
                    int sel = (int)Math.min(this.playTotalMs, elapsed);
                    this.progressBar.setSelection(sel);
                    this.progressLabel.setText("\uc7ac\uc0dd \uc911: " + this.playingFile.getName() + "  " + EpubTTSViewPart.formatMs(elapsed) + " / " + EpubTTSViewPart.formatMs(this.playTotalMs));
                } else {
                    int sel = (this.progressBar.getSelection() + 3) % this.progressBar.getMaximum();
                    this.progressBar.setSelection(sel);
                    this.progressLabel.setText("\uc7ac\uc0dd \uc911: " + this.playingFile.getName() + "  " + EpubTTSViewPart.formatMs(elapsed));
                }
            });
        }, 0L, 200L, TimeUnit.MILLISECONDS);
    }

    private void onPlayStopped() {
        this.cancelProgressTask();
        this.playingFile = null;
        this.playTotalMs = 0L;
        this.playStartMs = 0L;
        if (!this.progressBar.isDisposed() && !this.progressLabel.isDisposed()) {
            this.progressLabel.setText("\ub300\uae30 \uc911");
            this.progressBar.setSelection(0);
        }
        this.resetAllPlayButtonsToPlay();
    }

    private void cancelProgressTask() {
        if (this.progressTask != null) {
            this.progressTask.cancel(true);
            this.progressTask = null;
        }
    }

    private static String formatMs(long ms) {
        if (ms < 0L) {
            ms = 0L;
        }
        long s = ms / 1000L;
        long m = s / 60L;
        long h = m / 60L;
        s %= 60L;
        m %= 60L;
        if (h > 0L) {
            return String.format("%d:%02d:%02d", h, m, s);
        }
        return String.format("%02d:%02d", m, s);
    }

    private static String buildFileName(int seq, String text) {
        String base = Mp3Util.safeBase(text, 80);
        return String.format("%03d_%s.mp3", seq, base);
    }

    private String getGlobalImagePrompt() {
        return this.imagePromptText == null ? "" : this.imagePromptText.getText().trim();
    }

    private void generateImageForRow(Mp3Item it) {
        it.setStatus("IMAGE_QUEUED");
        this.mp3Table.update((Object)it, null);
        this.imagePool.submit(() -> {
            try {
                if (it.getSeed() == null) {
                    it.setSeed(System.nanoTime());
                }
                String globalPrompt = this.getGlobalImagePrompt();
                String base = it.getImagePrompt() != null && !it.getImagePrompt().isBlank() ? it.getImagePrompt() : (globalPrompt.isBlank() ? it.getPrompt() : globalPrompt);
                Path outDir = Paths.get(this.getOutputBaseDir(), "images");
                Files.createDirectories(outDir, new FileAttribute[0]);
                Path out = this.callOllamaFlux(this.ollamaUrl, this.ollamaModel, base, it.getStyle(), "1280x720", it.getSeed(), outDir.resolve(this.safe(it.getTitle()) + ".png"));
                it.setImagePath(out.toString());
                it.setStatus("IMAGE_OK");
                Display.getDefault().asyncExec(() -> {
                    Image old = this.thumbnailCache.remove(out.toString());
                    if (old != null && !old.isDisposed()) {
                        old.dispose();
                    }
                    this.mp3Table.update((Object)it, null);
                });
            }
            catch (Exception ex) {
                it.setStatus("IMAGE_FAIL: " + ex.getMessage());
                Display.getDefault().asyncExec(() -> this.mp3Table.update((Object)it, null));
            }
        });
    }

    private Path callOllamaFlux(String endpoint, String model, String prompt, String style, String size, Long seed, Path outPath) throws Exception {
        String merged = style == null || style.isBlank() ? prompt : prompt + "\n\nStyle:\n" + style;
        String payload = this.toJson(Map.of("model", model, "prompt", merged, "size", size == null || size.isBlank() ? "1280x720" : size, "seed", seed == null ? 0L : seed));
        HttpURLConnection con = (HttpURLConnection)new URL(endpoint).openConnection();
        con.setRequestMethod("POST");
        con.setDoOutput(true);
        con.setRequestProperty("Content-Type", "application/json");
        Throwable throwable = null;
        Throwable throwable2 = null;
        try (OutputStream os = con.getOutputStream();){
            os.write(payload.getBytes(StandardCharsets.UTF_8));
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        ArrayList<String> imgs = new ArrayList<String>();
        throwable2 = null;
        Object var13_16 = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                if (!line.contains("\"images\"")) continue;
                int s = line.indexOf(91);
                int e = line.lastIndexOf(93);
                if (s <= 0 || e <= s) continue;
                String inside = line.substring(s + 1, e);
                String[] stringArray = inside.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String t = stringArray[n2];
                    if ((t = t.trim()).startsWith("\"") && t.endsWith("\"")) {
                        imgs.add(t.substring(1, t.length() - 1));
                    }
                    ++n2;
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable2 == null) {
                throwable2 = throwable4;
            } else if (throwable2 != throwable4) {
                throwable2.addSuppressed(throwable4);
            }
            throw throwable2;
        }
        if (imgs.isEmpty()) {
            throw new IOException("No image returned");
        }
        byte[] png = Base64.getDecoder().decode((String)imgs.get(0));
        Files.createDirectories(outPath.getParent(), new FileAttribute[0]);
        Files.write(outPath, png, new OpenOption[0]);
        return outPath;
    }

    private String toJson(Map<String, Object> m) {
        StringBuilder sb = new StringBuilder("{");
        boolean first = true;
        for (Map.Entry<String, Object> e : m.entrySet()) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append('\"').append(this.escape(e.getKey())).append('\"').append(':');
            Object v = e.getValue();
            if (v instanceof Number || v instanceof Boolean) {
                sb.append(v);
                continue;
            }
            sb.append('\"').append(this.escape(String.valueOf(v))).append('\"');
        }
        return sb.append("}").toString();
    }

    private String escape(String s) {
        return s.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    private String getOutputBaseDir() {
        return this.outputDir.toString();
    }

    private String safe(String s) {
        return s.replaceAll("[^a-zA-Z0-9._-]+", "_");
    }

    public static class Mp3Item {
        public final int seq;
        public final String text;
        public final File file;
        private String title;
        private String prompt;
        private String style;
        private String status;
        private String imagePrompt;
        private String imagePath;
        private String audioPath;
        private Long seed;

        public Mp3Item(int seq, String text, File file) {
            this.seq = seq;
            this.text = text;
            this.file = file;
        }

        public String getTitle() {
            return this.title;
        }

        public String getPrompt() {
            return this.prompt;
        }

        public String getStyle() {
            return this.style;
        }

        public String getStatus() {
            return this.status;
        }

        public String getImagePrompt() {
            return this.imagePrompt;
        }

        public String getImagePath() {
            return this.imagePath;
        }

        public String getAudioPath() {
            return this.audioPath;
        }

        public Long getSeed() {
            return this.seed;
        }

        public void setTitle(String v) {
            this.title = v;
        }

        public void setPrompt(String v) {
            this.prompt = v;
        }

        public void setStyle(String v) {
            this.style = v;
        }

        public void setStatus(String v) {
            this.status = v;
        }

        public void setImagePrompt(String v) {
            this.imagePrompt = v;
        }

        public void setImagePath(String v) {
            this.imagePath = v;
        }

        public void setAudioPath(String v) {
            this.audioPath = v;
        }

        public void setSeed(Long v) {
            this.seed = v;
        }
    }
}

