/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.parts;

import jakarta.annotation.PostConstruct;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kr.co.goms.epub.solution.dialogs.EpubViewerDialog;
import kr.co.goms.epub.solution.preferences.EpubPreferenceManager;
import kr.co.goms.epub.solution.providers.EpubListContentProvider;
import kr.co.goms.epub.solution.providers.EpubListLabelProvider;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class EpubTreeViewerPart {
    private TreeViewer treeViewer;
    private boolean sortAscending = true;
    private Text searchText;
    private List<File> allEpubFiles = new ArrayList<File>();

    @PostConstruct
    public void createControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.searchText = new Text(parent, 2944);
        this.searchText.setMessage("\ud30c\uc77c\uba85 \uac80\uc0c9...");
        this.searchText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.searchText.addModifyListener(e -> this.applyFilter());
        this.treeViewer = new TreeViewer(parent, 2052);
        this.treeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.treeViewer.setContentProvider((IContentProvider)new EpubListContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new EpubListLabelProvider());
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object selected = selection.getFirstElement();
                if (selected instanceof File) {
                    File epubFile = (File)selected;
                    Shell shell = Display.getDefault().getActiveShell();
                    EpubViewerDialog dialog = new EpubViewerDialog(shell, epubFile);
                    Color backgroundColor = new Color((Device)shell.getDisplay(), 220, 235, 250);
                    dialog.setTitleAreaColor(backgroundColor.getRGB());
                    dialog.open();
                }
            }
        });
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        RowLayout rowLayout = new RowLayout();
        rowLayout.spacing = 10;
        rowLayout.center = true;
        buttonComposite.setLayout((Layout)rowLayout);
        Button reloadButton = new Button(buttonComposite, 8);
        reloadButton.setText("Reload");
        reloadButton.addListener(13, e -> this.refreshTree());
        Button sortButton = new Button(buttonComposite, 8);
        sortButton.setText("Sort: ASC");
        sortButton.addListener(13, e -> {
            this.sortAscending = !this.sortAscending;
            sortButton.setText(this.sortAscending ? "Sort: ASC" : "Sort: DESC");
            this.refreshTree();
        });
        this.refreshTree();
    }

    private void setTitleAreaImage(EpubViewerDialog dialog) {
        try {
            ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"epubtest03", (String)"resources/ad_banner_1280.jpg");
            Image bgImage = descriptor.createImage();
            dialog.setTitleImage(bgImage);
            dialog.getShell().addListener(12, e -> bgImage.dispose());
        }
        catch (Exception exception) {}
    }

    private void refreshTree() {
        String path = EpubPreferenceManager.getInstance().getPublishFullPath();
        this.getEpubFiles(path);
    }

    private void getEpubFiles(String path) {
        File[] files;
        File dir = new File(path);
        if (!dir.exists() || !dir.isDirectory()) {
            this.allEpubFiles = Collections.emptyList();
        }
        this.allEpubFiles = (files = dir.listFiles((d, name) -> name.toLowerCase().endsWith(".epub"))) == null ? Collections.emptyList() : Arrays.stream(files).sorted((f1, f2) -> {
            int cmp = Long.compare(f1.lastModified(), f2.lastModified());
            return this.sortAscending ? cmp : -cmp;
        }).collect(Collectors.toList());
        this.applyFilter();
    }

    @Focus
    public void setFocus() {
    }

    private void applyFilter() {
        String keyword = this.searchText.getText().trim().toLowerCase();
        List filtered = this.allEpubFiles.stream().filter(file -> file.getName().toLowerCase().contains(keyword)).collect(Collectors.toList());
        this.treeViewer.setInput(filtered);
    }
}

