/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.parts;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class GomsLogPart {
    public static final String PLUGIN_ID = "kr.co.goms.epub.solution";
    public static final String PREF_SHOW_LOG_VIEW = "showGomsLogView";
    private static GomsLogPart instance;
    private StyledText logText;
    private Clipboard clipboard;
    @Inject
    private MPart part;

    @PostConstruct
    public void createPartControl(Composite parent) {
        instance = this;
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        boolean show = prefs.getBoolean(PREF_SHOW_LOG_VIEW, true);
        if (!show) {
            this.part.setToBeRendered(false);
            return;
        }
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 2;
        parent.setLayout((Layout)layout);
        this.logText = new StyledText(parent, 2824);
        this.logText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.logText.setAlwaysShowScrollBars(true);
        this.logText.setWordWrap(false);
        this.clipboard = new Clipboard(parent.getDisplay());
        this.appendLine("GomsBook \ub85c\uadf8 \ubdf0\uac00 \ucd08\uae30\ud654\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", LogLevel.INFO);
    }

    @PreDestroy
    public void dispose() {
        if (instance == this) {
            instance = null;
        }
        if (this.clipboard != null && !this.clipboard.isDisposed()) {
            this.clipboard.dispose();
        }
    }

    private void appendLine(String line, LogLevel level) {
        if (this.logText == null || this.logText.isDisposed()) {
            return;
        }
        Display display = this.logText.getDisplay();
        String time = new SimpleDateFormat("HH:mm:ss").format(new Date());
        String prefix = "[" + time + "][" + level.name() + "] ";
        String full = prefix + line + "\n";
        int start = this.logText.getCharCount();
        this.logText.append(full);
        StyleRange style = new StyleRange();
        style.start = start;
        style.length = full.length();
        switch (level) {
            case ERROR: {
                style.foreground = display.getSystemColor(3);
                break;
            }
            case WARN: {
                style.foreground = display.getSystemColor(8);
                break;
            }
            case DEBUG: {
                style.foreground = display.getSystemColor(16);
                break;
            }
            default: {
                style.foreground = display.getSystemColor(2);
            }
        }
        this.logText.setStyleRange(style);
        this.logText.setTopIndex(this.logText.getLineCount() - 1);
    }

    private void copyAllToClipboard() {
        if (this.logText == null || this.logText.isDisposed()) {
            return;
        }
        if (this.clipboard == null || this.clipboard.isDisposed()) {
            return;
        }
        String all = this.logText.getText();
        if (all == null || all.isEmpty()) {
            return;
        }
        TextTransfer textTransfer = TextTransfer.getInstance();
        this.clipboard.setContents(new Object[]{all}, new Transfer[]{textTransfer});
    }

    private void clear() {
        if (this.logText == null || this.logText.isDisposed()) {
            return;
        }
        this.logText.setText("");
    }

    public static void log(String line) {
        GomsLogPart.log(LogLevel.INFO, line);
    }

    public static void logInfo(String line) {
        GomsLogPart.log(LogLevel.INFO, line);
    }

    public static void logWarn(String line) {
        GomsLogPart.log(LogLevel.WARN, line);
    }

    public static void logError(String line) {
        GomsLogPart.log(LogLevel.ERROR, line);
    }

    public static void logDebug(String line) {
        GomsLogPart.log(LogLevel.DEBUG, line);
    }

    public static void log(LogLevel level, String line) {
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(() -> {
                if (instance != null) {
                    instance.appendLine(line, level);
                }
            });
        } else if (instance != null) {
            instance.appendLine(line, level);
        }
    }

    public static enum LogLevel {
        INFO,
        WARN,
        ERROR,
        DEBUG;

    }
}

