/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.parts;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kr.co.goms.epub.smil.SmilWriter;
import kr.co.goms.epub.solution.dialogs.Mp3PlayerDialog;
import kr.co.goms.epub.solution.dialogs.SmilViewerDialog;
import kr.co.goms.epub.solution.preferences.EpubPreferenceManager;
import kr.co.goms.epub.solution.tts.TtsUsageTracker;
import kr.co.goms.epub.solution.ui.PageElement;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import kr.co.goms.epub.solution.utils.GoogleTtsUtil;
import kr.co.goms.epub.solution.utils.OpfNcxUpdater;
import kr.co.goms.epub.solution.utils.XHTMLParser;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

@Creatable
public class PageElementViewPart {
    private TableViewer tableViewer;
    private List<PageElement> elementList = new ArrayList<PageElement>();
    private List<TableEditor> editors = new ArrayList<TableEditor>();
    private Label remainingLabel;
    @Inject
    private MPart part;
    @Inject
    IEventBroker broker;

    @PostConstruct
    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        String xhtmlName = (String)this.part.getPersistedState().get("xhtmlName");
        System.out.println("xhtmlName : " + xhtmlName);
        Color backgroundColor = new Color((Device)parent.getDisplay(), 220, 235, 250);
        this.remainingLabel = new Label(parent, 0);
        int remaining = TtsUsageTracker.getRemainingChars();
        this.remainingLabel.setText("\ub0a8\uc740 \ubb38\uc790 \uc218: " + remaining);
        this.tableViewer = new TableViewer(parent, 68354);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableViewer.getTable().setHeaderBackground(backgroundColor);
        this.createColumns(this.tableViewer);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        String targetXhtml = "cover.xhtml";
        if (!xhtmlName.isEmpty()) {
            targetXhtml = xhtmlName;
        }
        String fTargetXhtml = targetXhtml;
        String targetSmil = targetXhtml.replace("xhtml", "smil");
        this.getData(this.tableViewer.getControl().getShell(), "/OEBPS/Text/" + targetXhtml);
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        RowLayout rowLayout = new RowLayout();
        rowLayout.spacing = 10;
        rowLayout.center = true;
        buttonComposite.setLayout((Layout)rowLayout);
        Button bulkConvertButton = new Button(buttonComposite, 8);
        bulkConvertButton.setText("\uc77c\uad04 \ubcc0\ud658");
        Button reloadButton = new Button(buttonComposite, 8);
        reloadButton.setText("Reload");
        reloadButton.addListener(13, e -> this.initData(fTargetXhtml));
        bulkConvertButton.addListener(13, e -> {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(parent.getShell());
            try {
                dialog.run(true, true, monitor -> {
                    monitor.beginTask("TTS \ubcc0\ud658 \uc911...", this.elementList.size());
                    AtomicInteger converted = new AtomicInteger(0);
                    AtomicInteger skipped = new AtomicInteger(0);
                    AtomicInteger failed = new AtomicInteger(0);
                    String smilPath = EpubBuildUtil.getProjectFullPath() + "/OEBPS/Smil/" + targetSmil;
                    String smilFilePath = "Text/" + fTargetXhtml;
                    new SmilWriter(smilPath, smilFilePath);
                    for (PageElement el : this.elementList) {
                        if (monitor.isCanceled()) break;
                        monitor.subTask("\ubcc0\ud658 \uc911: " + el.getId());
                        String text = el.getContent();
                        int length = text.length();
                        String mp3FileName = "Audio/" + el.getId() + ".mp3";
                        String fullMp3Path = EpubBuildUtil.getProjectFullPath() + "/OEBPS/" + mp3FileName;
                        GoogleTtsUtil.VoiceGender gender = GoogleTtsUtil.VoiceGender.NEUTRAL;
                        if (!TtsUsageTracker.canConvert(length)) {
                            skipped.incrementAndGet();
                            monitor.worked(1);
                            continue;
                        }
                        try {
                            GoogleTtsUtil.synthesizeToFile(text, fullMp3Path, gender);
                            TtsUsageTracker.addCount(length);
                            converted.incrementAndGet();
                        }
                        catch (Exception ex) {
                            failed.incrementAndGet();
                            ex.printStackTrace();
                        }
                        monitor.worked(1);
                    }
                    Display.getDefault().asyncExec(() -> {
                        this.initData(fTargetXhtml);
                        this.remainingLabel.setText("\ub0a8\uc740 \ubb38\uc790 \uc218: " + TtsUsageTracker.getRemainingChars());
                        MessageDialog.openInformation((Shell)this.tableViewer.getControl().getShell(), (String)"\uc77c\uad04 \ubcc0\ud658 \uc644\ub8cc", (String)("\u2705 \ubcc0\ud658: " + converted.get() + "\uac1c\n\u26a0\ufe0f \uc2a4\ud0b5: " + skipped.get() + "\uac1c\n\u274c \uc2e4\ud328: " + failed.get() + "\uac1c"));
                    });
                    monitor.done();
                });
            }
            catch (InterruptedException | InvocationTargetException ex) {
                ex.printStackTrace();
            }
        });
        Button createButton = new Button(buttonComposite, 8);
        createButton.setText("Smil\uc0dd\uc131");
        createButton.addListener(13, e -> {
            String xhtmlChapterName = fTargetXhtml.replace(".xhtml", "");
            System.out.println("fTargetXhtml : " + fTargetXhtml);
            System.out.println("xhtmlChapterName : " + xhtmlChapterName);
            String smilPath = EpubBuildUtil.getProjectFullPath() + "/OEBPS/Smil/" + targetSmil;
            String xhtmlFilePath = "Text/" + fTargetXhtml;
            SmilWriter smilWriter = new SmilWriter(smilPath, xhtmlFilePath);
            List<File> mp3Files = smilWriter.findMp3FilesForChapter(xhtmlChapterName);
            try {
                SmilWriter.createSmilFile(xhtmlChapterName, mp3Files);
                SmilWriter.updateOpf(xhtmlChapterName, mp3Files);
                this.broker.send("project_explorer/refresh", (Object)targetSmil);
            }
            catch (Exception e1) {
                e1.getStackTrace();
            }
        });
        createButton.setVisible(false);
        Button playerButton = new Button(buttonComposite, 8);
        playerButton.setText("Smil\uc7ac\uc0dd");
        playerButton.addListener(13, e -> {
            String smilPath = EpubBuildUtil.getProjectOEBPSSubFolder("Smil/") + targetSmil;
            String xhtmlPath = EpubBuildUtil.getProjectOEBPSSubFolder("Text/") + fTargetXhtml;
            System.out.println("smilPath : " + smilPath);
            System.out.println("xhtmlPath : " + xhtmlPath);
            File smilFile = new File(smilPath);
            File xhtmlFile = new File(xhtmlPath);
            if (smilFile.exists()) {
                SmilViewerDialog viewer = new SmilViewerDialog(Display.getDefault(), smilFile, xhtmlFile);
                viewer.open();
            } else {
                MessageDialog.openWarning((Shell)this.tableViewer.getControl().getShell(), (String)"\uc54c\ub9bc", (String)"Smil \ud30c\uc77c \uc0dd\uc131 \ud6c4 \uc2e4\ud589\ud574\uc8fc\uc138\uc694");
            }
        });
        playerButton.setVisible(false);
    }

    private void initData(String targetXhtml) {
        this.tableViewer.refresh();
        this.refreshXhtmlParse(targetXhtml);
        this.updateConversionStatusFromAudioFolder();
    }

    private void createColumns(TableViewer viewer) {
        String[] titles = new String[]{"No", "Tag", "ID", "Text", "MP3 \ud30c\uc77c\uba85", "\uc0c1\ud0dc", "Action"};
        int[] bounds = new int[]{40, 60, 150, 300, 150, 100, 100};
        TableViewerColumn colNo = new TableViewerColumn(viewer, 0x1000000);
        colNo.getColumn().setText(titles[0]);
        colNo.getColumn().setWidth(bounds[0]);
        colNo.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return String.valueOf(PageElementViewPart.this.elementList.indexOf(element) + 1);
            }
        });
        TableViewerColumn colTag = new TableViewerColumn(viewer, 0x1000000);
        colTag.getColumn().setText(titles[1]);
        colTag.getColumn().setWidth(bounds[1]);
        colTag.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((PageElement)element).getTag();
            }
        });
        TableViewerColumn colId = new TableViewerColumn(viewer, 0x1000000);
        colId.getColumn().setText(titles[2]);
        colId.getColumn().setWidth(bounds[2]);
        colId.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((PageElement)element).getId();
            }
        });
        TableViewerColumn colText = new TableViewerColumn(viewer, 0x1000000);
        colText.getColumn().setText(titles[3]);
        colText.getColumn().setWidth(bounds[3]);
        colText.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((PageElement)element).getContent();
            }
        });
        TableViewerColumn colMp3 = new TableViewerColumn(viewer, 0x1000000);
        colMp3.getColumn().setText(titles[4]);
        colMp3.getColumn().setWidth(bounds[4]);
        colMp3.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                PageElement ce = (PageElement)element;
                return ce.getMp3FileName() != null ? ce.getMp3FileName() : "";
            }
        });
        TableViewerColumn colStatus = new TableViewerColumn(viewer, 0x1000000);
        colStatus.getColumn().setText(titles[5]);
        colStatus.getColumn().setWidth(bounds[5]);
        colStatus.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((PageElement)element).getStatus();
            }
        });
        TableViewerColumn colAction = new TableViewerColumn(viewer, 0x1000000);
        colAction.getColumn().setText(titles[6]);
        colAction.getColumn().setWidth(bounds[6]);
        colAction.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
    }

    private void getData(Shell shell, String path) {
        System.out.println("getData : " + path);
        String fileFullPath = EpubBuildUtil.getProjectFullPath();
        String chapterXhtmlPath = fileFullPath + path;
        System.out.println("chapterXhtmlPath : " + chapterXhtmlPath);
        File file = new File(chapterXhtmlPath);
        this.elementList = XHTMLParser.parseXhtml(file);
        this.tableViewer.setInput(this.elementList);
        this.updateConversionStatusFromAudioFolder();
        this.applyFilter();
    }

    private void convertTextToMp3UsingGoogleTTS(String fileName, String text, GoogleTtsUtil.VoiceGender gender, Runnable onSuccess) throws IOException {
        File outFile;
        boolean success;
        String audioPath = EpubBuildUtil.getProjectAudioPath();
        System.out.println("audioPath : " + audioPath);
        File outDir = new File(audioPath);
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        if ((success = GoogleTtsUtil.synthesizeToFile(text, (outFile = new File(outDir, fileName)).getAbsolutePath(), gender)) && onSuccess != null) {
            System.out.println("MP3 \ud30c\uc77c \uc0dd\uc131\ub428: " + outFile.getAbsolutePath());
            onSuccess.run();
        }
    }

    private void refreshXhtmlParse(String targetXhtml) {
        String fileFullPath = EpubBuildUtil.getProjectFullPath();
        String chapterXhtmlPath = fileFullPath + "/OEBPS/Text/" + targetXhtml;
        System.out.println("chapterXhtmlPath : " + chapterXhtmlPath);
        File file = new File(chapterXhtmlPath);
        if (!file.exists()) {
            MessageDialog.openError((Shell)this.tableViewer.getControl().getShell(), (String)"\uc624\ub958", (String)(targetXhtml + " \ud30c\uc77c\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4."));
            return;
        }
        List<PageElement> parsedList = XHTMLParser.parseXhtml(file);
        String audioFolderPath = EpubBuildUtil.getProjectAudioPath();
        File audioDir = new File(audioFolderPath);
        Set mp3Files = Arrays.stream(audioDir.listFiles((dir, name) -> name.endsWith(".mp3"))).map(File::getName).collect(Collectors.toSet());
        for (PageElement item : parsedList) {
            if (item.getMp3FileName() != null && mp3Files.contains(item.getMp3FileName())) {
                item.setStatus("\ubcc0\ud658\ub428");
                continue;
            }
            item.setStatus("\ubbf8\uc644\ub8cc");
        }
        this.elementList = parsedList;
        this.tableViewer.setInput(this.elementList);
        this.tableViewer.refresh();
    }

    private void updateConversionStatusFromAudioFolder() {
        String audioFolderPath = EpubBuildUtil.getProjectAudioPath();
        System.out.println("audioFolderPath : " + audioFolderPath);
        File audioDir = new File(audioFolderPath);
        if (!audioDir.exists() || !audioDir.isDirectory()) {
            return;
        }
        Set mp3Files = Arrays.stream(audioDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".mp3"))).map(File::getName).collect(Collectors.toSet());
        List elements = (List)this.tableViewer.getInput();
        for (PageElement item : elements) {
            System.out.println("item.getMp3FileName() : " + item.getId());
            String mp3FileName = item.getId() + ".mp3";
            if (mp3Files.contains(mp3FileName)) {
                item.setStatus("\ubcc0\ud658\ub428");
                item.setMp3File(mp3FileName);
                continue;
            }
            item.setStatus("\ubbf8\uc644\ub8cc");
        }
        this.tableViewer.refresh();
        this.applyFilter();
    }

    private void applyUsageTTS() {
        int remaining = TtsUsageTracker.getRemainingChars();
        this.remainingLabel.setText("\ub0a8\uc740 \ubb38\uc790 \uc218: " + remaining);
    }

    private void applyFilter() {
        for (TableEditor editor : this.editors) {
            if (editor.getEditor() != null && !editor.getEditor().isDisposed()) {
                editor.getEditor().dispose();
            }
            editor.dispose();
        }
        this.editors.clear();
        this.tableViewer.getTable().removeAll();
        this.tableViewer.setInput(this.elementList);
        Table table = this.tableViewer.getTable();
        TableItem[] itemsArr = table.getItems();
        int i = 0;
        while (i < itemsArr.length) {
            TableItem item = itemsArr[i];
            PageElement pageElement = (PageElement)item.getData();
            TableEditor openEditor = new TableEditor(table);
            Button openBtn = new Button((Composite)table, 8);
            if (!"\ubcc0\ud658\ub428".equals(pageElement.getStatus())) {
                openBtn.setText("MP3 \ubcc0\ud658");
                openBtn.pack();
                openEditor.grabHorizontal = true;
                openEditor.setEditor((Control)openBtn, item, 6);
                this.editors.add(openEditor);
                openBtn.addListener(13, e -> this.convertData(openBtn, pageElement));
            } else {
                openBtn.setText("\uc7ac\uc0dd");
                openBtn.addListener(13, e -> this.audioPlay(pageElement));
                openEditor.grabHorizontal = true;
                openEditor.setEditor((Control)openBtn, item, 6);
                this.editors.add(openEditor);
            }
            ++i;
        }
        this.tableViewer.refresh();
    }

    private void convertData(Button btn, PageElement pageElement) {
        String selected;
        System.out.println("convertData() \ubcc0\ud658 \uc2dc\uc791\ud558\uae30");
        Composite cellComposite = new Composite((Composite)this.tableViewer.getTable(), 0);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.marginLeft = 0;
        rowLayout.spacing = 5;
        cellComposite.setLayout((Layout)rowLayout);
        if (!pageElement.isTextConvertible()) {
            System.out.println("convertData() \ubcc0\ud658 > Return");
            return;
        }
        Combo genderCombo = new Combo(cellComposite, 8);
        genderCombo.setItems(new String[]{"\uc911\ub9bd", "\ub0a8\uc131", "\uc5ec\uc131"});
        genderCombo.select(0);
        Label statusLabel = new Label(cellComposite, 0);
        statusLabel.setText("");
        pageElement.setStatus("\ud83d\udd04 \ubcc0\ud658 \uc911...");
        this.tableViewer.refresh();
        String mp3FileName = pageElement.getId() + ".mp3";
        System.out.println("mp3FileName : " + mp3FileName);
        GoogleTtsUtil.VoiceGender gender = switch (selected = genderCombo.getText()) {
            case "\ub0a8\uc131" -> GoogleTtsUtil.VoiceGender.MALE;
            case "\uc5ec\uc131" -> GoogleTtsUtil.VoiceGender.FEMALE;
            default -> GoogleTtsUtil.VoiceGender.NEUTRAL;
        };
        System.out.println("gender : " + gender.name());
        String text = pageElement.getContent();
        System.out.println("\ubcc0\ud658\uae00\uc790 : " + text);
        int textLength = text.length();
        if (!TtsUsageTracker.canConvert(textLength)) {
            MessageDialog.openWarning((Shell)this.tableViewer.getControl().getShell(), (String)"TTS \uc81c\ud55c \ucd08\uacfc", (String)("\ud558\ub8e8 \ubb34\ub8cc \ud55c\ub3c4(400\ub9cc\uc790)\ub97c \ucd08\uacfc\ud588\uc2b5\ub2c8\ub2e4.\n\ub0a8\uc740 \ubb38\uc790 \uc218: " + TtsUsageTracker.getRemainingChars()));
            return;
        }
        statusLabel.setText("\ubcc0\ud658 \uc911...");
        Display.getDefault().asyncExec(() -> {
            try {
                this.convertTextToMp3UsingGoogleTTS(mp3FileName, pageElement.getContent(), gender, () -> {
                    TtsUsageTracker.addCount(textLength);
                    pageElement.setMp3File(mp3FileName);
                    pageElement.setStatus("\ubcc0\ud658\ub428");
                    statusLabel.setText("\ubcc0\ud658\ub428");
                    btn.setText("\uc7ac\uc0dd");
                    this.applyUsageTTS();
                    this.applyFilter();
                    this.applyOpf(mp3FileName);
                });
            }
            catch (Exception exception) {
                Display.getDefault().asyncExec(() -> pageElement.setStatus("\u274c \uc624\ub958"));
            }
        });
        this.tableViewer.refresh();
    }

    private void applyOpf(String fileName) {
        String projectName = EpubPreferenceManager.getInstance().getProjectName();
        boolean addSpine = false;
        IFolder iFolder = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFolder("OEBPS/Audio");
        String href = iFolder.getProjectRelativePath().append(fileName).toString().substring("OEBPS/".length());
        String id = fileName.replaceAll("[^a-zA-Z0-9]", "_");
        boolean addToScripted = true;
        boolean addToLinearNo = false;
        OpfNcxUpdater.addFileToOpf(iFolder.getProject().getFile("OEBPS/content.opf"), id, href, OpfNcxUpdater.getMediaType(fileName), addSpine, addToScripted, addToLinearNo);
    }

    private void audioPlay(PageElement pageElement) {
        System.out.println("\uc5ec\uae30\uc5d0\uc11c audioPlay \ucc98\ub9ac\ud558\uae30 > " + pageElement.getMp3FileName());
        String audioFile = EpubBuildUtil.getProjectAudioPath() + "/" + pageElement.getMp3FileName();
        Mp3PlayerDialog dialog = new Mp3PlayerDialog(this.tableViewer.getControl().getShell(), audioFile, pageElement.getContent());
        dialog.open();
    }
}

