/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.parts.imagefx;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kr.co.goms.epub.ai.imagefx.Image;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ImageFXResultViewPart {
    public static final String TRANSIENT_KEY_RESULT_ID = "message";
    @Inject
    MPart part;
    @Inject
    @Optional
    private EPartService partService;
    @Inject
    @Optional
    private MPart selfPart;
    private ScrolledComposite scroller;
    private Composite gallery;
    private List<Image> generatedImages = new ArrayList<Image>();

    @PostConstruct
    public void create(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        String title = (String)this.part.getTransientData().get("title");
        List imgs = (List)this.part.getTransientData().get("img");
        System.out.println("title : " + title);
        System.out.println("generatedImages.size() : " + this.generatedImages.size());
        this.scroller = new ScrolledComposite(parent, 2816);
        this.scroller.setLayoutData((Object)new GridData(4, 4, true, true));
        this.gallery = new Composite((Composite)this.scroller, 0);
        this.gallery.setLayout((Layout)new GridLayout(1, true));
        this.scroller.setContent((Control)this.gallery);
        this.scroller.setExpandHorizontal(true);
        this.scroller.setExpandVertical(true);
        this.showImages(imgs);
    }

    @PreDestroy
    public void preDestroy() {
        this.clearGallery();
    }

    @Focus
    public void onFocus() {
        if (this.gallery != null && !this.gallery.isDisposed()) {
            this.gallery.setFocus();
        }
    }

    private void showImages(List<Image> imgs) {
        this.clearGallery();
        this.generatedImages.clear();
        this.generatedImages.addAll(imgs);
        Display dsp = this.gallery.getDisplay();
        int n = Math.min(imgs.size(), 4);
        if (n == 0) {
            this.gallery.layout(true, true);
            this.scroller.setMinSize(this.gallery.computeSize(-1, -1));
            return;
        }
        int cols = n == 1 ? 1 : (n == 2 ? 2 : 2);
        int rows = (int)Math.ceil((double)n / (double)cols);
        GridLayout gl = new GridLayout(cols, true);
        gl.marginWidth = 8;
        gl.marginHeight = 8;
        gl.horizontalSpacing = 8;
        gl.verticalSpacing = 8;
        this.gallery.setLayout((Layout)gl);
        ArrayList<Label> labels = new ArrayList<Label>(n);
        int i = 0;
        while (i < n) {
            try {
                Path saved = imgs.get(i).save("./temp");
                org.eclipse.swt.graphics.Image swtOrig = new org.eclipse.swt.graphics.Image((Device)dsp, saved.toString());
                Label lbl = new Label(this.gallery, 2048);
                lbl.setLayoutData((Object)new GridData(4, 4, true, true));
                lbl.setData("orig", (Object)swtOrig);
                lbl.addListener(12, e -> {
                    org.eclipse.swt.graphics.Image scaled;
                    org.eclipse.swt.graphics.Image orig = (org.eclipse.swt.graphics.Image)lbl.getData("orig");
                    if (orig != null && !orig.isDisposed()) {
                        orig.dispose();
                    }
                    if ((scaled = (org.eclipse.swt.graphics.Image)lbl.getData("scaled")) != null && !scaled.isDisposed()) {
                        scaled.dispose();
                    }
                });
                lbl.addListener(3, ev -> {
                    FileDialog sd = new FileDialog(this.gallery.getShell(), 8192);
                    sd.setFileName("image-" + System.currentTimeMillis() + ".png");
                    String out = sd.open();
                    if (out != null) {
                        try {
                            ((Image)imgs.get(labels.indexOf(lbl))).save(Path.of(out, new String[0]).getParent().toString());
                            MessageDialog.openInformation((Shell)this.gallery.getShell(), (String)"Saved", (String)("Saved to: " + out));
                        }
                        catch (RuntimeException ex) {
                            MessageDialog.openError((Shell)this.gallery.getShell(), (String)"Save Failed", (String)ex.getMessage());
                        }
                    }
                });
                labels.add(lbl);
            }
            catch (Exception exception) {
                ImageData data = new ImageData(1, 1, 32, new PaletteData(0xFF0000, 65280, 255));
                Label fallback = new Label(this.gallery, 2048);
                fallback.setLayoutData((Object)new GridData(4, 4, true, true));
                fallback.setImage(new org.eclipse.swt.graphics.Image((Device)dsp, data));
                labels.add(fallback);
            }
            ++i;
        }
        this.scaleAllLabelsToGrid(this.gallery, labels, cols, rows, gl);
        this.gallery.layout(true, true);
        this.scroller.setMinSize(this.gallery.computeSize(-1, -1));
        Listener prev = (Listener)this.gallery.getData("resizeListener");
        if (prev != null) {
            try {
                this.gallery.removeListener(11, prev);
            }
            catch (Exception exception) {}
        }
        Listener rs = e -> {
            GridLayout g;
            if (this.gallery.isDisposed()) {
                return;
            }
            List<Label> alive = Arrays.stream(this.gallery.getChildren()).filter(c -> c instanceof Label && !c.isDisposed()).map(c -> (Label)c).toList();
            if (alive.isEmpty()) {
                return;
            }
            int nAlive = alive.size();
            int c2 = nAlive == 1 ? 1 : (nAlive == 2 ? 2 : 2);
            int r = (int)Math.ceil((double)nAlive / (double)c2);
            Layout layout = this.gallery.getLayout();
            GridLayout gNow = layout instanceof GridLayout ? (g = (GridLayout)layout) : new GridLayout(c2, true);
            this.scaleAllLabelsToGrid(this.gallery, alive, c2, r, gNow);
            this.gallery.layout(true, true);
            this.scroller.setMinSize(this.gallery.computeSize(-1, -1));
        };
        this.gallery.addListener(11, rs);
        this.gallery.setData("resizeListener", (Object)rs);
    }

    private void scaleAllLabelsToGrid(Composite gallery, List<Label> labels, int cols, int rows, GridLayout gl) {
        if (gallery == null || gallery.isDisposed()) {
            return;
        }
        Rectangle area = gallery.getClientArea();
        if (area.width <= 0 || area.height <= 0) {
            area = new Rectangle(0, 0, 800, 600);
        }
        int cellW = Math.max(32, (area.width - gl.marginWidth * 2 - gl.horizontalSpacing * (cols - 1)) / cols);
        int cellH = Math.max(32, (area.height - gl.marginHeight * 2 - gl.verticalSpacing * (rows - 1)) / rows);
        for (Label lbl : labels) {
            org.eclipse.swt.graphics.Image orig;
            if (lbl == null || lbl.isDisposed() || (orig = (org.eclipse.swt.graphics.Image)lbl.getData("orig")) == null || orig.isDisposed()) continue;
            org.eclipse.swt.graphics.Image prev = (org.eclipse.swt.graphics.Image)lbl.getData("scaled");
            if (prev != null && !prev.isDisposed()) {
                prev.dispose();
            }
            org.eclipse.swt.graphics.Image scaled = ImageFXResultViewPart.scaleToFit(gallery.getDisplay(), orig, cellW, cellH);
            if (!lbl.isDisposed()) {
                lbl.setImage(scaled);
                lbl.setData("scaled", (Object)scaled);
                continue;
            }
            if (scaled == null || scaled.isDisposed()) continue;
            scaled.dispose();
        }
    }

    private static org.eclipse.swt.graphics.Image scaleToFit(Display display, org.eclipse.swt.graphics.Image src, int maxW, int maxH) {
        Rectangle r = src.getBounds();
        double sx = (double)maxW / (double)r.width;
        double sy = (double)maxH / (double)r.height;
        double s = Math.min(sx, sy);
        int w = Math.max(1, (int)Math.floor((double)r.width * s));
        int h = Math.max(1, (int)Math.floor((double)r.height * s));
        return new org.eclipse.swt.graphics.Image((Device)display, src.getImageData().scaledTo(w, h));
    }

    public static void updateGallery(Composite gallery, List<org.eclipse.swt.graphics.Image> images) {
        Display display = gallery.getDisplay();
        Control[] controlArray = gallery.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        int n3 = Math.min(images.size(), 4);
        if (n3 == 0) {
            gallery.layout();
            return;
        }
        int cols = n3 == 1 ? 1 : (n3 == 2 ? 2 : 2);
        int rows = (int)Math.ceil((double)n3 / (double)cols);
        GridLayout gl = new GridLayout(cols, true);
        gl.marginWidth = 8;
        gl.marginHeight = 8;
        gl.horizontalSpacing = 8;
        gl.verticalSpacing = 8;
        gallery.setLayout((Layout)gl);
        Rectangle ca = gallery.getClientArea();
        int cellW = Math.max(64, (ca.width - gl.marginWidth * 2 - gl.horizontalSpacing * (cols - 1)) / cols);
        int cellH = Math.max(64, (ca.height - gl.marginHeight * 2 - gl.verticalSpacing * (rows - 1)) / rows);
        int i = 0;
        while (i < n3) {
            org.eclipse.swt.graphics.Image src = images.get(i);
            Label lbl = new Label(gallery, 2048);
            lbl.setLayoutData((Object)new GridData(4, 4, true, true));
            org.eclipse.swt.graphics.Image scaled = ImageFXResultViewPart.scaleToFit(display, src, cellW, cellH);
            lbl.addListener(12, e -> {
                if (scaled != null && !scaled.isDisposed()) {
                    scaled.dispose();
                }
            });
            lbl.setImage(scaled);
            ++i;
        }
        gallery.layout();
        gallery.addListener(11, e -> ImageFXResultViewPart.updateGallery(gallery, images));
    }

    private void clearGallery() {
        Listener prev = (Listener)this.gallery.getData("resizeListener");
        if (prev != null) {
            try {
                this.gallery.removeListener(11, prev);
            }
            catch (Exception exception) {}
            this.gallery.setData("resizeListener", null);
        }
        Control[] controlArray = this.gallery.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof Label) {
                org.eclipse.swt.graphics.Image orig;
                Label lbl = (Label)c;
                org.eclipse.swt.graphics.Image scaled = (org.eclipse.swt.graphics.Image)lbl.getData("scaled");
                if (scaled != null && !scaled.isDisposed()) {
                    scaled.dispose();
                }
                if ((orig = (org.eclipse.swt.graphics.Image)lbl.getData("orig")) != null && !orig.isDisposed()) {
                    orig.dispose();
                }
            }
            c.dispose();
            ++n2;
        }
    }
}

