/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.parts.imagefx;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kr.co.goms.epub.ai.imagefx.Constants;
import kr.co.goms.epub.ai.imagefx.Image;
import kr.co.goms.epub.ai.imagefx.ImageFX;
import kr.co.goms.epub.ai.imagefx.Prompt;
import kr.co.goms.epub.ai.imagefx.PromptArg;
import kr.co.goms.epub.managers.EpubPartManager;
import kr.co.goms.epub.solution.parts.GomsLogPart;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class ImageFXViewPart {
    private Text txtCookie;
    private Text txtPromptStyle;
    private Text txtPromptDesc;
    private Combo comboPromptStyle;
    private Combo comboModel;
    private Combo comboRatio;
    private Spinner spinCount;
    private Spinner spinSeed;
    private Button btnGenerate;
    private Button btnSaveAll;
    private Text txtMediaId;
    private Button btnFetchId;
    private Text txtCaptionCount;
    private Button btnCaption;
    private ScrolledComposite scroller;
    private Composite gallery;
    private Label lblStatus;
    private ProgressBar progressBar;
    private ImageFX imageFX;
    private final ExecutorService ioPool = Executors.newFixedThreadPool(3);
    private final List<Image> generatedImages = new ArrayList<Image>();
    @Inject
    private EPartService partService;
    @Inject
    IEclipseContext context;
    @Inject
    EModelService modelService;
    @Inject
    MApplication application;

    @PostConstruct
    public void create(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite top = new Composite(parent, 0);
        top.setLayoutData((Object)new GridData(4, 128, true, false));
        top.setLayout((Layout)new GridLayout(8, false));
        ((GridLayout)top.getLayout()).numColumns = 8;
        new Label(top, 0).setText("Cookie");
        this.txtCookie = new Text(top, 0x400800);
        this.txtCookie.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 7, 1));
        new Label(top, 0).setText("Style");
        Composite styleRow = new Composite(top, 0);
        styleRow.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 7, 1));
        styleRow.setLayout((Layout)new GridLayout(2, false));
        this.comboPromptStyle = new Combo(styleRow, 12);
        GridData gdStyle = new GridData(1, 0x1000000, false, false);
        gdStyle.widthHint = Math.max(220, styleRow.getClientArea().width / 2);
        this.comboPromptStyle.setLayoutData((Object)gdStyle);
        this.comboPromptStyle.setItems(new String[]{Constants.PromptStyle.FLAT_VECTOR_ILLUSTRATION.name(), Constants.PromptStyle.HYBRID_KOREA_INK_WASH.name(), Constants.PromptStyle.MINIMAL_PASTEL_ILLUSTRATION.name(), Constants.PromptStyle.CINEMATIC_REALISM.name(), Constants.PromptStyle.TRADITIONAL_INK_BRUSH.name(), Constants.PromptStyle.SILVER_TOWN_BRUSH.name()});
        this.comboPromptStyle.select(0);
        this.comboPromptStyle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selected = ImageFXViewPart.this.comboPromptStyle.getText();
                try {
                    Constants.PromptStyle style = Constants.PromptStyle.valueOf(selected);
                    ImageFXViewPart.this.txtPromptStyle.setText(style.getValue());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ImageFXViewPart.this.txtPromptStyle.setText("");
                }
            }
        });
        new Label(styleRow, 0).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        styleRow.addListener(11, e -> {
            int w = composite.getClientArea().width;
            gridData.widthHint = Math.max(220, w / 2);
            styleRow.layout(true, true);
        });
        new Label(top, 0).setText("");
        this.txtPromptStyle = new Text(top, 2626);
        GridData gdPromptStyle = new GridData(4, 128, true, false, 7, 1);
        gdPromptStyle.heightHint = 70;
        this.txtPromptStyle.setLayoutData((Object)gdPromptStyle);
        new Label(top, 0).setText("Desc");
        this.txtPromptDesc = new Text(top, 2626);
        GridData gdPromptDesc = new GridData(4, 128, true, false, 7, 1);
        gdPromptDesc.heightHint = 40;
        this.txtPromptDesc.setLayoutData((Object)gdPromptDesc);
        new Label(top, 0).setText("Model");
        this.comboModel = new Combo(top, 12);
        this.comboModel.setItems(new String[]{Constants.Model.IMAGEN_3.name(), Constants.Model.IMAGEN_3_1.name(), Constants.Model.IMAGEN_3_5.name()});
        this.comboModel.select(2);
        new Label(top, 0).setText("Aspect");
        this.comboRatio = new Combo(top, 12);
        this.comboRatio.setItems(new String[]{Constants.AspectRatio.SQUARE.name(), Constants.AspectRatio.PORTRAIT.name(), Constants.AspectRatio.LANDSCAPE.name(), Constants.AspectRatio.UNSPECIFIED.name()});
        this.comboRatio.select(2);
        new Label(top, 0).setText("#Images");
        this.spinCount = new Spinner(top, 2048);
        this.spinCount.setMinimum(1);
        this.spinCount.setMaximum(4);
        this.spinCount.setSelection(1);
        new Label(top, 0).setText("Seed");
        this.spinSeed = new Spinner(top, 2048);
        this.spinSeed.setMinimum(0);
        this.spinSeed.setMaximum(Integer.MAX_VALUE);
        this.spinSeed.setSelection(0);
        this.btnGenerate = new Button(top, 8);
        this.btnGenerate.setText("Generate");
        this.btnSaveAll = new Button(top, 8);
        this.btnSaveAll.setText("Save All");
        this.scroller = new ScrolledComposite(parent, 2816);
        this.scroller.setLayoutData((Object)new GridData(4, 4, true, true));
        this.gallery = new Composite((Composite)this.scroller, 0);
        this.gallery.setLayout((Layout)new GridLayout(3, true));
        this.scroller.setContent((Control)this.gallery);
        this.scroller.setExpandHorizontal(true);
        this.scroller.setExpandVertical(true);
        this.createStatusArea(parent);
        String sampleCookie = "__Host-next-auth.csrf-token=eaf4a51f71d792abeefc102a6115beac8f97bbdec8b70e39bdf4e1bcf35ad041%7Ce8ccebff6369e84d328ba4837d20ffe365f81599740fd8383fd001b8231e7f1e;__Secure-next-auth.callback-url=https%3A%2F%2Flabs.google%2Ffx%2Fko%2Ftools%2Fimage-fx;__Secure-next-auth.session-token=eyJhbGciOiJkaXIiLCJlbmMiOiJBMjU2R0NNIn0..R8AehSAFnji5sC5v.BeBtLgeE160hQVGN5d0mGGvvvT1Ro3vDJqx4uIvI4wsF84k1zry7w6cfGb7oCTPVKL50ZX_PmW-23uVuwJERYMstPwO0RhutfMQeUb3TOJ40cVKblOQwMgVgnE1a_MyJ8jNFQLZ29SxoycQlirFi9t668rT6w5SocWC0XFuy1G_TWvCPOGRjrdnRCqM2AsALOhglFKJg5K5_A9e-xlLtx4Bbiq--VPA6UOEjCcXlz031pMNJ6MCRxExZ2EgkTldq5HKwDYA6iQdGR6KN7Fq0amV78VhlefsNgwz8tdFGplghtjBJJArc4-2qVz9LPhoxW471HfBWixE9PrVdcKjFrqlG23AOOBj7RaG3u8xwZB-JcP0TByvQigMJgR_jMLJtXmuMDxj_ygCI9Xwy31127XUoCH4DBqk-hmRyQlJBPaveIK7HsOkWSfA3psNaMBiziSzr8crx47Khk4nHKbdx_HF3cg4AwnBfB-b6cRuIhbcZHpEwFgrHRekwxLXBKTSsPL26jvTJx4Tp3wkpTpU9Pr5xYDvCYjpx7hw0R4wEOz2QCdgeJbU0xHHViDoUTPFj8rSYYaFRj7bEc8h8MAvz5Xw77r5ulH2Ec-AkuDh_0swr0XTSX9egvvH1yTrqhhRwqsszo3nwJrnlPamb1Ocep-UeILRhrWpyxtJy046oXhRcY6SihCbIJR5CIo8wXZ45TuJwbYXg3ON5HHnJQJKALs6NWcRRzB-RXcpkWmUZ8TCnO77FcqL27DLtZjlQlbpgaLAr-QbfbehU91xzsr9vqH5ZFFlOZ2rtLr574RBcn-uDfotvXDxiZWD5EB9t-4dfkwtJm50IoWbiXkRj9yN0rH03V5pzyiBrKnW1Ixkb0jwgfI2G6Notd2FE4X9IfzCsF75H_DmjJjs8wDQLoTCIedzBEE8CHFSiL_rPJ5sCSMeQhoGkMGfKhJnoJbmCgRdpIEp73S8Y989s-7oePmVkMlTzJTKemw._bXxlDY2MSjCTMoPdWVSUA";
        this.txtCookie.setText(sampleCookie);
        this.txtPromptStyle.setText(Constants.PromptStyle.valueOf(this.comboPromptStyle.getText()).getValue());
        this.btnGenerate.addListener(13, e -> this.onGenerate());
        this.btnSaveAll.addListener(13, e -> this.onSaveAll());
    }

    private void onGenerate() {
        String cookie = this.txtCookie.getText().trim();
        String promptStyle = this.txtPromptStyle.getText().trim();
        String promptDesc = this.txtPromptDesc.getText().trim();
        if (cookie.isEmpty()) {
            MessageDialog.openWarning((Shell)this.gallery.getShell(), (String)"Cookie Missing", (String)"Cookie is required.");
            return;
        }
        if (promptStyle.isEmpty()) {
            MessageDialog.openWarning((Shell)this.gallery.getShell(), (String)"PromptStyle Missing", (String)"Prompt Style cannot be empty.");
            return;
        }
        if (promptDesc.isEmpty()) {
            MessageDialog.openWarning((Shell)this.gallery.getShell(), (String)"Prompt Desc Missing", (String)"Prompt Desc cannot be empty.");
            return;
        }
        this.setStatus("Generating images...");
        this.btnGenerate.setEnabled(false);
        this.progressBar.setVisible(true);
        PromptArg arg = new PromptArg();
        arg.prompt = promptStyle + " " + promptDesc;
        arg.generationModel = Constants.Model.valueOf(this.comboModel.getText());
        arg.aspectRatio = Constants.AspectRatio.fromValue(this.comboRatio.getText());
        arg.numberOfImages = this.spinCount.getSelection();
        arg.seed = this.spinSeed.getSelection();
        Prompt prompt = new Prompt(arg);
        System.out.println("================== \uc774\ubbf8\uc9c0 \uc0dd\uc131\uc744 \uc2e4\ud589\ud569\ub2c8\ub2e4 ================== ");
        System.out.println("Prompt : " + String.valueOf(prompt));
        GomsLogPart.log("Cookie : " + cookie);
        this.ioPool.submit(() -> {
            block5: {
                try {
                    try {
                        this.ensureImageFX(cookie);
                        List<Image> list = this.imageFX.generateImage(prompt, 2);
                        this.async(() -> {
                            this.setStatus("Generated " + list.size() + " image(s).");
                            this.resultImageViewPart(list);
                        });
                    }
                    catch (RuntimeException ex) {
                        this.async(() -> {
                            System.out.println(ex.getMessage());
                            MessageDialog.openError((Shell)this.gallery.getShell(), (String)"Generate Failed", (String)ex.getMessage());
                        });
                        this.async(() -> {
                            this.progressBar.setVisible(false);
                            this.btnGenerate.setEnabled(true);
                        });
                        break block5;
                    }
                }
                catch (Throwable throwable) {
                    this.async(() -> {
                        this.progressBar.setVisible(false);
                        this.btnGenerate.setEnabled(true);
                    });
                    throw throwable;
                }
                this.async(() -> {
                    this.progressBar.setVisible(false);
                    this.btnGenerate.setEnabled(true);
                });
            }
        });
    }

    private void onSaveAll() {
        if (this.generatedImages.isEmpty()) {
            MessageDialog.openInformation((Shell)this.gallery.getShell(), (String)"Nothing to Save", (String)"No images to save.");
            return;
        }
        DirectoryDialog dd = new DirectoryDialog(this.gallery.getShell());
        dd.setText("Choose folder to save all images");
        String dir = dd.open();
        if (dir == null) {
            return;
        }
        this.setStatus("Saving images...");
        this.ioPool.submit(() -> {
            int ok = 0;
            for (Image img : this.generatedImages) {
                try {
                    img.save(dir);
                    ++ok;
                }
                catch (RuntimeException runtimeException) {}
            }
            int saved = ok;
            this.async(() -> this.setStatus("Saved " + saved + " image(s) to: " + dir));
        });
    }

    private void onFetchById() {
        String cookie = this.txtCookie.getText().trim();
        String mediaId = this.txtMediaId.getText().trim();
        if (cookie.isEmpty()) {
            MessageDialog.openWarning((Shell)this.gallery.getShell(), (String)"Cookie Missing", (String)"Cookie is required.");
            return;
        }
        if (mediaId.isEmpty()) {
            MessageDialog.openWarning((Shell)this.gallery.getShell(), (String)"ID Missing", (String)"mediaId is required.");
            return;
        }
        this.ensureImageFX(cookie);
        this.setStatus("Fetching image by ID...");
        this.btnFetchId.setEnabled(false);
        this.ioPool.submit(() -> {
            block5: {
                try {
                    try {
                        Image img = this.imageFX.getImageFromId(mediaId);
                        this.async(() -> {
                            this.setStatus("Fetched image.");
                            this.showImages(List.of(img));
                        });
                    }
                    catch (RuntimeException ex) {
                        this.async(() -> MessageDialog.openError((Shell)this.gallery.getShell(), (String)"Fetch Failed", (String)ex.getMessage()));
                        this.async(() -> this.btnFetchId.setEnabled(true));
                        break block5;
                    }
                }
                catch (Throwable throwable) {
                    this.async(() -> this.btnFetchId.setEnabled(true));
                    throw throwable;
                }
                this.async(() -> this.btnFetchId.setEnabled(true));
            }
        });
    }

    private void onCaptionFromImage() {
        String cookie = this.txtCookie.getText().trim();
        if (cookie.isEmpty()) {
            MessageDialog.openWarning((Shell)this.gallery.getShell(), (String)"Cookie Missing", (String)"Cookie is required.");
            return;
        }
        this.ensureImageFX(cookie);
        FileDialog fd = new FileDialog(this.gallery.getShell(), 4096);
        fd.setText("Choose an image to caption");
        fd.setFilterExtensions(new String[]{"*.png;*.jpg;*.jpeg;*.webp;*.bmp;*.gif;*.tiff"});
        String path = fd.open();
        if (path == null) {
            return;
        }
        int count = 1;
        try {
            count = Integer.parseInt(this.txtCaptionCount.getText().trim());
        }
        catch (Exception exception) {}
        this.setStatus("Generating caption(s)...");
        this.btnCaption.setEnabled(false);
        int want = count;
        this.ioPool.submit(() -> {
            block5: {
                try {
                    try {
                        List<String> caps = this.imageFX.generateCaptionsFromImage(path, Constants.ImageType.PNG, want);
                        this.async(() -> {
                            this.setStatus("Captions ready.");
                            MessageDialog.openInformation((Shell)this.gallery.getShell(), (String)"Captions", (String)String.join((CharSequence)"\n\n", caps));
                        });
                    }
                    catch (RuntimeException ex) {
                        this.async(() -> MessageDialog.openError((Shell)this.gallery.getShell(), (String)"Caption Failed", (String)ex.getMessage()));
                        this.async(() -> this.btnCaption.setEnabled(true));
                        break block5;
                    }
                }
                catch (Throwable throwable) {
                    this.async(() -> this.btnCaption.setEnabled(true));
                    throw throwable;
                }
                this.async(() -> this.btnCaption.setEnabled(true));
            }
        });
    }

    private void resultImageViewPart(List<Image> imgs) {
        this.tmpSaveImage(imgs);
        String targetContributionURI = "ImageFXResultViewPart";
        String title = "\uc774\ubbf8\uc9c0 \uacb0\uacfc\ubcf4\uae30";
        EpubPartManager.getInstance().addImageFXResultViewPart(this.application, this.partService, this.modelService, targetContributionURI, title, imgs);
    }

    private void tmpSaveImage(List<Image> imgs) {
        this.clearGallery();
        this.generatedImages.clear();
        this.generatedImages.addAll(imgs);
    }

    private void showImages(List<Image> imgs) {
        this.clearGallery();
        this.generatedImages.clear();
        this.generatedImages.addAll(imgs);
        Display dsp = this.gallery.getDisplay();
        int n = Math.min(imgs.size(), 4);
        if (n == 0) {
            this.gallery.layout(true, true);
            this.scroller.setMinSize(this.gallery.computeSize(-1, -1));
            return;
        }
        int cols = n == 1 ? 1 : (n == 2 ? 2 : 2);
        int rows = (int)Math.ceil((double)n / (double)cols);
        GridLayout gl = new GridLayout(cols, true);
        gl.marginWidth = 8;
        gl.marginHeight = 8;
        gl.horizontalSpacing = 8;
        gl.verticalSpacing = 8;
        this.gallery.setLayout((Layout)gl);
        ArrayList<Label> labels = new ArrayList<Label>(n);
        int i = 0;
        while (i < n) {
            try {
                Path saved = imgs.get(i).save("./temp");
                org.eclipse.swt.graphics.Image swtOrig = new org.eclipse.swt.graphics.Image((Device)dsp, saved.toString());
                Label lbl = new Label(this.gallery, 2048);
                lbl.setLayoutData((Object)new GridData(4, 4, true, true));
                lbl.setData("orig", (Object)swtOrig);
                lbl.addListener(12, e -> {
                    org.eclipse.swt.graphics.Image scaled;
                    org.eclipse.swt.graphics.Image orig = (org.eclipse.swt.graphics.Image)lbl.getData("orig");
                    if (orig != null && !orig.isDisposed()) {
                        orig.dispose();
                    }
                    if ((scaled = (org.eclipse.swt.graphics.Image)lbl.getData("scaled")) != null && !scaled.isDisposed()) {
                        scaled.dispose();
                    }
                });
                lbl.addListener(3, ev -> {
                    FileDialog sd = new FileDialog(this.gallery.getShell(), 8192);
                    sd.setFileName("image-" + System.currentTimeMillis() + ".png");
                    String out = sd.open();
                    if (out != null) {
                        try {
                            ((Image)imgs.get(labels.indexOf(lbl))).save(Path.of(out, new String[0]).getParent().toString());
                            MessageDialog.openInformation((Shell)this.gallery.getShell(), (String)"Saved", (String)("Saved to: " + out));
                        }
                        catch (RuntimeException ex) {
                            MessageDialog.openError((Shell)this.gallery.getShell(), (String)"Save Failed", (String)ex.getMessage());
                        }
                    }
                });
                labels.add(lbl);
            }
            catch (Exception exception) {
                ImageData data = new ImageData(1, 1, 32, new PaletteData(0xFF0000, 65280, 255));
                Label fallback = new Label(this.gallery, 2048);
                fallback.setLayoutData((Object)new GridData(4, 4, true, true));
                fallback.setImage(new org.eclipse.swt.graphics.Image((Device)dsp, data));
                labels.add(fallback);
            }
            ++i;
        }
        this.scaleAllLabelsToGrid(this.gallery, labels, cols, rows, gl);
        this.gallery.layout(true, true);
        this.scroller.setMinSize(this.gallery.computeSize(-1, -1));
        Listener prev = (Listener)this.gallery.getData("resizeListener");
        if (prev != null) {
            try {
                this.gallery.removeListener(11, prev);
            }
            catch (Exception exception) {}
        }
        Listener rs = e -> {
            GridLayout g;
            if (this.gallery.isDisposed()) {
                return;
            }
            List<Label> alive = Arrays.stream(this.gallery.getChildren()).filter(c -> c instanceof Label && !c.isDisposed()).map(c -> (Label)c).toList();
            if (alive.isEmpty()) {
                return;
            }
            int nAlive = alive.size();
            int c2 = nAlive == 1 ? 1 : (nAlive == 2 ? 2 : 2);
            int r = (int)Math.ceil((double)nAlive / (double)c2);
            Layout layout = this.gallery.getLayout();
            GridLayout gNow = layout instanceof GridLayout ? (g = (GridLayout)layout) : new GridLayout(c2, true);
            this.scaleAllLabelsToGrid(this.gallery, alive, c2, r, gNow);
            this.gallery.layout(true, true);
            this.scroller.setMinSize(this.gallery.computeSize(-1, -1));
        };
        this.gallery.addListener(11, rs);
        this.gallery.setData("resizeListener", (Object)rs);
    }

    private void scaleAllLabelsToGrid(Composite gallery, List<Label> labels, int cols, int rows, GridLayout gl) {
        if (gallery == null || gallery.isDisposed()) {
            return;
        }
        Rectangle area = gallery.getClientArea();
        if (area.width <= 0 || area.height <= 0) {
            area = new Rectangle(0, 0, 800, 600);
        }
        int cellW = Math.max(32, (area.width - gl.marginWidth * 2 - gl.horizontalSpacing * (cols - 1)) / cols);
        int cellH = Math.max(32, (area.height - gl.marginHeight * 2 - gl.verticalSpacing * (rows - 1)) / rows);
        for (Label lbl : labels) {
            org.eclipse.swt.graphics.Image orig;
            if (lbl == null || lbl.isDisposed() || (orig = (org.eclipse.swt.graphics.Image)lbl.getData("orig")) == null || orig.isDisposed()) continue;
            org.eclipse.swt.graphics.Image prev = (org.eclipse.swt.graphics.Image)lbl.getData("scaled");
            if (prev != null && !prev.isDisposed()) {
                prev.dispose();
            }
            org.eclipse.swt.graphics.Image scaled = ImageFXViewPart.scaleToFit(gallery.getDisplay(), orig, cellW, cellH);
            if (!lbl.isDisposed()) {
                lbl.setImage(scaled);
                lbl.setData("scaled", (Object)scaled);
                continue;
            }
            if (scaled == null || scaled.isDisposed()) continue;
            scaled.dispose();
        }
    }

    private static org.eclipse.swt.graphics.Image scaleToFit(Display display, org.eclipse.swt.graphics.Image src, int maxW, int maxH) {
        Rectangle r = src.getBounds();
        double sx = (double)maxW / (double)r.width;
        double sy = (double)maxH / (double)r.height;
        double s = Math.min(sx, sy);
        int w = Math.max(1, (int)Math.floor((double)r.width * s));
        int h = Math.max(1, (int)Math.floor((double)r.height * s));
        return new org.eclipse.swt.graphics.Image((Device)display, src.getImageData().scaledTo(w, h));
    }

    public static void updateGallery(Composite gallery, List<org.eclipse.swt.graphics.Image> images) {
        Display display = gallery.getDisplay();
        Control[] controlArray = gallery.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        int n3 = Math.min(images.size(), 4);
        if (n3 == 0) {
            gallery.layout();
            return;
        }
        int cols = n3 == 1 ? 1 : (n3 == 2 ? 2 : 2);
        int rows = (int)Math.ceil((double)n3 / (double)cols);
        GridLayout gl = new GridLayout(cols, true);
        gl.marginWidth = 8;
        gl.marginHeight = 8;
        gl.horizontalSpacing = 8;
        gl.verticalSpacing = 8;
        gallery.setLayout((Layout)gl);
        Rectangle ca = gallery.getClientArea();
        int cellW = Math.max(64, (ca.width - gl.marginWidth * 2 - gl.horizontalSpacing * (cols - 1)) / cols);
        int cellH = Math.max(64, (ca.height - gl.marginHeight * 2 - gl.verticalSpacing * (rows - 1)) / rows);
        int i = 0;
        while (i < n3) {
            org.eclipse.swt.graphics.Image src = images.get(i);
            Label lbl = new Label(gallery, 2048);
            lbl.setLayoutData((Object)new GridData(4, 4, true, true));
            org.eclipse.swt.graphics.Image scaled = ImageFXViewPart.scaleToFit(display, src, cellW, cellH);
            lbl.addListener(12, e -> {
                if (scaled != null && !scaled.isDisposed()) {
                    scaled.dispose();
                }
            });
            lbl.setImage(scaled);
            ++i;
        }
        gallery.layout();
        gallery.addListener(11, e -> ImageFXViewPart.updateGallery(gallery, images));
    }

    private void clearGallery() {
        Listener prev = (Listener)this.gallery.getData("resizeListener");
        if (prev != null) {
            try {
                this.gallery.removeListener(11, prev);
            }
            catch (Exception exception) {}
            this.gallery.setData("resizeListener", null);
        }
        Control[] controlArray = this.gallery.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof Label) {
                org.eclipse.swt.graphics.Image orig;
                Label lbl = (Label)c;
                org.eclipse.swt.graphics.Image scaled = (org.eclipse.swt.graphics.Image)lbl.getData("scaled");
                if (scaled != null && !scaled.isDisposed()) {
                    scaled.dispose();
                }
                if ((orig = (org.eclipse.swt.graphics.Image)lbl.getData("orig")) != null && !orig.isDisposed()) {
                    orig.dispose();
                }
            }
            c.dispose();
            ++n2;
        }
    }

    private void ensureImageFX(String cookie) {
        if (this.imageFX == null) {
            this.imageFX = new ImageFX(cookie);
        }
    }

    private void setStatus(String msg) {
        if (this.lblStatus == null || this.lblStatus.isDisposed()) {
            return;
        }
        this.lblStatus.setText(msg != null ? msg : "");
        this.lblStatus.getParent().layout(true, true);
    }

    private void createStatusArea(Composite parent) {
        Composite statusArea = new Composite(parent, 0);
        statusArea.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        statusArea.setLayout((Layout)new GridLayout(2, false));
        this.lblStatus = new Label(statusArea, 0);
        this.lblStatus.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.lblStatus.setText("Ready.");
        this.progressBar = new ProgressBar(statusArea, 2);
        this.progressBar.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.progressBar.setVisible(false);
    }

    private void async(Runnable r) {
        Display.getDefault().asyncExec(r);
    }

    @Focus
    public void onFocus() {
        if (this.txtPromptStyle != null && !this.txtPromptStyle.isDisposed()) {
            this.txtPromptStyle.setFocus();
        }
    }

    @PreDestroy
    public void dispose() {
        this.ioPool.shutdownNow();
    }
}

