/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.preferences;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EpubCreator {
    public void createEpub(IProject project) throws Exception {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("kr.co.goms.epub.solution");
        boolean generateUrnUuid = prefs.getBoolean("urnUuidGeneration", true);
        IFile contentOpf = project.getFile("OEBPS/content.opf");
        if (!contentOpf.exists()) {
            throw new IllegalStateException("content.opf \ud30c\uc77c\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        }
        Document doc = this.loadXml(contentOpf);
        if (generateUrnUuid) {
            String newUrnUuid = "urn:uuid:" + UUID.randomUUID().toString();
            NodeList identifiers = doc.getElementsByTagNameNS("*", "identifier");
            if (identifiers.getLength() > 0) {
                Element idElement = (Element)identifiers.item(0);
                idElement.setTextContent(newUrnUuid);
            } else {
                Element packageElem = doc.getDocumentElement();
                Element metadataElem = (Element)packageElem.getElementsByTagName("metadata").item(0);
                Element newId = doc.createElementNS("http://purl.org/dc/elements/1.1/", "dc:identifier");
                newId.setTextContent(newUrnUuid);
                metadataElem.appendChild(newId);
            }
            this.saveXml(doc, contentOpf);
        }
    }

    private Document loadXml(IFile file) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream is = file.getContents();){
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void saveXml(Document doc, IFile file) throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(doc);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(baos);
        transformer.transform(source, result);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        if (file.exists()) {
            file.setContents((InputStream)bais, true, false, null);
        } else {
            file.create((InputStream)bais, true, null);
        }
    }
}

