/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.preferences;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.File;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

@Creatable
public class EpubPreferencePage {
    public static final String KEY_PROJECT_NAME = "ebook_project_name";
    public static final String KEY_PROJECT_PATH = "ebook_project_folder";
    public static final String KEY_PUBLISH_PATH = "ebook_publish_folder";
    public static final String KEY_GEN_URN_UUID = "urnUuidGeneration";
    public static final String KEY_PROJECT_AUTHOR = "ebook_project_author";
    public static final String KEY_PROJECT_PUBLISHER_NAME = "ebook_project_publisher_name";
    public static final String KEY_PROJECT_BOOK_TITLE = "ebook_project_book_title";
    public static final String KEY_PROJECT_PUBLISHING_HOUSE_NAME = "ebook_project_publish_house_name";
    public static final String KEY_PROJECT_PUBLISHING_HOUSE_ADDR = "ebook_project_publish_house_addr";
    public static final String KEY_PROJECT_PUBLISHING_HOUSE_TEL = "ebook_project_publish_house_tel";
    public static final String KEY_PROJECT_PUBLISHING_HOUSE_EMAIL = "ebook_project_publish_house_email";
    public static final String KEY_PROJECT_PUBLISH_ISBN = "ebook_project_publish_isbn";
    public static final String KEY_PROJECT_PUBLISH_DATE = "ebook_project_publish_date";
    public static final String DEFAULT_PROJECT_NAME = "GomsBook";
    public static final String DEFAULT_PROJECT_PATH = "C:\\1004.GomsBook\\01.EPub";
    public static final String DEFAULT_PUBLISH_PATH = "C:\\1004.GomsBook\\02.Publish";
    public static final String DEFAULT_PROJECT_BOOK = "";
    public static final String DEFAULT_PROJECT_AUTHOR = "\ud55c\uc815\ud6c8";
    public static final String DEFAULT_PROJECT_PUBLISHING_HOUSE_NAME = "\uacf0\uc2a4\ubd81";
    public static final String DEFAULT_PROJECT_PUBLISHING_HOUSE_ADDR = "\uc11c\uc6b8\uc2dc \uac15\uc11c\uad6c \uc6b0\uc7a5\uc0b0\ub85c 92, 103\ub3d9 1002\ud638";
    public static final String DEFAULT_PROJECT_PUBLISHING_HOUSE_TEL = "010-6343-3762";
    public static final String DEFAULT_PROJECT_PUBLISHING_HOUSE_EMAIL = "omaro7@hanmail.net";
    public static final String DEFAULT_PROJECT_PUBLISHER_NAME = "\ud55c\uc815\ud6c8";
    public static final String DEFAULT_PROJECT_PUBLISH_ISBN = "\ud55c\uc815\ud6c8";
    public static final String KEY_COLOR_BG = "color.bg";
    public static final String KEY_COLOR_TITLE = "color.title";
    public static final String KEY_COLOR_SUBTITLE = "color.subtitle";
    public static final String KEY_COLOR_AUTHOR = "color.author";
    public static final String KEY_PAGE_COLOR_BG = "page.color.bg";
    public static final String KEY_PAGE_COLOR_TITLE = "page.color.title";
    public static final String KEY_PAGE_COLOR_TEXT = "page.color.text";
    public static final String PREF_SHOW_LOG_VIEW = "showGomsLogView";
    private Preferences prefs;
    private Text txtProjectAuthor;
    private Text txtProjectName;
    private Text txtProjectPath;
    private Text txtOutputPath;
    private Button btnGenerateUrnUuid;
    @Inject
    private EPartService partService;
    @Inject
    private EModelService modelService;
    @Inject
    private MApplication application;

    @PostConstruct
    public void createControls(Composite parent) {
        this.prefs = InstanceScope.INSTANCE.getNode("kr.co.goms.epub.solution");
        SashForm sashForm = new SashForm(parent, 256);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite left = new Composite((Composite)sashForm, 2048);
        left.setLayout((Layout)new GridLayout());
        Display display = parent.getDisplay();
        Color white = display.getSystemColor(1);
        left.setBackground(white);
        Label menu = new Label(left, 0);
        menu.setText("\uacf0\uc2a4\ubd81 \uc124\uc815");
        menu.setBackground(white);
        Composite right = new Composite((Composite)sashForm, 2048);
        right.setLayout((Layout)new GridLayout(3, false));
        Group group = new Group(right, 0);
        group.setText("EPUB \uc815\ubcf4");
        group.setLayout((Layout)new GridLayout(3, false));
        GridData groupData = new GridData(768);
        groupData.horizontalSpan = 3;
        group.setLayoutData((Object)groupData);
        new Label((Composite)group, 0).setText("EPUB \uc800\uc790\uba85");
        GridData textData = new GridData(4, 0x1000000, true, false);
        this.txtProjectAuthor = new Text((Composite)group, 2048);
        this.txtProjectAuthor.setLayoutData((Object)textData);
        this.txtProjectAuthor.setText(this.prefs.get(KEY_PROJECT_AUTHOR, "\ud55c\uc815\ud6c8"));
        this.txtProjectAuthor.addModifyListener(e -> this.prefs.put(KEY_PROJECT_AUTHOR, this.txtProjectAuthor.getText()));
        Label separator = new Label(right, 258);
        GridData sepData = new GridData(768);
        sepData.horizontalSpan = 3;
        separator.setLayoutData((Object)sepData);
        Group groupProject = new Group(right, 0);
        groupProject.setText("EPUB PROJECT \uc815\ubcf4");
        groupProject.setLayout((Layout)new GridLayout(3, false));
        GridData groupProjectData = new GridData(768);
        groupProjectData.horizontalSpan = 3;
        groupProject.setLayoutData((Object)groupProjectData);
        new Label((Composite)groupProject, 0).setText("EPUB \ud504\ub85c\uc81d\ud2b8\uba85");
        this.txtProjectName = new Text((Composite)groupProject, 2048);
        textData = new GridData(4, 0x1000000, true, false);
        textData.horizontalSpan = 2;
        this.txtProjectName.setLayoutData((Object)textData);
        this.txtProjectName.setText(this.prefs.get(KEY_PROJECT_NAME, DEFAULT_PROJECT_NAME));
        this.txtProjectName.addModifyListener(e -> this.prefs.put(KEY_PROJECT_NAME, this.txtProjectName.getText()));
        new Label((Composite)groupProject, 0).setText("EPUB \ud504\ub85c\uc81d\ud2b8 \ud3f4\ub354");
        this.txtProjectPath = new Text((Composite)groupProject, 2048);
        this.txtProjectPath.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtProjectPath.setText(this.prefs.get(KEY_PROJECT_PATH, DEFAULT_PROJECT_PATH));
        this.txtProjectPath.addModifyListener(e -> this.prefs.put(KEY_PROJECT_PATH, this.txtProjectPath.getText()));
        String projectPath = this.prefs.get(KEY_PROJECT_PATH, DEFAULT_PROJECT_BOOK);
        if (projectPath.isEmpty()) {
            this.prefs.put(KEY_PROJECT_PATH, DEFAULT_PROJECT_PATH);
        }
        Button btnSelectProjectFolder = new Button((Composite)groupProject, 8);
        btnSelectProjectFolder.setText("\ud3f4\ub354 \uc120\ud0dd");
        btnSelectProjectFolder.addListener(13, e -> {
            DirectoryDialog dlg = new DirectoryDialog(parent.getShell());
            dlg.setText("EPUB \ud504\ub85c\uc81d\ud2b8 \ud3f4\ub354 \uc120\ud0dd");
            dlg.setFilterPath(this.txtProjectPath.getText());
            String selectedDir = dlg.open();
            if (selectedDir != null) {
                this.txtProjectPath.setText(selectedDir);
            }
        });
        new Label((Composite)groupProject, 0).setText("EPUB \uacb0\uacfc \uc800\uc7a5 \ud3f4\ub354");
        this.txtOutputPath = new Text((Composite)groupProject, 2048);
        this.txtOutputPath.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtOutputPath.setText(this.prefs.get(KEY_PUBLISH_PATH, DEFAULT_PUBLISH_PATH));
        this.txtOutputPath.addModifyListener(e -> this.prefs.put(KEY_PUBLISH_PATH, this.txtOutputPath.getText()));
        String outPutPath = this.prefs.get(KEY_PUBLISH_PATH, DEFAULT_PROJECT_BOOK);
        if (outPutPath.isEmpty()) {
            this.prefs.put(KEY_PUBLISH_PATH, DEFAULT_PUBLISH_PATH);
        }
        Button btnSelectOutputFolder = new Button((Composite)groupProject, 8);
        btnSelectOutputFolder.setText("\ud3f4\ub354 \uc120\ud0dd");
        btnSelectOutputFolder.addListener(13, e -> {
            DirectoryDialog dlg = new DirectoryDialog(parent.getShell());
            dlg.setText("EPUB \uacb0\uacfc \uc800\uc7a5 \ud3f4\ub354 \uc120\ud0dd");
            dlg.setFilterPath(this.txtOutputPath.getText());
            String selectedDir = dlg.open();
            if (selectedDir != null) {
                this.txtOutputPath.setText(selectedDir);
            }
        });
        boolean initGrnUrnUuid = this.prefs.getBoolean(KEY_GEN_URN_UUID, false);
        Label uuidLable = new Label((Composite)groupProject, 0);
        uuidLable.setText("URN UUID \uc790\ub3d9 \uc0dd\uc131");
        uuidLable.setVisible(false);
        this.btnGenerateUrnUuid = new Button((Composite)groupProject, 32);
        this.btnGenerateUrnUuid.setSelection(initGrnUrnUuid);
        this.btnGenerateUrnUuid.setVisible(false);
        this.btnGenerateUrnUuid.addListener(13, e -> this.prefs.put(KEY_GEN_URN_UUID, String.valueOf(this.btnGenerateUrnUuid.getSelection())));
        Group groupLogView = new Group(right, 0);
        groupLogView.setText("EPUB LogView");
        groupLogView.setLayout((Layout)new GridLayout(3, false));
        GridData groupLogViewData = new GridData(768);
        groupLogViewData.horizontalSpan = 3;
        groupLogView.setLayoutData((Object)groupData);
        Button btnShowLogView = new Button((Composite)groupLogView, 32);
        btnShowLogView.setText("Goms Log \ubdf0 \ud45c\uc2dc");
        btnShowLogView.addListener(13, e -> {
            boolean selected = btnShowLogView.getSelection();
            this.updateLogViewVisible(selected);
        });
        separator = new Label(right, 258);
        sepData = new GridData(768);
        sepData.horizontalSpan = 3;
        separator.setLayoutData((Object)sepData);
        Button btnSave = new Button(right, 8);
        btnSave.setText("\uc124\uc815 \uc800\uc7a5");
        btnSave.addListener(13, e -> {
            try {
                this.prefs.flush();
                String pProjectAuthor = this.prefs.get(KEY_PROJECT_AUTHOR, "\ud55c\uc815\ud6c8");
                String pProjectName = this.prefs.get(KEY_PROJECT_NAME, DEFAULT_PROJECT_NAME);
                String pProjectPath = this.prefs.get(KEY_PROJECT_PATH, DEFAULT_PROJECT_PATH);
                String pPublishPath = this.prefs.get(KEY_PUBLISH_PATH, DEFAULT_PUBLISH_PATH);
                boolean pUuid = this.prefs.getBoolean(KEY_GEN_URN_UUID, false);
                System.out.println("pProjectAuthor : " + pProjectAuthor);
                System.out.println("pProjectName : " + pProjectName);
                System.out.println("projectPath : " + pProjectPath);
                System.out.println("pPublishPath : " + pPublishPath);
                System.out.println("Uuid : " + pUuid);
                MessageDialog.openInformation((Shell)parent.getShell(), (String)"\uc54c\ub9bc", (String)"\uc124\uc815\uc774 \uc800\uc7a5\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
            }
            catch (BackingStoreException ex) {
                MessageDialog.openError((Shell)parent.getShell(), (String)"\uc624\ub958", (String)("\uc124\uc815 \uc800\uc7a5 \uc911 \uc624\ub958 \ubc1c\uc0dd: " + ex.getMessage()));
            }
        });
        GridData btnData = new GridData();
        btnData.horizontalSpan = 3;
        btnData.horizontalAlignment = 131072;
        btnSave.setLayoutData((Object)btnData);
        sashForm.setWeights(new int[]{30, 70});
    }

    public static void initializeDefaultPreferences() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("kr.co.goms.epub.solution");
        if (prefs.get(KEY_PROJECT_NAME, DEFAULT_PROJECT_BOOK).isEmpty()) {
            File path = new File(System.getProperty("user.dir"));
            prefs.put(KEY_PROJECT_NAME, path.getName());
            prefs.put(KEY_PROJECT_PATH, path.getAbsolutePath());
        }
        if (prefs.get(KEY_PROJECT_AUTHOR, DEFAULT_PROJECT_BOOK).isEmpty()) {
            prefs.put(KEY_PROJECT_AUTHOR, "\ud55c\uc815\ud6c8");
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public static void debugPrintPrefs() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("kr.co.goms.epub.solution");
        try {
            System.out.println("==== [Preferences Dump] ====");
            String[] stringArray = prefs.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                System.out.printf("%s = %s\n", key, prefs.get(key, "<empty>"));
                ++n2;
            }
            System.out.println("============================");
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    private void onShowLogViewCheckChanged(boolean selected) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("kr.co.goms.epub.solution");
        prefs.putBoolean(PREF_SHOW_LOG_VIEW, selected);
        try {
            prefs.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateLogViewVisible(boolean visible) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("kr.co.goms.epub.solution");
        prefs.putBoolean(PREF_SHOW_LOG_VIEW, visible);
        try {
            prefs.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MUIElement element = this.modelService.find("kr.co.goms.epub.solution.parts.log", (MUIElement)this.application);
        if (!(element instanceof MPart)) {
            return;
        }
        MPart mPart = (MPart)element;
        if (visible) {
            logPart.setToBeRendered(true);
            this.partService.showPart((MPart)logPart, EPartService.PartState.VISIBLE);
        } else {
            this.partService.hidePart((MPart)logPart);
            logPart.setToBeRendered(false);
        }
    }
}

