/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.quiz;

import java.util.ArrayList;
import java.util.List;

public class QuizConfig {
    public static final int MIN_QUESTIONS = 1;
    public static final int MAX_QUESTIONS = 10;
    public static final int MIN_CHOICES = 2;
    public static final int MAX_CHOICES = 6;
    public final List<Question> questions = new ArrayList<Question>();

    public boolean isValid() {
        if (this.questions.size() < 1 || this.questions.size() > 10) {
            return false;
        }
        for (Question q : this.questions) {
            if (q.title == null || q.title.isBlank()) {
                return false;
            }
            if (q.choices.size() < 2 || q.choices.size() > 6) {
                return false;
            }
            for (String c : q.choices) {
                if (c != null && !c.isBlank()) continue;
                return false;
            }
            if (q.correct >= 1 && q.correct <= q.choices.size()) continue;
            return false;
        }
        return true;
    }

    public static QuizConfig sample(int nQuestions, int nChoices) {
        QuizConfig cfg = new QuizConfig();
        nQuestions = Math.max(1, Math.min(10, nQuestions));
        nChoices = Math.max(2, Math.min(6, nChoices));
        int i = 1;
        while (i <= nQuestions) {
            Question q = new Question();
            q.title = "\ubb38\uc81c " + i;
            int j = 1;
            while (j <= nChoices) {
                q.choices.add("\ubcf4\uae30 " + j);
                ++j;
            }
            q.correct = Math.min(3, nChoices);
            cfg.questions.add(q);
            ++i;
        }
        return cfg;
    }

    public static class Question {
        public String title = "\ubb38\uc81c";
        public List<String> choices = new ArrayList<String>();
        public int correct = 1;
    }
}

