/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.security;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.Key;
import java.security.SecureRandom;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class GomsPackagingCrypto {
    private static final String PASS_PHRASE = "gK83!$fA9neUL#4pR7qzPw3D4@bK92Dh";
    private static final byte[] SALT = new byte[]{-93, 79, -62, 27, -99, -25, 58, 92, 71, -47, -120, -7, 10, 59, 126, -103};
    private static final String MAGIC = "GOMS";
    private static final byte VERSION = 1;
    private static final int GCM_TAG_LENGTH_BITS = 128;
    private static final int IV_LENGTH_BYTES = 12;

    private GomsPackagingCrypto() {
    }

    private static SecretKey generateKey() throws Exception {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec spec = new PBEKeySpec(PASS_PHRASE.toCharArray(), SALT, 65536, 256);
        SecretKey tmp = factory.generateSecret(spec);
        return new SecretKeySpec(tmp.getEncoded(), "AES");
    }

    public static byte[] encrypt(byte[] plaintext) throws Exception {
        SecretKey key = GomsPackagingCrypto.generateKey();
        byte[] iv = new byte[12];
        SecureRandom random = new SecureRandom();
        random.nextBytes(iv);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        GCMParameterSpec gcmSpec = new GCMParameterSpec(128, iv);
        cipher.init(1, (Key)key, gcmSpec);
        byte[] cipherText = cipher.doFinal(plaintext);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(MAGIC.getBytes("UTF-8"));
        out.write(1);
        out.write(iv);
        out.write(cipherText);
        return out.toByteArray();
    }

    public static byte[] decrypt(byte[] encrypted) throws Exception {
        byte version;
        if (encrypted.length < 17) {
            throw new IllegalArgumentException("Invalid .goms file: too short");
        }
        int offset = 0;
        String magic = new String(encrypted, offset, 4, "UTF-8");
        if (!MAGIC.equals(magic)) {
            throw new IllegalArgumentException("Invalid .goms file: magic mismatch");
        }
        offset += 4;
        if ((version = encrypted[offset++]) != 1) {
            throw new IllegalArgumentException("Unsupported .goms version: " + version);
        }
        byte[] iv = new byte[12];
        System.arraycopy(encrypted, offset, iv, 0, 12);
        byte[] cipherText = new byte[encrypted.length - (offset += 12)];
        System.arraycopy(encrypted, offset, cipherText, 0, cipherText.length);
        SecretKey key = GomsPackagingCrypto.generateKey();
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        GCMParameterSpec gcmSpec = new GCMParameterSpec(128, iv);
        cipher.init(2, (Key)key, gcmSpec);
        return cipher.doFinal(cipherText);
    }

    public static void encryptZipToGoms(Path zipFile, Path gomsFile) throws Exception {
        byte[] zipBytes = Files.readAllBytes(zipFile);
        byte[] encrypted = GomsPackagingCrypto.encrypt(zipBytes);
        Files.write(gomsFile, encrypted, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    public static Path decryptGomsToTempDir(Path gomsFile) throws Exception {
        byte[] encrypted = Files.readAllBytes(gomsFile);
        byte[] zipBytes = GomsPackagingCrypto.decrypt(encrypted);
        Path tempDir = Files.createTempDirectory("goms_tpl_" + String.valueOf(UUID.randomUUID()), new FileAttribute[0]);
        GomsPackagingCrypto.unzip(zipBytes, tempDir);
        return tempDir;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void zipDirectory(Path srcDir, Path zipFile) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            BufferedOutputStream fos = new BufferedOutputStream(Files.newOutputStream(zipFile, new OpenOption[0]));
            try {
                try (ZipOutputStream zos = new ZipOutputStream(fos);){
                    Files.walk(srcDir, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path2 -> {
                        try {
                            String name = path2.getFileName().toString();
                            if (name.equals(".project")) {
                                return;
                            }
                            if (path2.toString().contains(File.separator + "dist" + File.separator)) {
                                return;
                            }
                            if (name.equals(".classpath")) {
                                return;
                            }
                            Path relative = srcDir.relativize((Path)path2);
                            ZipEntry entry = new ZipEntry(relative.toString().replace("\\", "/"));
                            zos.putNextEntry(entry);
                            Files.copy(path2, zos);
                            zos.closeEntry();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                if (fos == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fos == null) throw throwable;
                ((OutputStream)fos).close();
                throw throwable;
            }
            ((OutputStream)fos).close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static void unzip(byte[] zipBytes, Path destDir) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new ByteArrayInputStream(zipBytes)));){
            ZipEntry entry;
            byte[] buffer = new byte[8192];
            while ((entry = zis.getNextEntry()) != null) {
                Path outPath = destDir.resolve(entry.getName()).normalize();
                if (entry.isDirectory()) {
                    Files.createDirectories(outPath, new FileAttribute[0]);
                } else {
                    Files.createDirectories(outPath.getParent(), new FileAttribute[0]);
                    Throwable throwable2 = null;
                    Object var9_12 = null;
                    try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(outPath, new OpenOption[0]));){
                        int len;
                        while ((len = zis.read(buffer)) != -1) {
                            ((OutputStream)out).write(buffer, 0, len);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                zis.closeEntry();
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public static void decryptGomsToDirectory(Path gomsFile, Path destDir) throws Exception {
        byte[] encrypted = Files.readAllBytes(gomsFile);
        byte[] zipBytes = GomsPackagingCrypto.decrypt(encrypted);
        if (!Files.exists(destDir, new LinkOption[0])) {
            Files.createDirectories(destDir, new FileAttribute[0]);
        }
        GomsPackagingCrypto.unzip(zipBytes, destDir);
    }

    private static String getPassPhrase() {
        return PASS_PHRASE;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Usage:");
            System.out.println("  pack   <srcDir> <outGomsFile>");
            System.out.println("  unpack <gomsFile>");
            return;
        }
        String cmd = args[0];
        if ("pack".equalsIgnoreCase(cmd)) {
            Path srcDir = Path.of(args[1], new String[0]);
            Path tempZip = Files.createTempFile("goms_tpl_zip_", ".zip", new FileAttribute[0]);
            Path outGoms = Path.of(args[2], new String[0]);
            GomsPackagingCrypto.zipDirectory(srcDir, tempZip);
            GomsPackagingCrypto.encryptZipToGoms(tempZip, outGoms);
            Files.deleteIfExists(tempZip);
            System.out.println("Created: " + String.valueOf(outGoms.toAbsolutePath()));
        } else if ("unpack".equalsIgnoreCase(cmd)) {
            Path gomsFile = Path.of(args[1], new String[0]);
            Path tempDir = GomsPackagingCrypto.decryptGomsToTempDir(gomsFile);
            System.out.println("Decrypted to temp dir: " + String.valueOf(tempDir.toAbsolutePath()));
        } else {
            System.out.println("Unknown command: " + cmd);
        }
    }
}

