/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.service;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.Objects;

public class GoogleAiTtsService {
    private static final String MODEL = "gemini-2.5-flash-preview-tts";
    private static final String ENDPOINT = "https://generativelanguage.googleapis.com/v1beta/models/gemini-2.5-flash-preview-tts:generateContent";
    private static final int SAMPLE_RATE = 24000;
    private static final int CHANNELS = 1;
    private static final int BITS_PER_SAMPLE = 16;
    private static final Gson GSON = new Gson();
    private final HttpClient httpClient;
    private final String apiKey;

    public GoogleAiTtsService(String apiKey) {
        this.apiKey = Objects.requireNonNull(apiKey, "apiKey must not be null");
        this.httpClient = HttpClient.newHttpClient();
    }

    public Path synthesizeToWav(String text, Path outputWav, String voiceName) throws IOException, InterruptedException {
        if (text == null || text.isBlank()) {
            throw new IllegalArgumentException("text is empty");
        }
        if (voiceName == null || voiceName.isBlank()) {
            voiceName = "Kore";
        }
        String requestJson = this.buildRequestJson(text, voiceName);
        HttpRequest request = HttpRequest.newBuilder(URI.create(ENDPOINT)).header("Content-Type", "application/json").header("x-goog-api-key", this.apiKey).POST(HttpRequest.BodyPublishers.ofString(requestJson)).build();
        HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            throw new IOException("TTS \uc694\uccad \uc2e4\ud328: HTTP " + response.statusCode() + " / body=" + response.body());
        }
        byte[] pcmBytes = this.extractPcmFromResponse(response.body());
        byte[] wavBytes = this.wrapPcmToWav(pcmBytes, 24000, 1, 16);
        Files.createDirectories(outputWav.getParent(), new FileAttribute[0]);
        Throwable throwable = null;
        Object var10_11 = null;
        try (OutputStream os = Files.newOutputStream(outputWav, new OpenOption[0]);){
            os.write(wavBytes);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return outputWav;
    }

    public Path synthesizeToWav(String text, Path outputWav) throws IOException, InterruptedException {
        return this.synthesizeToWav(text, outputWav, "Kore");
    }

    private String buildRequestJson(String text, String voiceName) {
        JsonObject root = new JsonObject();
        root.addProperty("model", MODEL);
        JsonObject textPart = new JsonObject();
        textPart.addProperty("text", text);
        JsonArray parts = new JsonArray();
        parts.add((JsonElement)textPart);
        JsonObject content = new JsonObject();
        content.add("parts", (JsonElement)parts);
        JsonArray contents = new JsonArray();
        contents.add((JsonElement)content);
        root.add("contents", (JsonElement)contents);
        JsonObject prebuiltVoiceConfig = new JsonObject();
        prebuiltVoiceConfig.addProperty("voiceName", voiceName);
        JsonObject voiceConfig = new JsonObject();
        voiceConfig.add("prebuiltVoiceConfig", (JsonElement)prebuiltVoiceConfig);
        JsonObject speechConfig = new JsonObject();
        speechConfig.add("voiceConfig", (JsonElement)voiceConfig);
        JsonArray responseModalities = new JsonArray();
        responseModalities.add("AUDIO");
        JsonObject generationConfig = new JsonObject();
        generationConfig.add("responseModalities", (JsonElement)responseModalities);
        generationConfig.add("speechConfig", (JsonElement)speechConfig);
        root.add("generationConfig", (JsonElement)generationConfig);
        return GSON.toJson((JsonElement)root);
    }

    private byte[] extractPcmFromResponse(String body) throws IOException {
        try {
            JsonObject root = (JsonObject)GSON.fromJson(body, JsonObject.class);
            JsonArray candidates = root.getAsJsonArray("candidates");
            if (candidates == null || candidates.size() == 0) {
                throw new IOException("\uc751\ub2f5\uc5d0 candidates\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            JsonObject candidate0 = candidates.get(0).getAsJsonObject();
            JsonObject content = candidate0.getAsJsonObject("content");
            if (content == null) {
                throw new IOException("\uc751\ub2f5\uc5d0 content\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            JsonArray parts = content.getAsJsonArray("parts");
            if (parts == null || parts.size() == 0) {
                throw new IOException("\uc751\ub2f5\uc5d0 parts\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            JsonObject part0 = parts.get(0).getAsJsonObject();
            JsonObject inlineData = part0.getAsJsonObject("inlineData");
            if (inlineData == null) {
                throw new IOException("\uc751\ub2f5\uc5d0 inlineData\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            String base64 = inlineData.get("data").getAsString();
            return Base64.getDecoder().decode(base64);
        }
        catch (JsonParseException | IllegalStateException e) {
            throw new IOException("TTS \uc751\ub2f5 JSON \ud30c\uc2f1 \uc2e4\ud328: " + e.getMessage(), e);
        }
    }

    private byte[] wrapPcmToWav(byte[] pcmData, int sampleRate, int channels, int bitsPerSample) throws IOException {
        int byteRate = sampleRate * channels * bitsPerSample / 8;
        int blockAlign = channels * bitsPerSample / 8;
        int dataSize = pcmData.length;
        int chunkSize = 36 + dataSize;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write("RIFF".getBytes("ASCII"));
        out.write(this.intToLittleEndian(chunkSize));
        out.write("WAVE".getBytes("ASCII"));
        out.write("fmt ".getBytes("ASCII"));
        out.write(this.intToLittleEndian(16));
        out.write(this.shortToLittleEndian((short)1));
        out.write(this.shortToLittleEndian((short)channels));
        out.write(this.intToLittleEndian(sampleRate));
        out.write(this.intToLittleEndian(byteRate));
        out.write(this.shortToLittleEndian((short)blockAlign));
        out.write(this.shortToLittleEndian((short)bitsPerSample));
        out.write("data".getBytes("ASCII"));
        out.write(this.intToLittleEndian(dataSize));
        out.write(pcmData);
        return out.toByteArray();
    }

    private byte[] intToLittleEndian(int value) {
        return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(value).array();
    }

    private byte[] shortToLittleEndian(short value) {
        return ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort(value).array();
    }
}

