/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.tts;

import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Display;

public class GoogleAiTtsVoiceOptions {
    private static final Voice[] VOICES = new Voice[]{new Voice("Kore", "Kore \u2013 \ucc28\ubd84\ud55c \ub0a8\uc131 \ub0b4\ub808\uc774\uc158", "M", "\ubd80\ub4dc\ub7ec\uc6b4 \uc911\uc800\uc74c, \uae30\ubcf8 \ub0b4\ub808\uc774\uc158\uc6a9"), new Voice("Charon", "Charon \u2013 \uc548\uc815\uac10 \uc788\ub294 \ub0a8\uc131", "M", "\ubbff\uc74c\uac00\ub294 \uae30\uc5c5/\ub2e4\ud050 \ub0b4\ub808\uc774\uc158"), new Voice("Puck", "Puck \u2013 \ubc1d\uace0 \uce90\uc8fc\uc5bc \ub0a8\uc131", "M", "\uc720\ud29c\ube0c/\uce90\uc8fc\uc5bc \uc601\uc0c1\uc5d0 \uc5b4\uc6b8\ub9bc"), new Voice("Algenib", "Algenib \u2013 \uac15\ud55c \ud504\ub85c\ubaa8\uc158 \ub0a8\uc131", "M", "\uad11\uace0/\uc624\ud504\ub2dd\uc6a9 \uc5d0\ub108\uc81c\ud2f1 \ud1a4"), new Voice("Rasalgethi", "Rasalgethi \u2013 \ubb35\uc9c1\ud55c \uc800\uc74c \ub0a8\uc131", "M", "\ub4dc\ub77c\ub9c8\ud2f1/\uc601\ud654\uc2dd \ub0b4\ub808\uc774\uc158"), new Voice("Zephyr", "Zephyr \u2013 \uac10\uc131\uc801\uc778 \ub0a8\uc131", "M", "\uc794\uc794\ud558\uace0 \uac10\uc131\uc801\uc778 \ucf58\ud150\uce20"), new Voice("Achernar", "Achernar \u2013 \uce5c\uadfc\ud55c \uc5ec\uc131 \uc124\uba85 \ud1a4", "F", "\ub530\ub73b\ud558\uace0 \uce5c\uadfc, \uad50\uc721/\uc124\uba85\uc6a9"), new Voice("Aoede", "Aoede \u2013 \ub2f4\ubc31\ud55c \uc5ec\uc131 \ub0b4\ub808\uc774\uc158", "F", "\ud31f\uce90\uc2a4\ud2b8/\ub0b4\ub808\uc774\uc158\uc5d0 \uc801\ud569"), new Voice("Callirrhoe", "Callirrhoe \u2013 \uc804\ubb38 \uc5ec\uc131 \uc544\ub098\uc6b4\uc11c", "F", "\ube44\uc988\ub2c8\uc2a4/\ubc1c\ud45c/\ub274\uc2a4 \uc2a4\ud0c0\uc77c"), new Voice("Laomedeia", "Laomedeia \u2013 \uac10\uc131 \uc5ec\uc131 \ub0ad\ub3c5", "F", "\uc5d0\uc138\uc774/\uc624\ub514\uc624\ubd81\uc6a9 \uac10\uc131 \ud1a4"), new Voice("Leda", "Leda \u2013 \ubc1d\uace0 \uba85\ub791\ud55c \uc5ec\uc131", "F", "\uce90\uc8fc\uc5bc/\uad11\uace0/\uc720\ud29c\ube0c"), new Voice("Despina", "Despina \u2013 \uace0\uac1d \uc548\ub0b4 \uc5ec\uc131", "F", "\ucf5c\uc13c\ud130/\uc11c\ube44\uc2a4 \uc548\ub0b4 \ub290\ub08c")};

    GoogleAiTtsVoiceOptions() {
    }

    public static void initVoiceCombo(Combo combo) {
        combo.removeAll();
        Voice[] voiceArray = VOICES;
        int n = VOICES.length;
        int n2 = 0;
        while (n2 < n) {
            Voice v = voiceArray[n2];
            combo.add(v.label);
            combo.setData(v.label, (Object)v.code);
            ++n2;
        }
        if (VOICES.length > 0) {
            combo.select(0);
        }
    }

    public static String getSelectedVoiceCode(Combo combo) {
        if (combo == null || combo.isDisposed()) {
            return "Kore";
        }
        String[] result = new String[1];
        Display display = combo.getDisplay();
        if (Display.getCurrent() == display) {
            result[0] = GoogleAiTtsVoiceOptions.internalGet(combo);
        } else {
            display.syncExec(() -> {
                String string = GoogleAiTtsVoiceOptions.internalGet(combo);
            });
        }
        return result[0] != null && !result[0].isEmpty() ? result[0] : "Kore";
    }

    private static String internalGet(Combo combo) {
        String label = combo.getText();
        if (label == null || label.isEmpty()) {
            return "Kore";
        }
        Object code = combo.getData(label);
        return code != null ? code.toString() : "Kore";
    }

    public static Voice[] getVoices() {
        return (Voice[])VOICES.clone();
    }

    public static class Voice {
        public final String code;
        public final String label;
        public final String gender;
        public final String mood;

        public Voice(String code, String label, String gender, String mood) {
            this.code = code;
            this.label = label;
            this.gender = gender;
            this.mood = mood;
        }
    }
}

