/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.tts;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javazoom.jl.player.Player;

public class TTSMp3Player {
    private Thread playThread;
    private volatile Player currentPlayer;
    private volatile File currentFile;
    private volatile Clip currentClip;

    public boolean isPlayingThis(File f) {
        return this.currentFile != null && f != null && this.currentFile.equals(f) && this.playThread != null && this.playThread.isAlive();
    }

    public boolean isPlaying() {
        return this.playThread != null && this.playThread.isAlive();
    }

    public synchronized void stop() {
        if (this.currentPlayer != null) {
            try {
                this.currentPlayer.close();
            }
            catch (Exception exception) {}
            this.currentPlayer = null;
        }
        if (this.currentClip != null) {
            try {
                this.currentClip.stop();
                this.currentClip.close();
            }
            catch (Exception exception) {}
            this.currentClip = null;
        }
        if (this.playThread != null) {
            this.playThread.interrupt();
            this.playThread = null;
        }
        this.currentFile = null;
    }

    public synchronized void playAsync(File file, Runnable onEnd) {
        this.stop();
        this.currentFile = file;
        this.playThread = new Thread(() -> {
            block16: {
                block15: {
                    try {
                        try {
                            String name = file.getName().toLowerCase();
                            if (name.endsWith(".mp3")) {
                                this.playMp3Internal(file);
                                break block15;
                            }
                            if (name.endsWith(".wav")) {
                                this.playWavInternal(file);
                                break block15;
                            }
                            throw new IllegalArgumentException("\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \ud615\uc2dd: " + String.valueOf(file));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.currentPlayer = null;
                            this.currentClip = null;
                            this.currentFile = null;
                            if (!Thread.currentThread().isInterrupted() && onEnd != null) {
                                try {
                                    onEnd.run();
                                }
                                catch (Exception exception) {}
                            }
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        this.currentPlayer = null;
                        this.currentClip = null;
                        this.currentFile = null;
                        if (!Thread.currentThread().isInterrupted() && onEnd != null) {
                            try {
                                onEnd.run();
                            }
                            catch (Exception exception) {}
                        }
                        throw throwable;
                    }
                }
                this.currentPlayer = null;
                this.currentClip = null;
                this.currentFile = null;
                if (!Thread.currentThread().isInterrupted() && onEnd != null) {
                    try {
                        onEnd.run();
                    }
                    catch (Exception exception) {}
                }
            }
        }, "audio-play-thread");
        this.playThread.setDaemon(true);
        this.playThread.start();
    }

    private void playMp3Internal(File file) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream fis = new FileInputStream(file);){
            Player p;
            this.currentPlayer = p = new Player((InputStream)fis);
            p.play();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void playWavInternal(File file) throws Exception {
        AudioInputStream ais = null;
        Clip clip = null;
        try {
            ais = AudioSystem.getAudioInputStream(file);
            this.currentClip = clip = AudioSystem.getClip();
            clip.open(ais);
            clip.start();
            while (!Thread.currentThread().isInterrupted() && clip.isOpen() && clip.isRunning()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        catch (Throwable throwable) {
            if (clip != null) {
                try {
                    clip.stop();
                }
                catch (Exception exception) {}
                try {
                    clip.close();
                }
                catch (Exception exception) {}
            }
            if (ais != null) {
                try {
                    ais.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (clip != null) {
            try {
                clip.stop();
            }
            catch (Exception exception) {}
            try {
                clip.close();
            }
            catch (Exception exception) {}
        }
        if (ais != null) {
            try {
                ais.close();
            }
            catch (Exception exception) {}
        }
    }
}

