/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.tts;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.monitoring.v3.Monitoring;
import com.google.api.services.monitoring.v3.model.ListTimeSeriesResponse;
import com.google.api.services.monitoring.v3.model.Point;
import com.google.api.services.monitoring.v3.model.TimeSeries;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Properties;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;

public class TtsUsageTracker {
    private static final String CONFIG_DIR = System.getProperty("user.home") + File.separator + ".gomsbook";
    private static final String COUNTER_FILE = CONFIG_DIR + File.separator + "tts_usage.properties";
    public static final int MAX_MONTHLY_CHAR = 4000000;
    private static Properties props = new Properties();
    private static String currentMonth = YearMonth.now().toString();
    private static int currentCount = 0;

    static {
        TtsUsageTracker.load();
    }

    private static void load() {
        File file;
        File dir = new File(CONFIG_DIR);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((file = new File(COUNTER_FILE)).exists()) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileInputStream fis = new FileInputStream(file);){
                    props.load(fis);
                    String countStr = props.getProperty(currentMonth, "0");
                    currentCount = Integer.parseInt(countStr);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                currentCount = 0;
            }
        } else {
            currentCount = 0;
        }
    }

    private static void save() {
        props.setProperty(currentMonth, String.valueOf(currentCount));
        try {
            Throwable throwable = null;
            Object var1_3 = null;
            try (FileOutputStream fos = new FileOutputStream(COUNTER_FILE);){
                props.store(fos, "TTS Usage (" + currentMonth + ")");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean canConvert(int newChars) {
        return currentCount + newChars <= 4000000;
    }

    public static void addCount(int chars) {
        currentCount += chars;
        TtsUsageTracker.save();
    }

    public static int getUsedChars() {
        return currentCount;
    }

    public static int getRemainingChars() {
        return 4000000 - currentCount;
    }

    public static String getCurrentMonth() {
        return currentMonth;
    }

    public static void refreshMonth() {
        String newMonth = YearMonth.now().toString();
        if (!newMonth.equals(currentMonth)) {
            currentMonth = newMonth;
            currentCount = 0;
            TtsUsageTracker.save();
        }
    }

    public static long getUsedCharactersThisMonth() throws Exception {
        String jsonKeyFilePath = EpubBuildUtil.getProjectTtsKeyPath();
        GoogleCredentials credentials = GoogleCredentials.fromStream((InputStream)new FileInputStream(jsonKeyFilePath)).createScoped(List.of("https://www.googleapis.com/auth/cloud-platform"));
        Monitoring monitoringService = new Monitoring.Builder((HttpTransport)GoogleNetHttpTransport.newTrustedTransport(), (JsonFactory)GsonFactory.getDefaultInstance(), (HttpRequestInitializer)new HttpCredentialsAdapter((Credentials)credentials)).setApplicationName("GomsBook TTS Usage").build();
        Instant start = YearMonth.now().atDay(1).atStartOfDay().toInstant(ZoneOffset.UTC);
        Instant end = Instant.now();
        Timestamp startTimestamp = Timestamp.newBuilder().setSeconds(start.getEpochSecond()).setNanos(start.getNano()).build();
        Timestamp endTimestamp = Timestamp.newBuilder().setSeconds(end.getEpochSecond()).setNanos(end.getNano()).build();
        String startStr = Timestamps.toString((Timestamp)startTimestamp);
        String endStr = Timestamps.toString((Timestamp)endTimestamp);
        String projectName = "projects/kocogomsbook";
        String filter = "metric.type=\"texttospeech.googleapis.com/request_characters\"";
        Monitoring.Projects.TimeSeries.List request = monitoringService.projects().timeSeries().list(projectName).setFilter(filter).setIntervalStartTime(startStr).setIntervalEndTime(endStr).setView("FULL");
        ListTimeSeriesResponse response = (ListTimeSeriesResponse)request.execute();
        List timeSeries = response.getTimeSeries();
        System.out.println("response : " + response.toPrettyString());
        long totalUsed = 0L;
        if (timeSeries != null) {
            for (TimeSeries ts : timeSeries) {
                for (Point point : ts.getPoints()) {
                    Long value = point.getValue().getInt64Value();
                    totalUsed += value.longValue();
                }
            }
        }
        return totalUsed;
    }
}

