/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kr.co.goms.epub.solution.preferences.EpubPreferenceManager;
import kr.co.goms.epub.solution.utils.CommonUtil;
import kr.co.goms.epub.solution.utils.OpfNcxUpdater;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ContentOpfUtil {
    private static final boolean SPINE_DUP_BY_IDREF_ONLY = true;

    public static void updateOpfManifestAudio(String chapter, List<File> mp3Files) throws Exception {
        File opfFile = new File("OEBPS/content.opf");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(opfFile);
        Node manifest = doc.getElementsByTagName("manifest").item(0);
        for (File mp3 : mp3Files) {
            String filename = mp3.getName();
            String id = filename.replace(".mp3", "_mp3");
            Element item = doc.createElement("item");
            item.setAttribute("id", id);
            item.setAttribute("href", "Audio/" + filename);
            item.setAttribute("media-type", "audio/mpeg");
            manifest.appendChild(item);
        }
        Element smilItem = doc.createElement("item");
        smilItem.setAttribute("id", chapter + "_smil");
        smilItem.setAttribute("href", "Smil/" + chapter + ".smil");
        smilItem.setAttribute("media-type", "application/smil+xml");
        manifest.appendChild(smilItem);
        NodeList items = doc.getElementsByTagName("item");
        int i = 0;
        while (i < items.getLength()) {
            Element item = (Element)items.item(i);
            if (item.getAttribute("href").equals("Text/" + chapter + ".xhtml")) {
                item.setAttribute("media-overlay", chapter + "_smil");
            }
            ++i;
        }
        Throwable throwable = null;
        Object var10_13 = null;
        try (FileOutputStream out = new FileOutputStream(opfFile);){
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(doc), new StreamResult(out));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        System.out.println("\u2714 OPF \uc5c5\ub370\uc774\ud2b8 \uc644\ub8cc");
    }

    public static void applyOpf(Shell shell, String fileName, String message, boolean isMessageOpen) {
        String projectName = EpubPreferenceManager.getInstance().getProjectName();
        boolean isXhtml = true;
        boolean addToScripted = false;
        boolean addToLinearNo = false;
        IFolder iFolder = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFolder("OEBPS/Text");
        String href = iFolder.getProjectRelativePath().append(fileName).toString().substring("OEBPS/".length());
        String id = fileName.replaceAll("[^a-zA-Z0-9]", "_");
        IFile opfFile = iFolder.getProject().getFile("OEBPS/content.opf");
        if (!ContentOpfUtil.isIdExistsInOpf(opfFile, id)) {
            OpfNcxUpdater.addFileToOpf(opfFile, id, href, OpfNcxUpdater.getMediaType(fileName), isXhtml, addToScripted, addToLinearNo);
            if (isMessageOpen) {
                Display.getDefault().asyncExec(() -> CommonUtil.showMessageBox(shell, message));
            }
        } else {
            System.out.println("\uc774\ubbf8 \uc874\uc7ac\ud558\ub294 id: " + id + " \u2192 \ucd94\uac00\ud558\uc9c0 \uc54a\uc74c");
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isIdExistsInOpf(IFile opfFile, String id) {
        try {
            var2_2 = null;
            var3_5 = null;
            try {
                is = opfFile.getContents();
                try {
                    factory = DocumentBuilderFactory.newInstance();
                    builder = factory.newDocumentBuilder();
                    doc = builder.parse(is);
                    items = doc.getElementsByTagName("item");
                    i = 0;
                    while (true) {
                        item = (Element)items.item(i);
                        if (id.equals(item.getAttribute("id"))) {
                            return true;
                        }
                        ++i;
                        return (boolean)i;
                    }
                }
                finally {
                    if (i < items.getLength()) ** continue;
                    return false;
                }
            }
            catch (Throwable var3_6) {
                if (var2_2 == null) {
                    var2_2 = var3_6;
                    throw var2_2;
                }
                if (var2_2 == var3_6) throw var2_2;
                var2_2.addSuppressed(var3_6);
                throw var2_2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void dedupeMetadataManifestAndSpine(IFile opfFile) throws Exception {
        DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
        f.setNamespaceAware(true);
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream is = opfFile.getContents();){
            Element spine;
            Element manifest;
            DocumentBuilder b = f.newDocumentBuilder();
            Document doc = b.parse(is);
            Element metadata = (Element)ContentOpfUtil.first(doc, "metadata");
            if (metadata != null) {
                ContentOpfUtil.removeDuplicateChildren(metadata);
            }
            if ((manifest = (Element)ContentOpfUtil.first(doc, "manifest")) != null) {
                ContentOpfUtil.removeDuplicateChildren(manifest);
            }
            if ((spine = (Element)ContentOpfUtil.first(doc, "spine")) != null) {
                ContentOpfUtil.removeDuplicateSpine(spine);
            }
            ContentOpfUtil.writeDocumentToFile(doc, opfFile);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void writeDocumentToFile(Document doc, IFile file) throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        try {
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        DOMSource source = new DOMSource(doc);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(out);
        transformer.transform(source, result);
        String xml = out.toString("UTF-8");
        String cleaned = xml.replaceAll("(?m)^\\s*$[\n\r]{1,}", "");
        ByteArrayInputStream newInput = new ByteArrayInputStream(cleaned.getBytes("UTF-8"));
        file.setContents((InputStream)newInput, 1, null);
    }

    private static void removeDuplicateChildren(Element parent) {
        NodeList children = parent.getChildNodes();
        HashSet<String> seen = new HashSet<String>();
        int i = children.getLength() - 1;
        while (i >= 0) {
            Element e;
            String key;
            Node n = children.item(i);
            if (n.getNodeType() == 1 && !seen.add(key = ContentOpfUtil.canonicalKey(e = (Element)n))) {
                System.out.println("e.getLocalName()" + e.getLocalName());
                parent.removeChild(e);
            }
            --i;
        }
    }

    private static void removeDuplicateSpine(Element spine) {
        NodeList itemrefs = spine.getElementsByTagName("itemref");
        HashSet<String> seen = new HashSet<String>();
        int i = itemrefs.getLength() - 1;
        while (i >= 0) {
            Element itemref = (Element)itemrefs.item(i);
            String key = ContentOpfUtil.normalize(itemref.getAttribute("idref"));
            if (key != null && !key.isEmpty() && !seen.add(key)) {
                spine.removeChild(itemref);
            }
            --i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String canonicalKey(Element e) {
        void var6_7;
        String ns = e.getNamespaceURI() == null ? "" : e.getNamespaceURI();
        String ln = e.getLocalName() != null ? e.getLocalName() : e.getTagName();
        StringBuilder sb = new StringBuilder();
        sb.append(ns).append("|").append(ln).append("|");
        ArrayList<CallSite> attrs = new ArrayList<CallSite>();
        NamedNodeMap map = e.getAttributes();
        boolean bl = false;
        while (var6_7 < map.getLength()) {
            Node a = map.item((int)var6_7);
            String aname = a.getNodeName();
            if (aname == null || !aname.startsWith("xmlns")) {
                String aval = a.getNodeValue();
                attrs.add((CallSite)((Object)(aname + "=" + ContentOpfUtil.normalize(aval))));
            }
            ++var6_7;
        }
        Collections.sort(attrs, String.CASE_INSENSITIVE_ORDER);
        for (String string : attrs) {
            sb.append(string).append("&");
        }
        sb.append("|");
        String string = ContentOpfUtil.normalize(ContentOpfUtil.textContentShallow(e));
        sb.append(string);
        return sb.toString();
    }

    private static String textContentShallow(Element e) {
        StringBuilder sb = new StringBuilder();
        NodeList list = e.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node n = list.item(i);
            if (n.getNodeType() == 3 || n.getNodeType() == 4) {
                sb.append(n.getNodeValue());
            }
            ++i;
        }
        return sb.toString();
    }

    private static String normalize(String s) {
        if (s == null) {
            return "";
        }
        return s.trim().replaceAll("\\s+", " ");
    }

    private static Node first(Document doc, String tag) {
        NodeList nl = doc.getElementsByTagName(tag);
        return nl.getLength() > 0 ? nl.item(0) : null;
    }
}

