/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.utils;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kr.co.goms.epub.managers.ContentOpfManager;
import kr.co.goms.epub.menu.ExplorerNode;
import kr.co.goms.epub.solution.preferences.EpubPreferenceManager;
import kr.co.goms.epub.solution.ui.EpubErrorItem;
import kr.co.goms.epub.solution.utils.OpfNcxUpdater;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class EpubBuildUtil {
    private static final Pattern ERROR_PATTERN = Pattern.compile("^(ERROR|FATAL|WARNING)\\(([^)]+)\\):\\s+(.+?)\\((-?\\d+),(-?\\d+)\\):\\s+(.+)$");

    public static void openProject(String projectPath, String projectName) {
        String targetPath = projectPath + "/" + projectName;
        try {
            File projectFile;
            File projectDir = new File(targetPath);
            if (!projectDir.exists()) {
                projectDir.mkdirs();
            }
            if (!(projectFile = new File(projectDir, ".project")).exists()) {
                EpubBuildUtil.createProjectFile(projectFile, projectName);
            }
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            IProject project = root.getProject(projectName);
            Path location = new Path(projectPath);
            if (!project.exists()) {
                IProjectDescription description = workspace.newProjectDescription(projectName);
                description.setLocation((IPath)location);
                project.create(description, null);
            }
            if (!project.isOpen()) {
                project.open(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void createProjectFile(File file, String name) throws IOException {
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n  <name>" + name + "</name>\n  <comment></comment>\n  <projects></projects>\n  <buildSpec>\n    <buildCommand>\n      <name>org.eclipse.jdt.core.javabuilder</name>\n      <arguments>\n      </arguments>\n    </buildCommand>\n    <buildCommand>\n      <name>org.eclipse.pde.ManifestBuilder</name>\n      <arguments>\n      </arguments>\n    </buildCommand>\n    <buildCommand>\n      <name>org.eclipse.pde.SchemaBuilder</name>\n      <arguments>\n    </arguments>\n    </buildCommand>\n  </buildSpec>\n  <natures>\n    <nature>org.eclipse.pde.PluginNature</nature>\n    <nature>org.eclipse.jdt.core.javanature</nature>\n  </natures>\n</projectDescription>";
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileWriter writer = new FileWriter(file);){
            writer.write(content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void zipProjectToEpub(String projectDirPath, String outputEpubPath) throws IOException {
        java.nio.file.Path sourceDir = Paths.get(projectDirPath, new String[0]);
        java.nio.file.Path tempZip = Files.createTempFile("temp_epub_", ".zip", new FileAttribute[0]);
        Throwable throwable = null;
        Object var6_7 = null;
        try (ZipOutputStream zipOut = new ZipOutputStream(Files.newOutputStream(tempZip, new OpenOption[0]));){
            Files.walk(sourceDir, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path2 -> {
                ZipEntry zipEntry = new ZipEntry(sourceDir.relativize((java.nio.file.Path)path2).toString().replace("\\", "/"));
                try {
                    zipOut.putNextEntry(zipEntry);
                    Files.copy(path2, zipOut);
                    zipOut.closeEntry();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Files.copy(tempZip, Paths.get(outputEpubPath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        Files.deleteIfExists(tempZip);
    }

    public void createProjectFolder(String projectPath, String projectName) {
        File baseDir = new File(projectPath);
        if (!baseDir.exists()) {
            boolean created = baseDir.mkdirs();
            if (created) {
                System.out.println("\u2705 projectPath \ub514\ub809\ud1a0\ub9ac \uc0dd\uc131: " + baseDir.getAbsolutePath());
            } else {
                System.err.println("\u274c projectPath \ub514\ub809\ud1a0\ub9ac \uc0dd\uc131 \uc2e4\ud328: " + baseDir.getAbsolutePath());
            }
        } else {
            System.out.println("\u2705 projectPath \ub514\ub809\ud1a0\ub9ac \uc874\uc7ac\ud568: " + baseDir.getAbsolutePath());
        }
        File projectDir = new File(baseDir, projectName);
        if (!projectDir.exists()) {
            boolean created = projectDir.mkdirs();
            if (created) {
                System.out.println("\u2705 projectName \ub514\ub809\ud1a0\ub9ac \uc0dd\uc131: " + projectDir.getAbsolutePath());
            } else {
                System.err.println("\u274c projectName \ub514\ub809\ud1a0\ub9ac \uc0dd\uc131 \uc2e4\ud328: " + projectDir.getAbsolutePath());
            }
        } else {
            System.out.println("\u2705 projectName \ub514\ub809\ud1a0\ub9ac \uc874\uc7ac\ud568: " + projectDir.getAbsolutePath());
        }
    }

    public static String getProjectName() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("kr.co.goms.epub.solution");
        String projectName = prefs.get("ebook_project_name", "GomsBook");
        return projectName;
    }

    public static String getProjectPath() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("kr.co.goms.epub.solution");
        String projectPath = prefs.get("ebook_project_folder", "C:\\1004.GomsBook\\01.EPub");
        return projectPath;
    }

    public static String getProjectFullPath() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("kr.co.goms.epub.solution");
        String projectPath = prefs.get("ebook_project_folder", "C:\\1004.GomsBook\\01.EPub");
        String projectName = prefs.get("ebook_project_name", "GomsBook");
        String projectFullPath = projectPath + "/" + projectName;
        return projectFullPath;
    }

    public static String getProjectPublishFolder() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("kr.co.goms.epub.solution");
        String projectName = prefs.get("ebook_project_name", "GomsBook");
        String publishPath = prefs.get("ebook_publish_folder", "C:\\1004.GomsBook\\02.Publish");
        String projectPUblishFullPath = publishPath + "/" + projectName;
        return projectPUblishFullPath;
    }

    public static String getProjectTtsKeyPath() {
        String projectFullPath = EpubBuildUtil.getProjectPath();
        String ttsPath = "epubtts";
        String ttsKey = "kocogomsbook-4d5c74557f69.json";
        String resultKeyPath = projectFullPath + "/" + ttsPath + "/" + ttsKey;
        return resultKeyPath;
    }

    public static String getProjectOEBPSFolder() {
        String projectFullPath = EpubBuildUtil.getProjectFullPath();
        String resultKeyPath = projectFullPath + "/OEBPS/";
        return resultKeyPath;
    }

    public static String getProjectAudioPath() {
        String projectFullPath = EpubBuildUtil.getProjectFullPath();
        String audioPath = "Audio";
        String resultKeyPath = projectFullPath + "/OEBPS/" + audioPath;
        return resultKeyPath;
    }

    public static String getProjectOEBPSSubFolder(String folder) {
        String projectFullPath = EpubBuildUtil.getProjectFullPath();
        String targetPath = folder;
        String resultKeyPath = projectFullPath + "/OEBPS/" + targetPath;
        return resultKeyPath;
    }

    public static String getProjectOEBPSContentOpfFile() {
        String projectFullPath = EpubBuildUtil.getProjectFullPath();
        String opfPath = projectFullPath + "/OEBPS/content.opf";
        return opfPath;
    }

    public static String getProjectOEBPSNavFile() {
        String projectFullPath = EpubBuildUtil.getProjectFullPath();
        String navPath = projectFullPath + "/OEBPS/Text/nav.xhtml";
        return navPath;
    }

    public static String getProjectOEBPSLoiFile() {
        String projectFullPath = EpubBuildUtil.getProjectFullPath();
        String navPath = projectFullPath + "/OEBPS/Text/loi.xhtml";
        return navPath;
    }

    public static String getProjectOEBPSLotFile() {
        String projectFullPath = EpubBuildUtil.getProjectFullPath();
        String navPath = projectFullPath + "/OEBPS/Text/lot.xhtml";
        return navPath;
    }

    public static String getProjectOEBPSCSSFile(String css) {
        String projectFullPath = EpubBuildUtil.getProjectFullPath();
        String cssPath = projectFullPath + "/OEBPS/Styles/" + css;
        return cssPath;
    }

    public static int estimatePlayOrder(IFile ncxFile) {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (InputStream is = ncxFile.getContents();){
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = builder.parse(is);
                NodeList navPoints = doc.getElementsByTagName("navPoint");
                return navPoints.getLength() + 1;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            return 1;
        }
    }

    public File getEpubCheckJarFile() throws IOException {
        String pluginId = EpubBuildUtil.getProjectName();
        Bundle bundle = Platform.getBundle((String)pluginId);
        URL fileURL = FileLocator.toFileURL((URL)bundle.getEntry("lib/epubcheck-5.2.2.jar"));
        return new File(fileURL.getPath());
    }

    public static List<EpubErrorItem> parseEpubErrorAll(List<String> lines) {
        ArrayList<EpubErrorItem> result = new ArrayList<EpubErrorItem>();
        System.out.println("parseEpubErrorAll > lines: " + String.valueOf(lines));
        int no = 1;
        for (String line : lines) {
            System.out.println("parseEpubErrorAll > line: " + line);
            Matcher matcher = ERROR_PATTERN.matcher(line);
            if (matcher.find()) {
                System.out.println("parseEpubErrorAll > find\ud588\uc5b4\uc694");
                String level = matcher.group(1);
                String code = matcher.group(2);
                String fileFullPath = matcher.group(3);
                int lineNum = Integer.parseInt(matcher.group(4));
                int colNum = Integer.parseInt(matcher.group(5));
                String message = matcher.group(6);
                String[] fileInfo = EpubBuildUtil.splitPathAtOEBPS(fileFullPath);
                String cfr_ignored_0 = fileInfo[0];
                String filePath = fileInfo[1];
                result.add(new EpubErrorItem(no, level, code, filePath, lineNum, colNum, message, fileFullPath));
                ++no;
                continue;
            }
            System.out.println("parseEpubErrorAll > find\ud558\uc9c0 \ubabb\ud588\uc5b4\uc694");
        }
        return result;
    }

    public static String[] splitPathAtOEBPS(String fullPath) {
        String marker = "OEBPS";
        int index = fullPath.indexOf(marker);
        if (index == -1) {
            return new String[]{fullPath, ""};
        }
        String prefix = fullPath.substring(0, index);
        String suffix = fullPath.substring(index);
        return new String[]{prefix, suffix};
    }

    public static Map<String, String> extractTitlesFromFolder(File textFolder) throws Exception {
        LinkedHashMap<String, String> chapterTitleMap = new LinkedHashMap<String, String>();
        File[] files = textFolder.listFiles((dir, name) -> name.endsWith(".xhtml"));
        if (files == null) {
            return chapterTitleMap;
        }
        Arrays.sort(files, Comparator.comparing(File::getName));
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String id = file.getName().replace(".xhtml", "").replace(".html", "");
            String title = EpubBuildUtil.extractTitleFromXhtml(file);
            if (title != null && !title.isBlank()) {
                chapterTitleMap.put(id, title);
            }
            ++n2;
        }
        return chapterTitleMap;
    }

    public static String extractTitleFromXhtml(File file) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(false);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(file);
            doc.getDocumentElement().normalize();
            NodeList h1s = doc.getElementsByTagName("h1");
            if (h1s.getLength() > 0) {
                return h1s.item(0).getTextContent().trim();
            }
            NodeList titles = doc.getElementsByTagName("title");
            if (titles.getLength() > 0) {
                return titles.item(0).getTextContent().trim();
            }
        }
        catch (Exception e) {
            System.err.println("Error parsing: " + file.getName());
            e.printStackTrace();
        }
        return null;
    }

    public static String createNextChapterFile(File textFolder) {
        int newChapterNumber;
        String newFileTitle;
        String newFileName;
        File newFile;
        System.out.println("createNextChapterFile() \uc2dc\uc791\ud558\uae30");
        String newFileXhtml = "";
        if (textFolder == null || !textFolder.exists() || !textFolder.isDirectory()) {
            System.err.println("\uc9c0\uc815\ud55c \ud3f4\ub354\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uac70\ub098 \ub514\ub809\ud1a0\ub9ac\uac00 \uc544\ub2d9\ub2c8\ub2e4: " + String.valueOf(textFolder));
            return newFileXhtml;
        }
        File[] files = textFolder.listFiles((dir, name) -> name.matches("chapter\\d+\\.xhtml"));
        int maxChapter = 0;
        Pattern pattern = Pattern.compile("chapter(\\d+)\\.xhtml");
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                int num;
                File file = fileArray[n2];
                Matcher matcher = pattern.matcher(file.getName());
                if (matcher.matches() && (num = Integer.parseInt(matcher.group(1))) > maxChapter) {
                    maxChapter = num;
                }
                ++n2;
            }
        }
        if ((newFile = new File(textFolder, newFileName = (newFileTitle = "chapter" + (newChapterNumber = maxChapter + 1)) + ".xhtml")).exists()) {
            System.err.println("\ud30c\uc77c\uc774 \uc774\ubbf8 \uc874\uc7ac\ud569\ub2c8\ub2e4: " + newFile.getAbsolutePath());
            return newFileXhtml;
        }
        String content = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<!DOCTYPE html><html xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:epub=\"http://www.idpf.org/2007/ops\"><head>\r\n  <title>" + newFileTitle + "</title>\r\n  <link href=\"../Styles/style1.css\" type=\"text/css\" rel=\"stylesheet\"/>\r\n<script>\r\nfunction highlight(id) {\r\n  document.querySelectorAll(\".highlighted\").forEach(el => el.classList.remove(\"highlighted\"));\r\n  const el = document.getElementById(id);\r\n  if (el) {\r\n    el.classList.add(\"highlighted\");\r\n    el.scrollIntoView({ behavior: \"smooth\", block: \"center\" });\r\n  }\r\n}\r\n</script>\r\n</head>\r\n<body>\r\n<h1 class=\"centered\"  id=\"" + newFileTitle + "\">" + newFileTitle + "</h1>\r\n<p id=\"" + newFileTitle + "_p1\">New Content </p>\r\n</body>\r\n</html>";
        try {
            Throwable num = null;
            Object var11_17 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(newFile), StandardCharsets.UTF_8);){
                writer.write(content);
                System.out.println("\ud30c\uc77c \uc0dd\uc131 \uc644\ub8cc: " + newFile.getAbsolutePath());
                ContentOpfManager.getInstance().updateMenifestAndSpine(newFileName);
                return newFileName;
            }
            catch (Throwable throwable) {
                if (num == null) {
                    num = throwable;
                } else if (num != throwable) {
                    num.addSuppressed(throwable);
                }
                throw num;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return newFileName;
        }
    }

    private static void saveDocument(Document doc, String outPath) throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        StringWriter stringWriter = new StringWriter();
        transformer.transform(new DOMSource(doc), new StreamResult(stringWriter));
        String xmlContent = stringWriter.toString();
        String cleanedXml = Arrays.stream(xmlContent.split("\n")).filter(line -> !line.trim().isEmpty()).collect(Collectors.joining("\n"));
        Throwable throwable = null;
        Object var8_9 = null;
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outPath), StandardCharsets.UTF_8));){
            writer.write(cleanedXml);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void convertImageSize() {
        EpubBuildUtil.getProjectOEBPSSubFolder("Images");
    }

    public static IFolder getTextFolder(IProject project) {
        IFolder f = project.getFolder("OEBPS/Text");
        if (!f.exists()) {
            f = project.getFolder("Text");
        }
        return f;
    }

    public static void ensureFolder(IFolder folder) throws Exception {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                IFolder pf = (IFolder)parent;
                EpubBuildUtil.ensureFolder(pf);
            }
            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static String ensureXhtmlExt(String name) {
        Object n = name.trim();
        if (!((String)n).toLowerCase().endsWith(".xhtml")) {
            n = (String)n + ".xhtml";
        }
        return n;
    }

    public static InputStream minimalXhtml(String titleKo) {
        String s = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE html>\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"ko\" lang=\"ko\">\n  <head>\n    <meta charset=\"UTF-8\"/>\n    <title>%s</title>\n    <link href=\"../Styles/style1.css\" rel=\"stylesheet\" type=\"text/css\"/>\n  </head>\n  <body id=\"body\">\n    <h1>%s</h1>\n    <p>\uc5ec\uae30\uc5d0 \ub0b4\uc6a9\uc744 \uc791\uc131\ud558\uc138\uc694.</p>\n  </body>\n</html>\n".formatted(titleKo, titleKo);
        return new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8));
    }

    public static Optional<IResource> toResource(Object sel) {
        IStructuredSelection ss;
        if (sel instanceof IResource) {
            IResource r = (IResource)sel;
            return Optional.of(r);
        }
        if (sel instanceof ExplorerNode) {
            ExplorerNode n = (ExplorerNode)sel;
            if (n.iFile != null) {
                return Optional.of(n.iFile);
            }
            if (n.folder != null) {
                return Optional.of(n.folder);
            }
        }
        if (sel instanceof IStructuredSelection && !(ss = (IStructuredSelection)sel).isEmpty()) {
            return EpubBuildUtil.toResource(ss.getFirstElement());
        }
        return Optional.empty();
    }

    public static Optional<IProject> projectOf(Object sel) {
        return EpubBuildUtil.toResource(sel).map(IResource::getProject);
    }

    public static Optional<IFile> fileOf(Object sel) {
        IStructuredSelection ss;
        if (sel instanceof IFile) {
            IFile f = (IFile)sel;
            return Optional.of(f);
        }
        if (sel instanceof ExplorerNode) {
            ExplorerNode n = (ExplorerNode)sel;
            if (n.iFile != null) {
                return Optional.of(n.iFile);
            }
        }
        if (sel instanceof IStructuredSelection && !(ss = (IStructuredSelection)sel).isEmpty()) {
            Object first = ss.getFirstElement();
            if (first instanceof IFile) {
                IFile f2 = (IFile)first;
                return Optional.of(f2);
            }
            if (first instanceof ExplorerNode) {
                ExplorerNode en = (ExplorerNode)first;
                if (en.iFile != null) {
                    return Optional.of(en.iFile);
                }
            }
        }
        return Optional.empty();
    }

    public static Optional<IFolder> folderOf(Object sel) {
        IStructuredSelection ss;
        if (sel instanceof IFolder) {
            IFolder f = (IFolder)sel;
            return Optional.of(f);
        }
        if (sel instanceof ExplorerNode) {
            ExplorerNode n = (ExplorerNode)sel;
            if (n.folder != null) {
                return Optional.empty();
            }
        }
        if (sel instanceof IStructuredSelection && !(ss = (IStructuredSelection)sel).isEmpty()) {
            Object first = ss.getFirstElement();
            if (first instanceof IFolder) {
                IFolder f2 = (IFolder)first;
                return Optional.of(f2);
            }
            if (first instanceof ExplorerNode) {
                ExplorerNode en = (ExplorerNode)first;
                if (en.folder != null) {
                    return Optional.empty();
                }
            }
        }
        return Optional.empty();
    }

    private static String cssLink(DesignStyle style) {
        String href = style == DesignStyle.CLASSIC ? "../Styles/classic.css" : "../Styles/modern.css";
        return "<link href=\"" + href + "\" rel=\"stylesheet\" type=\"text/css\"/>";
    }

    public static InputStream template(TemplateType t, DesignStyle style, String titleOrNum) {
        String headCss = EpubBuildUtil.cssLink(style);
        String title = switch (t) {
            case TemplateType.COVER -> "cover";
            case TemplateType.CHAPTER -> {
                if (titleOrNum == null || titleOrNum.isBlank()) {
                    yield "Chapter";
                }
                yield titleOrNum;
            }
            case TemplateType.QUIZ -> "\ud034\uc988";
            default -> "\uc0c8 \ubb38\uc11c";
        };
        String body = switch (t) {
            case TemplateType.COVER -> "<figure class=\"cover-wrap\">\n  <img id=\"cover\" src=\"../Images/cover.jpg\" alt=\"\ud45c\uc9c0\" role=\"doc-cover\" class=\"radius-img\" style=\"width:100%%\"/>\n</figure>\n";
            case TemplateType.CHAPTER -> "<h1 id=\"chapter_h1\">%s</h1>\n<p id=\"chapter_p_1\">\uc5ec\uae30\uc5d0 \ubcf8\ubb38\uc744 \uc791\uc131\ud558\uc138\uc694.</p>\n".formatted(title);
            case TemplateType.QUIZ -> EpubBuildUtil.quizBody();
            default -> "<p>\uc0c8 \ubb38\uc11c\uc785\ub2c8\ub2e4.</p>";
        };
        String html = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE html>\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"ko\" lang=\"ko\">\n  <head>\n    <meta charset=\"UTF-8\"/>\n    <title>%s</title>\n    %s\n  </head>\n  <body id=\"body\" class=\"%s\">\n    %s\n  </body>\n</html>\n".formatted(title, headCss, style == DesignStyle.CLASSIC ? "classic" : "modern", body);
        return new ByteArrayInputStream(html.getBytes(StandardCharsets.UTF_8));
    }

    private static String quizBody() {
        return "            <?xml version=\"1.0\" encoding=\"UTF-8\"?>\n            <!DOCTYPE html>\n            <html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"ko\" lang=\"ko\">\n<head>\n\t<title>\ud034\uc988</title>\n\t<link href=\"../Styles/quiz.css\" rel=\"stylesheet\" type=\"text/css\"/>\n</head>\n<body>\n\t<section epub:type=\"learning-resource\" aria-labelledby=\"page_title\" class=\"quiz\">\n\t\t<h1 id=\"page_title\">&#128161; \ud034\uc988</h1>\n\t\t<form aria-labelledby=\"q1_label\" id=\"quiz1\" onsubmit=\"return false;\">\n\t\t\t<fieldset>\n\t\t\t\t<legend id=\"q1_label\">\ubb38\uc81c 1. \uc774 \ucc45 \uc9c0\uc6d0\uc0ac\uc5c5\uc758 \uae30\uad00\uba85\uc740 \ubb34\uc5c7\uc77c\uae4c\uc694?</legend>\n\t\t\t\t<ol>\n\t\t\t\t\t<li>\n\t\t\t\t\t\t<label for=\"q1_opt1\">\n\t\t\t\t\t\t\t<input id=\"q1_opt1\" name=\"q1\" type=\"radio\" value=\"1\"/>\ud55c\uad6d\ubb38\ud654\ucd9c\ud310\uc0b0\uc5c5\uc9c4\ud765\uc6d0\n\t\t\t\t\t\t</label>\n\t\t\t\t\t</li>\n\t\t\t\t\t<li>\n\t\t\t\t\t\t<label for=\"q1_opt2\">\n\t\t\t\t\t\t\t<input id=\"q1_opt2\" name=\"q1\" type=\"radio\" value=\"2\"/>\ud55c\uad6d\ubb38\ud654\ucd9c\ud310\uc0ac\uc5c5\uc9c4\ud765\uc6d0\n\t\t\t\t\t\t</label>\n\t\t\t\t\t</li>\n\t\t\t\t\t<li>\n\t\t\t\t\t\t<label for=\"q1_opt3\">\n\t\t\t\t\t\t\t<input id=\"q1_opt3\" name=\"q1\" type=\"radio\" value=\"3\"/>\ud55c\uad6d\ucd9c\ud310\ubb38\ud654\uc0b0\uc5c5\uc9c4\ud765\uc6d0\n\t\t\t\t\t\t</label>\n\t\t\t\t\t</li>\n\t\t\t\t\t<li>\n\t\t\t\t\t\t<label for=\"q1_opt4\">\n\t\t\t\t\t\t\t<input id=\"q1_opt4\" name=\"q1\" type=\"radio\" value=\"4\"/>\ud55c\uad6d\ucd9c\ud310\ubb38\ud654\uc0ac\uc5c5\uc9c4\ud765\uc6d0\n\t\t\t\t\t\t</label>\n\t\t\t\t\t</li>\n\t\t\t\t</ol>\n\t\t\t\t<div class=\"actions\">\n\t\t\t\t\t<button data-check=\"q1\" type=\"button\">\ud655\uc778</button>\n\t\t\t\t\t<button data-reset=\"q1\" type=\"reset\">\ub2e4\uc2dc \ud480\uae30</button>\n\t\t\t\t</div>\n\t\t\t\t<p aria-live=\"polite\" class=\"msg\" id=\"q1_status\"/>\n\t\t\t</fieldset>\n\t\t</form>\n\t\t<form aria-labelledby=\"q2_label\" id=\"quiz2\" onsubmit=\"return false;\" style=\"margin-top: 20px;\">\n\t\t\t<fieldset>\n\t\t\t\t<legend id=\"q2_label\">\ubb38\uc81c 2. \uacf0\uc2a4\ubd81 \ucd9c\ud310\uc0ac\uc5d0\uc11c \ub9cc\ub4e0 \uc194\ub8e8\uc158 \uc774\ub984\uc740 \ubb34\uc5c7\uc77c\uae4c\uc694?</legend>\n\t\t\t\t<ol>\n\t\t\t\t\t<li>\n\t\t\t\t\t\t<label for=\"q2_opt1\">\n\t\t\t\t\t\t\t<input id=\"q2_opt1\" name=\"q2\" type=\"radio\" value=\"1\"/>GomsBook Editor\n\t\t\t\t\t\t</label>\n\t\t\t\t\t</li>\n\t\t\t\t\t<li>\n\t\t\t\t\t\t<label for=\"q2_opt2\">\n\t\t\t\t\t\t\t<input id=\"q2_opt2\" name=\"q2\" type=\"radio\" value=\"2\"/>GomsBook Solution\n\t\t\t\t\t\t</label>\n\t\t\t\t\t</li>\n\t\t\t\t\t<li>\n\t\t\t\t\t\t<label for=\"q2_opt3\">\n\t\t\t\t\t\t\t<input id=\"q2_opt3\" name=\"q2\" type=\"radio\" value=\"3\"/>BookGoms Editor\n\t\t\t\t\t\t</label>\n\t\t\t\t\t</li>\n\t\t\t\t\t<li>\n\t\t\t\t\t\t<label for=\"q2_opt4\">\n\t\t\t\t\t\t\t<input id=\"q2_opt4\" name=\"q2\" type=\"radio\" value=\"4\"/>BookGoms Solution\n\t\t\t\t\t\t</label>\n\t\t\t\t\t</li>\n\t\t\t\t</ol>\n\t\t\t\t<div class=\"actions\">\n\t\t\t\t\t<button data-check=\"q2\" type=\"button\">\ud655\uc778</button>\n\t\t\t\t\t<button data-reset=\"q2\" type=\"reset\">\ub2e4\uc2dc \ud480\uae30</button>\n\t\t\t\t</div>\n\t\t\t\t<p aria-live=\"polite\" class=\"msg\" id=\"q2_status\"/>\n\t\t\t</fieldset>\n\t\t</form>\n\t</section>\n\t<script type=\"text/javascript\">/*<![CDATA[*/\n\t\t(function () {\n\t\t// \uc815\ub2f5 \uc815\uc758: q1 -> '3', q2 -> '1'\n\t\tvar answers = { q1: '3', q2: '1' };\n\t\tfunction selectedValue(name) {\n\t\tvar nodes = document.querySelectorAll('input[name=\"' + name + '\"]');\n\t\tfor (var i = 0; i < nodes.length; i++) {\n\t\tif (nodes[i].checked) return nodes[i].value;\n\t\t}\n\t\treturn null;\n\t\t}\n\t\tfunction setMessage(id, ok, empty) {\n\t\tvar box = document.getElementById(id + '_status');\n\t\tif (empty) {\n\t\tbox.className = 'msg';\n\t\tbox.textContent = '\ubcf4\uae30\ub97c \uc120\ud0dd\ud574 \uc8fc\uc138\uc694.';\n\t\treturn;\n\t\t}\n\t\tif (ok) {\n\t\tbox.className = 'msg ok';\n\t\tbox.textContent = '\uc815\ub2f5\uc785\ub2c8\ub2e4!';\n\t\t} else {\n\t\tbox.className = 'msg no';\n\t\tbox.textContent = '\uc544\uc26c\uc6cc\uc694. \ub2e4\uc2dc \uc2dc\ub3c4\ud574 \ubcf4\uc138\uc694.';\n\t\t}\n\t\t}\n\t\tfunction clearMessage(id) {\n\t\tvar box = document.getElementById(id + '_status');\n\t\tbox.className = 'msg';\n\t\tbox.textContent = '';\n\t\t}\n\t\t// \ud655\uc778 \ubc84\ud2bc\ub4e4\n\t\tvar checkButtons = document.querySelectorAll('button[data-check]');\n\t\tfor (var i = 0; i < checkButtons.length; i++) {\n\t\tcheckButtons[i].addEventListener('click', function (e) {\n\t\tvar id = e.target.getAttribute('data-check'); // q1 \ub610\ub294 q2\n\t\tvar val = selectedValue(id);\n\t\tif (!val) {\n\t\tsetMessage(id, false, true);\n\t\treturn;\n\t\t}\n\t\tsetMessage(id, val === answers[id], false);\n\t\t});\n\t\t}\n\t\t// \ub9ac\uc14b \ubc84\ud2bc\ub4e4\n\t\tvar resetButtons = document.querySelectorAll('button[data-reset]');\n\t\tfor (var j = 0; j < resetButtons.length; j++) {\n\t\tresetButtons[j].addEventListener('click', function (e) {\n\t\tvar id = e.target.getAttribute('data-reset');\n\t\tclearMessage(id);\n\t\t});\n\t\t}\n\t\t})();\n\t\t/*]]>*/</script>\n\t</body>\n</html>\n";
    }

    public static void addToOpfIfXhtml(IProject project, String fileName, boolean addToSpine, boolean addToScripted, boolean linearNo) {
        try {
            IFile opf = project.getFile("OEBPS/content.opf");
            if (!opf.exists()) {
                return;
            }
            String id = fileName.replaceAll("[^a-zA-Z0-9]", "_");
            String href = "Text/" + fileName;
            boolean isXhtml = true;
            OpfNcxUpdater.addFileToOpf(opf, id, href, OpfNcxUpdater.getMediaType(fileName), isXhtml, addToScripted, linearNo);
        }
        catch (Exception exception) {}
    }

    public static boolean isTextFolder(IFolder folder) {
        if (folder == null) {
            return false;
        }
        String p = folder.getFullPath().toString().replace('\\', '/').toLowerCase();
        return p.endsWith("/text") || p.contains("/oebps/text");
    }

    public static IFolder getProjectIFolder(String targetFolder) {
        String projectName = EpubPreferenceManager.getInstance().getProjectName();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IFolder f = project.getFolder(targetFolder);
        return f;
    }

    public static IProject getIProject() {
        String projectName = EpubPreferenceManager.getInstance().getProjectName();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        return project;
    }

    public static java.nio.file.Path findLatestEpub(java.nio.file.Path outputDir) {
        if (outputDir == null || !Files.isDirectory(outputDir, new LinkOption[0])) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Stream<java.nio.file.Path> stream = Files.walk(outputDir, new FileVisitOption[0]);){
                Optional<java.nio.file.Path> latest = stream.filter(p -> Files.isRegularFile(p, new LinkOption[0])).filter(p -> p.getFileName().toString().toLowerCase().endsWith(".epub")).max(Comparator.comparing(p -> {
                    try {
                        BasicFileAttributes attrs = Files.readAttributes(p, BasicFileAttributes.class, new LinkOption[0]);
                        return attrs.lastModifiedTime().toMillis();
                    }
                    catch (IOException iOException) {
                        return 0L;
                    }
                }));
                return latest.orElse(null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static enum DesignStyle {
        CLASSIC,
        MODERN;

    }

    public static enum TemplateType {
        COVER,
        CHAPTER,
        QUIZ,
        BLANK;

    }
}

