/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.utils;

import org.eclipse.swt.graphics.RGB;

public class EpubColorUtil {
    public static RGB hsvToRGB(float[] hsv) {
        float h = hsv[0];
        float s = hsv[1];
        float v = hsv[2];
        float c = v * s;
        float x = c * (1.0f - Math.abs(h / 60.0f % 2.0f - 1.0f));
        float m = v - c;
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        if (h < 60.0f) {
            r = c;
            g = x;
            b = 0.0f;
        } else if (h < 120.0f) {
            r = x;
            g = c;
            b = 0.0f;
        } else if (h < 180.0f) {
            r = 0.0f;
            g = c;
            b = x;
        } else if (h < 240.0f) {
            r = 0.0f;
            g = x;
            b = c;
        } else if (h < 300.0f) {
            r = x;
            g = 0.0f;
            b = c;
        } else {
            r = c;
            g = 0.0f;
            b = x;
        }
        return new RGB(Math.round((r + m) * 255.0f), Math.round((g + m) * 255.0f), Math.round((b + m) * 255.0f));
    }

    public static RGB hsvToRgb(float h, float s, float v) {
        float c = v * s;
        float x = c * (1.0f - Math.abs(h / 60.0f % 2.0f - 1.0f));
        float m = v - c;
        float r1 = 0.0f;
        float g1 = 0.0f;
        float b1 = 0.0f;
        if (h < 60.0f) {
            r1 = c;
            g1 = x;
            b1 = 0.0f;
        } else if (h < 120.0f) {
            r1 = x;
            g1 = c;
            b1 = 0.0f;
        } else if (h < 180.0f) {
            r1 = 0.0f;
            g1 = c;
            b1 = x;
        } else if (h < 240.0f) {
            r1 = 0.0f;
            g1 = x;
            b1 = c;
        } else if (h < 300.0f) {
            r1 = x;
            g1 = 0.0f;
            b1 = c;
        } else {
            r1 = c;
            g1 = 0.0f;
            b1 = x;
        }
        int r = Math.round((r1 + m) * 255.0f);
        int g = Math.round((g1 + m) * 255.0f);
        int b = Math.round((b1 + m) * 255.0f);
        return new RGB(r, g, b);
    }

    public static float[] rgbToHsv(RGB rgb) {
        float r = (float)rgb.red / 255.0f;
        float g = (float)rgb.green / 255.0f;
        float b = (float)rgb.blue / 255.0f;
        float max = Math.max(r, Math.max(g, b));
        float min = Math.min(r, Math.min(g, b));
        float delta = max - min;
        float h = 0.0f;
        if (delta != 0.0f) {
            h = max == r ? 60.0f * ((g - b) / delta % 6.0f) : (max == g ? 60.0f * ((b - r) / delta + 2.0f) : 60.0f * ((r - g) / delta + 4.0f));
        }
        if (h < 0.0f) {
            h += 360.0f;
        }
        float s = max == 0.0f ? 0.0f : delta / max;
        float v = max;
        return new float[]{h, s, v};
    }
}

