/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.utils;

import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import java.util.Collections;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;

public class GoogleTtsUtil {
    private static String accessToken;

    private static void initAccessToken() throws IOException {
        if (accessToken == null) {
            String ttsApiKey = EpubBuildUtil.getProjectTtsKeyPath();
            System.out.println("ttsApiKey : " + ttsApiKey);
            try {
                Throwable throwable = null;
                Object var2_6 = null;
                try (FileInputStream fis = new FileInputStream(ttsApiKey);){
                    GoogleCredentials credentials = GoogleCredentials.fromStream((InputStream)fis).createScoped(Collections.singleton("https://www.googleapis.com/auth/cloud-platform"));
                    credentials.refreshIfExpired();
                    AccessToken token = credentials.getAccessToken();
                    if (token == null) {
                        System.err.println("\ud1a0\ud070\uc744 \uac00\uc838\uc624\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4. credentials.getAccessToken() == null");
                    } else {
                        accessToken = token.getTokenValue();
                        System.out.println("Access Token: " + accessToken);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException e) {
                System.err.println("\uc11c\ube44\uc2a4 \uacc4\uc815 JSON \ud30c\uc77c\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4: " + ttsApiKey);
                e.printStackTrace();
            }
            catch (IOException e) {
                System.err.println("JSON \ud30c\uc77c \uc77d\uae30 \ub610\ub294 \uc778\uc99d \uc911 IOException \ubc1c\uc0dd");
                e.printStackTrace();
            }
            catch (Exception e) {
                System.err.println("\uc608\uc0c1\uce58 \ubabb\ud55c \uc608\uc678 \ubc1c\uc0dd:");
                e.printStackTrace();
            }
        }
    }

    public static boolean synthesizeToFile(String text, String outputFileName, VoiceGender gender) throws IOException {
        GoogleTtsUtil.initAccessToken();
        String ssmlGender = switch (gender) {
            case VoiceGender.MALE -> "MALE";
            case VoiceGender.FEMALE -> "FEMALE";
            case VoiceGender.NEUTRAL -> "NEUTRAL";
            default -> throw new MatchException(null, null);
        };
        String json = "{\n  \"input\": { \"text\": \"%s\" },\n  \"voice\": {\n    \"languageCode\": \"ko-KR\",\n    \"name\": \"ko-KR-Standard-%s\",\n    \"ssmlGender\": \"FEMALE\"\n  },\n  \"audioConfig\": {\n    \"audioEncoding\": \"MP3\"\n  }\n}\n".formatted(text.replace("\"", "\\\""), gender == VoiceGender.MALE ? "B" : "A", ssmlGender);
        System.out.println("json : " + json);
        HttpURLConnection conn = (HttpURLConnection)new URL("https://texttospeech.googleapis.com/v1/text:synthesize").openConnection();
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Authorization", "Bearer " + accessToken);
        conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        Throwable throwable = null;
        Object var7_9 = null;
        try (OutputStream os = conn.getOutputStream();){
            os.write(json.getBytes("UTF-8"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        int code = conn.getResponseCode();
        System.out.println("Response Code: " + code);
        if (code == 200) {
            String response = new String(conn.getInputStream().readAllBytes(), "UTF-8");
            String audioContent = response.split("\"audioContent\":\\s*\"")[1].split("\"")[0];
            byte[] audioBytes = Base64.getDecoder().decode(audioContent);
            Throwable throwable3 = null;
            Object var11_15 = null;
            try (FileOutputStream fos = new FileOutputStream(outputFileName);){
                fos.write(audioBytes);
            }
            catch (Throwable throwable4) {
                if (throwable3 == null) {
                    throwable3 = throwable4;
                } else if (throwable3 != throwable4) {
                    throwable3.addSuppressed(throwable4);
                }
                throw throwable3;
            }
            System.out.println("\u2714 MP3 \uc800\uc7a5 \uc644\ub8cc: " + outputFileName);
            return true;
        }
        new String(conn.getErrorStream().readAllBytes(), "UTF-8");
        return false;
    }

    public static enum VoiceGender {
        MALE,
        FEMALE,
        NEUTRAL;

    }
}

