/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OpfNcxUpdater {
    public static void addFileToOpf(IFile opfFile, String id, String href, String mediaType, boolean addToSpine, boolean addToScripted, boolean addLinearNo) {
        System.out.println("image href : " + href);
        System.out.println("addFileToOpf > mediaType : " + mediaType + ", addToSpine : " + addToSpine + ", addToScripted : " + addToScripted);
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (InputStream is = opfFile.getContents();){
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(is);
                if ("cover_jpg".equals(id) || "cover_png".equals(id)) {
                    Element metadata = (Element)doc.getElementsByTagName("metadata").item(0);
                    Element meta = doc.createElement("meta");
                    meta.setAttribute("content", id);
                    meta.setAttribute("name", "cover");
                    metadata.appendChild(meta);
                }
                Element manifest = (Element)doc.getElementsByTagName("manifest").item(0);
                Element spine = (Element)doc.getElementsByTagName("spine").item(0);
                Element item = doc.createElement("item");
                item.setAttribute("id", id);
                item.setAttribute("href", href);
                item.setAttribute("media-type", mediaType);
                boolean isNav = false;
                if ("nav_xhtml".equals(id)) {
                    isNav = true;
                }
                if (isNav && addToScripted) {
                    item.setAttribute("properties", "nav scripted");
                } else if (isNav && !addToScripted) {
                    item.setAttribute("properties", "nav");
                } else if (!isNav && addToScripted && id.endsWith("xhtml")) {
                    item.setAttribute("properties", "scripted");
                }
                manifest.appendChild(item);
                if (addToSpine) {
                    boolean exists = false;
                    NodeList itemrefs = spine.getElementsByTagName("itemref");
                    int i = 0;
                    while (i < itemrefs.getLength()) {
                        Element ref = (Element)itemrefs.item(i);
                        if (id.equals(ref.getAttribute("idref"))) {
                            exists = true;
                            break;
                        }
                        ++i;
                    }
                    if (!exists) {
                        Element itemref = doc.createElement("itemref");
                        itemref.setAttribute("idref", id);
                        if (addLinearNo) {
                            itemref.setAttribute("linear", "no");
                        }
                        spine.appendChild(itemref);
                    }
                }
                OpfNcxUpdater.writeDocumentToFile(doc, opfFile);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            System.out.println("Exception : " + e.toString());
            e.printStackTrace();
        }
    }

    public static void addMetadataToOpf(IFile opfFile, String chapter, String totalDurationStr) {
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (InputStream is = opfFile.getContents();){
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(is);
                Element metadata = (Element)doc.getElementsByTagName("metadata").item(0);
                Element refinedDurationMeta = doc.createElement("meta");
                refinedDurationMeta.setAttribute("property", "media:duration");
                refinedDurationMeta.setAttribute("refines", "#" + chapter + "_smil");
                String duration = OpfNcxUpdater.formatDuration(totalDurationStr);
                refinedDurationMeta.setTextContent(duration);
                metadata.appendChild(refinedDurationMeta);
                OpfNcxUpdater.writeDocumentToFile(doc, opfFile);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {}
    }

    public static void setTotalDuration(IFile opfFile) {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (InputStream is = opfFile.getContents();){
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(is);
                NodeList metaList = doc.getElementsByTagName("meta");
                double totalSeconds = 0.0;
                int i = 0;
                while (i < metaList.getLength()) {
                    Element meta = (Element)metaList.item(i);
                    if ("media:duration".equals(meta.getAttribute("property")) && meta.hasAttribute("refines")) {
                        String timeStr = meta.getTextContent().trim();
                        totalSeconds += OpfNcxUpdater.parseDurationToSeconds(timeStr);
                    }
                    ++i;
                }
                String totalFormatted = OpfNcxUpdater.formatSecondsToDuration(totalSeconds);
                NodeList metadataList = doc.getElementsByTagName("metadata");
                if (metadataList.getLength() > 0) {
                    Element metadata = (Element)metadataList.item(0);
                    Element totalMeta = doc.createElement("meta");
                    totalMeta.setAttribute("property", "media:duration");
                    totalMeta.setTextContent(totalFormatted);
                    metadata.appendChild(totalMeta);
                }
                OpfNcxUpdater.writeDocumentToFile(doc, opfFile);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {}
    }

    private static void ensureGuide(Document doc) {
        NodeList guideNodes = doc.getElementsByTagName("guide");
        if (guideNodes.getLength() == 0) {
            Element guide = doc.createElement("guide");
            Element cover = doc.createElement("reference");
            cover.setAttribute("type", "cover");
            cover.setAttribute("title", "Cover");
            cover.setAttribute("href", "Text/cover.xhtml");
            Element toc = doc.createElement("reference");
            toc.setAttribute("type", "toc");
            toc.setAttribute("title", "Table of Contents");
            toc.setAttribute("href", "Text/nav.xhtml");
            guide.appendChild(cover);
            guide.appendChild(toc);
            Node pkg = doc.getElementsByTagName("package").item(0);
            pkg.appendChild(guide);
        }
    }

    public static void addNavPointToNcx(IFile ncxFile, String title, String href, int playOrder) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream is = ncxFile.getContents();){
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(is);
                Element navMap = (Element)doc.getElementsByTagName("navMap").item(0);
                if (navMap == null) {
                    return;
                }
                Element navPoint = doc.createElement("navPoint");
                navPoint.setAttribute("id", "navPoint-" + playOrder);
                navPoint.setAttribute("playOrder", String.valueOf(playOrder));
                Element navLabel = doc.createElement("navLabel");
                Element text = doc.createElement("text");
                text.setTextContent(title);
                navLabel.appendChild(text);
                Element content = doc.createElement("content");
                content.setAttribute("src", href);
                navPoint.appendChild(navLabel);
                navPoint.appendChild(content);
                navMap.appendChild(navPoint);
                OpfNcxUpdater.writeDocumentToFile(doc, ncxFile);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeDocumentToFile(Document doc, IFile file) throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        try {
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        DOMSource source = new DOMSource(doc);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(out);
        transformer.transform(source, result);
        String xml = out.toString("UTF-8");
        String cleaned = xml.replaceAll("(?m)^\\s*$[\n\r]{1,}", "");
        ByteArrayInputStream newInput = new ByteArrayInputStream(cleaned.getBytes("UTF-8"));
        file.setContents((InputStream)newInput, 1, null);
    }

    public static String getMediaType(String filename) {
        String lower = filename.toLowerCase();
        if (lower.endsWith(".xhtml") || lower.endsWith(".html")) {
            return "application/xhtml+xml";
        }
        if (lower.endsWith(".css")) {
            return "text/css";
        }
        if (lower.endsWith(".jpg") || lower.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (lower.endsWith(".png")) {
            return "image/png";
        }
        if (lower.endsWith(".otf")) {
            return "application/vnd.ms-opentype";
        }
        if (lower.endsWith(".ttf")) {
            return "application/x-font-ttf";
        }
        if (lower.endsWith(".svg")) {
            return "image/svg+xml";
        }
        if (lower.endsWith(".mp3")) {
            return "audio/mpeg";
        }
        return "application/octet-stream";
    }

    public static void removeFileFromOpf(IFile opfFile, String id, String href) throws Exception {
        Document doc = OpfNcxUpdater.loadXml(opfFile);
        Element manifest = (Element)doc.getElementsByTagName("manifest").item(0);
        Element spine = (Element)doc.getElementsByTagName("spine").item(0);
        NodeList items = manifest.getElementsByTagName("item");
        int i = 0;
        while (i < items.getLength()) {
            Element item = (Element)items.item(i);
            if (item.getAttribute("id").equals(id) || item.getAttribute("href").equals(href)) {
                manifest.removeChild(item);
                break;
            }
            ++i;
        }
        NodeList itemrefs = spine.getElementsByTagName("itemref");
        int i2 = 0;
        while (i2 < itemrefs.getLength()) {
            Element itemref = (Element)itemrefs.item(i2);
            if (itemref.getAttribute("idref").equals(id)) {
                spine.removeChild(itemref);
                break;
            }
            ++i2;
        }
        OpfNcxUpdater.saveXml(opfFile, doc);
    }

    public static void removeNavPointFromNcx(IFile ncxFile, String href) throws Exception {
        Document doc = OpfNcxUpdater.loadXml(ncxFile);
        Element navMap = (Element)doc.getElementsByTagName("navMap").item(0);
        NodeList navPoints = navMap.getElementsByTagName("navPoint");
        int i = 0;
        while (i < navPoints.getLength()) {
            Element content;
            Element navPoint = (Element)navPoints.item(i);
            NodeList contents = navPoint.getElementsByTagName("content");
            if (contents.getLength() > 0 && (content = (Element)contents.item(0)).getAttribute("src").equals(href)) {
                navMap.removeChild(navPoint);
                break;
            }
            ++i;
        }
        OpfNcxUpdater.saveXml(ncxFile, doc);
    }

    public static Document loadXml(IFile iFile) throws CoreException, ParserConfigurationException, SAXException, IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream inputStream = iFile.getContents();){
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(inputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void saveXml(IFile iFile, Document doc) throws CoreException, TransformerException, IOException {
        OpfNcxUpdater.removeWhitespaceNodes(doc);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        try {
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(outputStream);
        transformer.transform(source, result);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        if (iFile.exists()) {
            iFile.setContents((InputStream)inputStream, 1, null);
        } else {
            iFile.create((InputStream)inputStream, true, null);
        }
        try {
            String opfContents = OpfNcxUpdater.xmlDocumentToString(doc);
            System.out.println("opf contents : " + opfContents);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        inputStream.close();
        outputStream.close();
    }

    public static void removeWhitespaceNodes(Node node) {
        NodeList children = node.getChildNodes();
        int i = children.getLength() - 1;
        while (i >= 0) {
            Node child = children.item(i);
            if (child.getNodeType() == 3 && child.getTextContent().trim().isEmpty()) {
                node.removeChild(child);
            } else if (child.getNodeType() == 1) {
                OpfNcxUpdater.removeWhitespaceNodes(child);
            }
            --i;
        }
    }

    public static String xmlDocumentToString(Document doc) throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(doc), new StreamResult(writer));
        return writer.toString();
    }

    public static double parseDurationToSeconds(String duration) {
        String[] parts = duration.split(":");
        double seconds = 0.0;
        try {
            if (parts.length == 3) {
                int hours = Integer.parseInt(parts[0]);
                int minutes = Integer.parseInt(parts[1]);
                seconds = Double.parseDouble(parts[2]) + (double)(hours * 3600) + (double)(minutes * 60);
            } else if (parts.length == 2) {
                int minutes = Integer.parseInt(parts[0]);
                seconds = Double.parseDouble(parts[1]) + (double)(minutes * 60);
            } else if (parts.length == 1) {
                seconds = Double.parseDouble(parts[0]);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return seconds;
    }

    public static String formatDuration(String secondsStr) {
        try {
            double seconds = Double.parseDouble(secondsStr);
            int h = (int)seconds / 3600;
            int m = (int)seconds % 3600 / 60;
            double s = seconds % 60.0;
            return String.format("%02d:%02d:%06.3f", h, m, s);
        }
        catch (NumberFormatException numberFormatException) {
            return "00:00:00.000";
        }
    }

    public static String formatSecondsToDuration(double totalSeconds) {
        int h = (int)totalSeconds / 3600;
        int m = (int)totalSeconds % 3600 / 60;
        double s = totalSeconds % 60.0;
        return String.format("%02d:%02d:%06.3f", h, m, s);
    }
}

