/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.utils;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import kr.co.goms.epub.solution.preferences.EpubPreferenceManager;
import kr.co.goms.epub.solution.ui.TemplateItem;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class ResourceUtil {
    private static final String BASE_NAME = "resources.template_names";

    public static IFolder getFolerFromBundle(String targetFolder) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject("epubtest03");
        IFolder resultFolder = project.getFolder(targetFolder);
        System.out.println("resultFolder.getName() : " + resultFolder.getName());
        return resultFolder;
    }

    public static String loadFromBundle(String filePath, String fileName) {
        try {
            Bundle bundle = Platform.getBundle((String)"epubtest03");
            URL fileURL = FileLocator.find((Bundle)bundle, (IPath)new Path(filePath + "/" + fileName), null);
            if (fileURL == null) {
                return "<p>\ub9ac\uc18c\uc2a4 \ud30c\uc77c\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4: " + fileName + "</p>";
            }
            URL resolvedURL = FileLocator.toFileURL((URL)fileURL);
            Throwable throwable = null;
            Object var6_8 = null;
            try (InputStream input = resolvedURL.openStream();){
                return new String(input.readAllBytes(), StandardCharsets.UTF_8);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            return "<p>\ub9ac\uc18c\uc2a4 \ub85c\ub529 \uc911 \uc624\ub958 \ubc1c\uc0dd: " + e.getMessage() + "</p>";
        }
    }

    public static File getFileFromBundle(String filePath) {
        try {
            Bundle bundle = Platform.getBundle((String)"epubtest03");
            URL fileURL = FileLocator.toFileURL((URL)bundle.getEntry(filePath));
            java.nio.file.Path path = Paths.get(fileURL.toURI());
            File file = path.toFile();
            return file;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String encodeImageToBase64(String imagePath) {
        try {
            java.nio.file.Path path = Paths.get(imagePath, new String[0]);
            byte[] imageBytes = Files.readAllBytes(path);
            return Base64.getEncoder().encodeToString(imageBytes);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getMimeType(String filePath) {
        String ext = filePath.toLowerCase();
        if (ext.endsWith(".png")) {
            return "image/png";
        }
        if (ext.endsWith(".jpg") || ext.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (ext.endsWith(".gif")) {
            return "image/gif";
        }
        return "application/octet-stream";
    }

    private org.eclipse.swt.graphics.Image loadImageFromURL(String urlStr, Composite parent) {
        try {
            URL url = new URL(urlStr);
            InputStream inputStream = url.openStream();
            return new org.eclipse.swt.graphics.Image((Device)parent.getDisplay(), inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String convertImageTobase64Data(String imagePath) {
        File imageFile = new File(imagePath);
        String base64Image = "";
        try {
            byte[] imageBytes = Files.readAllBytes(imageFile.toPath());
            base64Image = Base64.getEncoder().encodeToString(imageBytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return base64Image;
    }

    public static void createXhtmlFile(java.nio.file.Path outputDir, String fileName, String xhtmlContent) {
        java.nio.file.Path targetPath = outputDir.resolve(fileName);
        try {
            Files.writeString(targetPath, (CharSequence)xhtmlContent, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<String> getTemplateFileNames(String path) throws IOException, URISyntaxException {
        URL resolvedUrl;
        File dir;
        ArrayList<String> fileNames = new ArrayList<String>();
        Bundle bundle = Platform.getBundle((String)"epubtest03");
        URL url = bundle.getEntry(path);
        if (url != null && (dir = new File((resolvedUrl = FileLocator.toFileURL((URL)url)).toURI())).isDirectory()) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().endsWith(".xhtml")) {
                    fileNames.add(file.getName());
                }
                ++n2;
            }
        }
        return fileNames;
    }

    public static ResourceBundle getTemplateBundle(Locale locale) {
        System.out.println("getTemplateBundle locale : " + String.valueOf(locale));
        System.out.println("EpubConstants.BUNDLE_ID : epubtest03");
        String projectName = EpubPreferenceManager.getInstance().getProjectName();
        System.out.println("projectName : " + projectName);
        try {
            Bundle bundle = Platform.getBundle((String)"epubtest03");
            if (bundle != null) {
                ClassLoader classLoader = ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader();
                return ResourceBundle.getBundle(BASE_NAME, locale, classLoader);
            }
        }
        catch (MissingResourceException e) {
            System.err.println("Resource bundle not found: " + e.getMessage());
        }
        return null;
    }

    public static List<TemplateItem> getTemplateFolderList(String category) {
        System.out.println("getTemplateFolderList category : " + category);
        String selectedTemplate = "resources/templates/author/";
        List<TemplateItem> templateList = null;
        if ("cover".equalsIgnoreCase(category)) {
            selectedTemplate = "resources/templates/cover/";
            templateList = ResourceUtil.loadTemplateEntries(selectedTemplate, category);
        } else if ("publisher".equalsIgnoreCase(category)) {
            selectedTemplate = "resources/templates/publisher/";
            templateList = ResourceUtil.loadTemplateEntries(selectedTemplate, category);
        } else {
            templateList = ResourceUtil.loadTemplateEntries(selectedTemplate, category);
        }
        return templateList;
    }

    public static List<TemplateItem> loadTemplateEntries(String path, String category) {
        System.out.println("loadTemplateEntries path : " + path);
        System.out.println("loadTemplateEntries category : " + category);
        ArrayList<TemplateItem> entries = new ArrayList<TemplateItem>();
        try {
            List<String> list = ResourceUtil.getTemplateFileNames(path);
            System.out.println("\ud15c\ud50c\ub9bf\ud3f4\ub354 \ud30c\uc77c : " + list.size());
            for (String fileName : list) {
                System.out.println("fileName : " + fileName);
                String templateName = "";
                ResourceBundle bundle = ResourceUtil.getTemplateBundle(Locale.getDefault());
                if (bundle != null) {
                    templateName = bundle.getString(fileName);
                }
                System.out.println("\ud15c\ud50c\ub9bf\ud3f4\ub354 \ud30c\uc77c : " + fileName);
                entries.add(new TemplateItem(fileName, templateName, category));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return entries;
    }

    public static void rotateImageFile(File inputFile, int angleDegree) throws IOException {
        BufferedImage original = ImageIO.read(inputFile);
        int width = original.getWidth();
        int height = original.getHeight();
        int newWidth = angleDegree == 90 || angleDegree == 270 ? height : width;
        int newHeight = angleDegree == 90 || angleDegree == 270 ? width : height;
        BufferedImage rotated = new BufferedImage(newWidth, newHeight, 1);
        Graphics2D g2d = rotated.createGraphics();
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, newWidth, newHeight);
        switch (angleDegree) {
            case 90: {
                g2d.translate(newWidth, 0);
                g2d.rotate(Math.toRadians(90.0));
                break;
            }
            case 180: {
                g2d.translate(newWidth, newHeight);
                g2d.rotate(Math.toRadians(180.0));
                break;
            }
            case 270: {
                g2d.translate(0, newHeight);
                g2d.rotate(Math.toRadians(270.0));
                break;
            }
            default: {
                throw new IllegalArgumentException("\uc9c0\uc6d0\ub418\uc9c0 \uc54a\ub294 \uac01\ub3c4\uc785\ub2c8\ub2e4: " + angleDegree);
            }
        }
        g2d.drawImage((Image)original, 0, 0, null);
        g2d.dispose();
        String format = ResourceUtil.getFileExtension(inputFile.getName());
        if (format == null) {
            format = "jpg";
        }
        ImageIO.write((RenderedImage)rotated, format, inputFile);
    }

    private static String getFileExtension(String filename) {
        int index = filename.lastIndexOf(46);
        return index > 0 && index < filename.length() - 1 ? filename.substring(index + 1).toLowerCase() : null;
    }

    public static IProject getIProject() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject("epubtest03");
        if (project.exists() && project.isOpen()) {
            return project;
        }
        return null;
    }

    public static IFile resolveIFile(String filePath) {
        if (filePath == null || filePath.isBlank()) {
            return null;
        }
        Path path = new Path(filePath);
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
        if (f != null && f.exists()) {
            return f;
        }
        f = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        return f != null && f.exists() ? f : null;
    }
}

