/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kr.co.goms.epub.solution.ui.PageElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XHTMLParser {
    public static List<PageElement> parseXhtml(File file) {
        ArrayList<PageElement> result = new ArrayList<PageElement>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(file);
            NodeList nodes = doc.getElementsByTagName("*");
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                if (node instanceof Element) {
                    Element el = (Element)node;
                    String tag = el.getTagName();
                    String id = el.getAttribute("id");
                    if (!(id == null || id.isEmpty() || "body".equals(id) || "toc".equals(id) || "landmarks".equals(id))) {
                        String content = "";
                        content = "img".equals(tag) ? el.getAttribute("alt") : el.getTextContent().trim();
                        result.add(new PageElement(tag, id, content));
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

