/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.wizard;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kr.co.goms.epub.solution.utils.CommonUtil;
import kr.co.goms.epub.solution.utils.EpubBuildUtil;
import kr.co.goms.epub.solution.wizard.InstallOperation;
import kr.co.goms.epub.solution.wizard.InstallProjectNameWizardPage;
import kr.co.goms.epub.solution.wizard.InstallWizardPage;
import kr.co.goms.epub.solution.wizard.LanguageSelectionPage;
import kr.co.goms.epub.solution.wizard.LicenseAgreementPage;
import kr.co.goms.epub.solution.wizard.LicenseJWTPage;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.prefs.BackingStoreException;

public class InstallWizard
extends Wizard {
    private LanguageSelectionPage langPage;
    private InstallWizardPage installPage;
    private InstallProjectNameWizardPage installProjectNameWizardPage;
    private LicenseJWTPage licenseJWTPage;
    private LicenseAgreementPage licenseAgreementPage;

    public InstallWizard() {
        this.setWindowTitle("GomsBook Editor \ud504\ub85c\uadf8\ub7a8 \uc124\uce58");
    }

    public void addPages() {
        this.langPage = new LanguageSelectionPage("\uc124\uce58 \uc5b8\uc5b4 \uc120\ud0dd");
        this.installPage = new InstallWizardPage("\uc124\uce58 \uacbd\ub85c \uc120\ud0dd");
        this.installProjectNameWizardPage = new InstallProjectNameWizardPage("\ud504\ub85c\uadf8\ub7a8\uba85 \uc785\ub825");
        this.licenseJWTPage = new LicenseJWTPage("\uc124\uce58 JWT \uc785\ub825");
        this.licenseAgreementPage = new LicenseAgreementPage("\uc124\uce58 \ub3d9\uc758 \uc120\ud0dd");
        this.addPage((IWizardPage)this.langPage);
        this.addPage((IWizardPage)this.installPage);
        this.addPage((IWizardPage)this.installProjectNameWizardPage);
        this.addPage((IWizardPage)this.licenseJWTPage);
        this.addPage((IWizardPage)this.licenseAgreementPage);
    }

    public boolean performFinish() {
        boolean isChecked = this.validate();
        if (isChecked) {
            String selectedLang = this.langPage.getSelectedLanguageCode();
            System.setProperty("user.language", selectedLang);
            System.setProperty("user.country", selectedLang.equals("ko") ? "KR" : "US");
            String selectedProjectName = this.installProjectNameWizardPage.getInstallProjectNameText();
            String licenseKey = this.licenseJWTPage.getLicenseKey();
            String licenseEmail = this.licenseJWTPage.getLicenseEmail();
            String licenseDeviceId = this.getLicenseDeviceId();
            String licenseProduct = "GOMSBOOK_PRO";
            int responseVerifyCode = CommonUtil.verifyLicenseFromServer(licenseKey, licenseEmail, licenseDeviceId, licenseProduct);
            if (responseVerifyCode != 200) {
                String responseVerifyMessage = "\ub77c\uc774\uc120\uc2a4 \uac80\uc99d \uc2e4\ud328\uc785\ub2c8\ub2e4. \uc62c\ubc14\ub978 \ub77c\uc774\uc120\uc2a4\ub97c \ub123\uc5b4\uc8fc\uc138\uc694";
                if (responseVerifyCode == 302) {
                    responseVerifyMessage = "\ud574\ub2f9 \ub77c\uc774\uc120\uc2a4\uac00 \ub9cc\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
                }
                MessageDialog.openError((Shell)this.getShell(), (String)"\uc624\ub958", (String)responseVerifyMessage);
                this.getContainer().showPage((IWizardPage)this.licenseJWTPage);
                return false;
            }
            System.out.println("\ub77c\uc774\uc120\uc2a4 \ud1b5\uacfc");
            String installPath = this.installPage.getInstallPath();
            File licFile = new File(installPath, "gomsbook.lic");
            try {
                Throwable throwable = null;
                Object var12_15 = null;
                try (FileWriter fw = new FileWriter(licFile);){
                    String licTxt = licenseKey + "|" + licenseEmail + "|" + licenseDeviceId;
                    fw.write(licTxt);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                MessageDialog.openError((Shell)this.getShell(), (String)"\uc624\ub958", (String)"\ub77c\uc774\uc120\uc2a4 \ud30c\uc77c \uc800\uc7a5 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
                return false;
            }
            this.initPreferenceData(installPath, selectedProjectName);
            this.initResourcesData(installPath);
            try {
                new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)new InstallOperation(installPath));
                Path installDir = Path.of(installPath, new String[0]);
                Files.createDirectories(installDir, new FileAttribute[0]);
                Path statusFile = installDir.resolve("install.status");
                Files.writeString(statusFile, (CharSequence)"INSTALLED", StandardCharsets.UTF_8, new OpenOption[0]);
                EpubBuildUtil.openProject(installPath, selectedProjectName);
                MessageDialog.openInformation((Shell)this.getShell(), (String)"\uc124\uce58 \uc644\ub8cc", (String)"\uc124\uce58\uac00 \uc131\uacf5\uc801\uc73c\ub85c \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getShell(), (String)"\uc624\ub958", (String)("\uc124\uce58 \uc911 \uc624\ub958 \ubc1c\uc0dd: " + e.getMessage()));
                return false;
            }
            return true;
        }
        return false;
    }

    private String getLicenseDeviceId() {
        String deviceId = CommonUtil.getDeviceId();
        return deviceId;
    }

    public boolean canFinish() {
        return super.canFinish() && this.licenseAgreementPage.isAgreed();
    }

    private boolean validate() {
        String installPath = this.installPage.getInstallPath();
        String licenseKey = this.licenseJWTPage.getLicenseKey();
        String licenseEmail = this.licenseJWTPage.getLicenseEmail();
        if (installPath == null || installPath.isBlank()) {
            InstallWizard.showError("\uc124\uce58 \uacbd\ub85c\ub97c \uc785\ub825\ud558\uc138\uc694.");
            this.getContainer().showPage((IWizardPage)this.installPage);
            return false;
        }
        Path path = Path.of(installPath, new String[0]);
        if (!(Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]) && Files.isWritable(path))) {
            InstallWizard.showError("\uc720\ud6a8\ud55c \uc124\uce58 \uacbd\ub85c\ub97c \uc785\ub825\ud558\uc138\uc694.");
            this.getContainer().showPage((IWizardPage)this.installPage);
            return false;
        }
        if (licenseKey == null || licenseKey.isBlank()) {
            InstallWizard.showError("\ub77c\uc774\uc120\uc2a4\uc758 \ud0a4\ub97c \uc785\ub825\ud558\uc138\uc694.");
            this.getContainer().showPage((IWizardPage)this.licenseJWTPage);
            return false;
        }
        if (licenseEmail == null || licenseEmail.isBlank()) {
            InstallWizard.showError("\ub77c\uc774\uc120\uc2a4\uc758 \uac80\uc99d \uc774\uba54\uc77c\uc744 \uc785\ub825\ud558\uc138\uc694.");
            this.getContainer().showPage((IWizardPage)this.licenseJWTPage);
            return false;
        }
        return true;
    }

    public static void showError(String message) {
        Display display = Display.getDefault();
        Shell shell = display.getActiveShell();
        MessageDialog.openError((Shell)shell, (String)"\uc624\ub958", (String)message);
    }

    private void initPreferenceData(String projectPath, String projectName) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("kr.co.goms.epub.solution");
        prefs.put("ebook_project_name", projectName);
        prefs.put("ebook_project_folder", projectPath);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    private void initResourcesData(String projectPath) {
        Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        URL zipResourceUrl = bundle.getEntry("resources/resource.zip");
        if (zipResourceUrl == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)"\uc624\ub958", (String)"\ubc88\ub4e4\uc5d0 Resource ZIP \ud30c\uc77c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
            return;
        }
        URL zipEpubCheckUrl = bundle.getEntry("resources/epubcheck-5.2.1.zip");
        if (zipEpubCheckUrl == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)"\uc624\ub958", (String)"\ubc88\ub4e4\uc5d0 EpubCheck ZIP \ud30c\uc77c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
            return;
        }
        URL fileResoureUrl = null;
        URL fileEpubCheckUrl = null;
        try {
            fileResoureUrl = FileLocator.toFileURL((URL)zipResourceUrl);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            fileEpubCheckUrl = FileLocator.toFileURL((URL)zipEpubCheckUrl);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File zipResourceFile = new File(fileResoureUrl.getPath());
        File zipEpubCheckFile = new File(fileEpubCheckUrl.getPath());
        String descResourcePath = EpubBuildUtil.getProjectFullPath();
        String descProjectPath = EpubBuildUtil.getProjectPath();
        this.resourceData(zipResourceFile, descResourcePath);
        this.resourceData(zipEpubCheckFile, descProjectPath);
    }

    private void resourceData(File zipResourceFile, String descPath) {
        System.out.println("descPath : " + descPath);
        File destDir = new File(descPath);
        this.unzip(zipResourceFile.getAbsolutePath(), destDir.getAbsolutePath(), this.getShell());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void unzip(String zipFilePath, String destDir, Shell shell) {
        boolean[] overwriteAll = new boolean[1];
        boolean[] skipAll = new boolean[1];
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFilePath));){
                block19: while (true) {
                    ZipEntry entry;
                    if ((entry = zis.getNextEntry()) == null) {
                        return;
                    }
                    File newFile = new File(destDir, entry.getName());
                    if (entry.isDirectory()) {
                        newFile.mkdirs();
                        continue;
                    }
                    new File(newFile.getParent()).mkdirs();
                    if (newFile.exists()) {
                        if (skipAll[0]) continue;
                        if (!overwriteAll[0]) {
                            String[] options = new String[]{"\ub36e\uc5b4\uc4f0\uae30", "\uac74\ub108\ub6f0\uae30", "\ubaa8\ub450 \ub36e\uc5b4\uc4f0\uae30", "\ubaa8\ub450 \uac74\ub108\ub6f0\uae30", "\ucde8\uc18c"};
                            MessageDialog dialog = new MessageDialog(shell, "\ud30c\uc77c \ucda9\ub3cc", null, "\ud30c\uc77c\uc774 \uc774\ubbf8 \uc874\uc7ac\ud569\ub2c8\ub2e4:\n" + newFile.getName() + "\n\uc5b4\ub5bb\uac8c \ucc98\ub9ac\ud558\uc2dc\uaca0\uc2b5\ub2c8\uae4c?", 3, options, 0);
                            int choice = dialog.open();
                            switch (choice) {
                                case 0: {
                                    break;
                                }
                                case 1: {
                                    continue block19;
                                }
                                case 2: {
                                    overwriteAll[0] = true;
                                    break;
                                }
                                case 3: {
                                    skipAll[0] = true;
                                    continue block19;
                                }
                                default: {
                                    return;
                                }
                            }
                        }
                    }
                    Throwable throwable2 = null;
                    Object var12_16 = null;
                    try (FileOutputStream fos = new FileOutputStream(newFile);){
                        int len;
                        byte[] buffer = new byte[4096];
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                            throw throwable2;
                        }
                        if (throwable2 == throwable3) throw throwable2;
                        throwable2.addSuppressed(throwable3);
                        throw throwable2;
                    }
                    zis.closeEntry();
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

