/*
 * Decompiled with CFR 0.152.
 */
package kr.co.goms.epub.solution.wizard;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import kr.co.goms.epub.solution.utils.CommonUtil;
import kr.co.goms.epub.solution.wizard.AbstractBannerWizardPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LicenseJWTPage
extends AbstractBannerWizardPage {
    private Text licenseKeyText;
    private Text licenseEmailText;
    private Button licenseCheckerBtn;

    protected LicenseJWTPage(String pageName) {
        super(pageName);
        this.setTitle("\ub77c\uc774\uc120\uc2a4 \uc785\ub825");
        this.setDescription("\uc124\uce58\ud558\ub824\uba74 \uc720\ud6a8\ud55c \ub77c\uc774\uc120\uc2a4 JWT\ub97c \uc785\ub825\ud558\uc138\uc694.");
    }

    @Override
    public void createPageContent(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        new Label(container, 0).setText("\ub77c\uc774\uc120\uc2a4 \ud0a4\uc785\ub825:");
        this.licenseKeyText = new Text(container, 2626);
        GridData gd = new GridData(1808);
        gd.heightHint = this.licenseKeyText.getLineHeight() * 2 + 6;
        this.licenseKeyText.setLayoutData((Object)gd);
        new Label(container, 0).setText("Email \uc785\ub825:");
        this.licenseEmailText = new Text(container, 2112);
        this.licenseEmailText.setLayoutData((Object)new GridData(1808));
        new Label(container, 0).setText("\ud655\uc778");
        this.licenseCheckerBtn = new Button(container, 2112);
        this.licenseCheckerBtn.setText("\ub77c\uc774\uc120\uc2a4 \uc0ac\uc804\uac80\uc99d");
        this.licenseCheckerBtn.setLayoutData((Object)new GridData(1808));
        this.licenseCheckerBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                System.out.println("\ubc84\ud2bc \ud074\ub9ad\ub428 (SelectionAdapter)!");
                String licenseKey = LicenseJWTPage.this.getLicenseKey();
                String licenseEmail = LicenseJWTPage.this.getLicenseEmail();
                String licenseDeviceId = CommonUtil.getDeviceId();
                String licenseProduct = "GOMSBOOK_PRO";
                String responseVerifyMessage = "\ub77c\uc774\uc120\uc2a4 \uac80\uc99d \uc131\uacf5\uc785\ub2c8\ub2e4.";
                int responseVerifyCode = CommonUtil.verifyLicenseFromServer(licenseKey, licenseEmail, licenseDeviceId, licenseProduct);
                if (responseVerifyCode != 200) {
                    responseVerifyMessage = "\ub77c\uc774\uc120\uc2a4 \uac80\uc99d \uc2e4\ud328\uc785\ub2c8\ub2e4. \uc62c\ubc14\ub978 \ub77c\uc774\uc120\uc2a4\ub97c \ub123\uc5b4\uc8fc\uc138\uc694";
                    if (responseVerifyCode == 302) {
                        responseVerifyMessage = "\ud574\ub2f9 \ub77c\uc774\uc120\uc2a4\uac00 \ub9cc\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
                    } else if (responseVerifyCode == 303) {
                        responseVerifyMessage = "\ud574\ub2f9 \ub77c\uc774\uc120\uc2a4\uc758 \uc774\uba54\uc77c\uc774 \ud2c0\ub9bd\ub2c8\ub2e4.";
                    } else if (responseVerifyCode == 304) {
                        responseVerifyMessage = "\ud574\ub2f9 \ub77c\uc774\uc120\uc2a4\uc758 \ub514\ubc14\uc774\uc2a4\uac12\uc774 \ud2c0\ub9bd\ub2c8\ub2e4.";
                    } else if (responseVerifyCode == 305) {
                        responseVerifyMessage = "\ud574\ub2f9 \ub77c\uc774\uc120\uc2a4\uc758 \uc81c\ud488\uac12\uc774 \ud2c0\ub9bd\ub2c8\ub2e4.";
                    }
                }
                LicenseJWTPage.this.licenseDialog(licenseKey, licenseEmail, licenseDeviceId, licenseProduct, responseVerifyMessage);
            }
        });
        this.setBannerImage(container, "resources/ad_banner_1280.jpg");
    }

    public String getLicenseKey() {
        return this.licenseKeyText.getText().trim();
    }

    public String getLicenseEmail() {
        return this.licenseEmailText.getText().trim();
    }

    private void licenseDialog(String licenseKey, String licenseEmail, String licenseDeviceId, String licenseProduct, String msg) {
        Shell shell = new Shell(this.getShell(), 66800);
        shell.setText("License Info");
        shell.setLayout((Layout)new FillLayout());
        shell.setSize(800, 800);
        shell.setMinimumSize(800, 800);
        String requestBody = String.format("key=%s&email=%s&device=%s&product=%s&msg=%s", URLEncoder.encode(licenseKey, StandardCharsets.UTF_8), URLEncoder.encode(licenseEmail, StandardCharsets.UTF_8), URLEncoder.encode(licenseDeviceId, StandardCharsets.UTF_8), URLEncoder.encode(licenseProduct, StandardCharsets.UTF_8), URLEncoder.encode(msg, StandardCharsets.UTF_8));
        try {
            Browser browser = new Browser((Composite)shell, 0);
            String url = "http://app.goms.co.kr/gomsbook/license_info.php?" + requestBody;
            browser.setUrl(url);
        }
        catch (SWTError sWTError) {
            MessageDialog.openError((Shell)this.getShell(), (String)"\uc624\ub958", (String)msg);
            return;
        }
        shell.open();
    }
}

