/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.monitoring.v3;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.monitoring.v3.MonitoringRequest;
import com.google.api.services.monitoring.v3.MonitoringRequestInitializer;
import com.google.api.services.monitoring.v3.model.AlertPolicy;
import com.google.api.services.monitoring.v3.model.CreateCollectdTimeSeriesRequest;
import com.google.api.services.monitoring.v3.model.CreateCollectdTimeSeriesResponse;
import com.google.api.services.monitoring.v3.model.CreateTimeSeriesRequest;
import com.google.api.services.monitoring.v3.model.Empty;
import com.google.api.services.monitoring.v3.model.GetNotificationChannelVerificationCodeRequest;
import com.google.api.services.monitoring.v3.model.GetNotificationChannelVerificationCodeResponse;
import com.google.api.services.monitoring.v3.model.Group;
import com.google.api.services.monitoring.v3.model.ListAlertPoliciesResponse;
import com.google.api.services.monitoring.v3.model.ListGroupMembersResponse;
import com.google.api.services.monitoring.v3.model.ListGroupsResponse;
import com.google.api.services.monitoring.v3.model.ListMetricDescriptorsResponse;
import com.google.api.services.monitoring.v3.model.ListMonitoredResourceDescriptorsResponse;
import com.google.api.services.monitoring.v3.model.ListNotificationChannelDescriptorsResponse;
import com.google.api.services.monitoring.v3.model.ListNotificationChannelsResponse;
import com.google.api.services.monitoring.v3.model.ListServiceLevelObjectivesResponse;
import com.google.api.services.monitoring.v3.model.ListServicesResponse;
import com.google.api.services.monitoring.v3.model.ListSnoozesResponse;
import com.google.api.services.monitoring.v3.model.ListTimeSeriesResponse;
import com.google.api.services.monitoring.v3.model.ListUptimeCheckConfigsResponse;
import com.google.api.services.monitoring.v3.model.ListUptimeCheckIpsResponse;
import com.google.api.services.monitoring.v3.model.MetricDescriptor;
import com.google.api.services.monitoring.v3.model.MonitoredResourceDescriptor;
import com.google.api.services.monitoring.v3.model.NotificationChannel;
import com.google.api.services.monitoring.v3.model.NotificationChannelDescriptor;
import com.google.api.services.monitoring.v3.model.QueryTimeSeriesRequest;
import com.google.api.services.monitoring.v3.model.QueryTimeSeriesResponse;
import com.google.api.services.monitoring.v3.model.SendNotificationChannelVerificationCodeRequest;
import com.google.api.services.monitoring.v3.model.Service;
import com.google.api.services.monitoring.v3.model.ServiceLevelObjective;
import com.google.api.services.monitoring.v3.model.Snooze;
import com.google.api.services.monitoring.v3.model.UptimeCheckConfig;
import com.google.api.services.monitoring.v3.model.VerifyNotificationChannelRequest;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;

public class Monitoring
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://monitoring.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://monitoring.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://monitoring.googleapis.com/";

    public Monitoring(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Monitoring(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Folders folders() {
        return new Folders();
    }

    public Organizations organizations() {
        return new Organizations();
    }

    public Projects projects() {
        return new Projects();
    }

    public Services services() {
        return new Services();
    }

    public UptimeCheckIps uptimeCheckIps() {
        return new UptimeCheckIps();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Cloud Monitoring API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return Monitoring.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://monitoring.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), Monitoring.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Monitoring.DEFAULT_BATCH_PATH);
        }

        public Monitoring build() {
            return new Monitoring(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setMonitoringRequestInitializer(MonitoringRequestInitializer monitoringRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)monitoringRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }

        public Builder setUniverseDomain(String universeDomain) {
            return (Builder)super.setUniverseDomain(universeDomain);
        }
    }

    public class UptimeCheckIps {
        public List list() throws IOException {
            List result = new List();
            Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends MonitoringRequest<ListUptimeCheckIpsResponse> {
            private static final String REST_PATH = "v3/uptimeCheckIps";
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List() {
                super(Monitoring.this, "GET", REST_PATH, null, ListUptimeCheckIpsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }

    public class Services {
        public Create create(String parent, Service content) throws IOException {
            Create result = new Create(parent, content);
            Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String name) throws IOException {
            Delete result = new Delete(name);
            Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String name) throws IOException {
            Get result = new Get(name);
            Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String parent) throws IOException {
            List result = new List(parent);
            Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String name, Service content) throws IOException {
            Patch result = new Patch(name, content);
            Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ServiceLevelObjectives serviceLevelObjectives() {
            return new ServiceLevelObjectives();
        }

        public class ServiceLevelObjectives {
            public Create create(String parent, ServiceLevelObjective content) throws IOException {
                Create result = new Create(parent, content);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String name) throws IOException {
                Delete result = new Delete(name);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String name, ServiceLevelObjective content) throws IOException {
                Patch result = new Patch(name, content);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Patch
            extends MonitoringRequest<ServiceLevelObjective> {
                private static final String REST_PATH = "v3/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String updateMask;

                protected Patch(String name, ServiceLevelObjective content) {
                    super(Monitoring.this, "PATCH", REST_PATH, (Object)content, ServiceLevelObjective.class);
                    this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+/serviceLevelObjectives/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+/serviceLevelObjectives/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+/serviceLevelObjectives/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends MonitoringRequest<ListServiceLevelObjectivesResponse> {
                private static final String REST_PATH = "v3/{+parent}/serviceLevelObjectives";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key
                private String view;

                protected List(String parent) {
                    super(Monitoring.this, "GET", REST_PATH, null, ListServiceLevelObjectivesResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public String getView() {
                    return this.view;
                }

                public List setView(String view) {
                    this.view = view;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends MonitoringRequest<ServiceLevelObjective> {
                private static final String REST_PATH = "v3/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String view;

                protected Get(String name) {
                    super(Monitoring.this, "GET", REST_PATH, null, ServiceLevelObjective.class);
                    this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+/serviceLevelObjectives/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+/serviceLevelObjectives/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+/serviceLevelObjectives/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getView() {
                    return this.view;
                }

                public Get setView(String view) {
                    this.view = view;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends MonitoringRequest<Empty> {
                private static final String REST_PATH = "v3/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Delete(String name) {
                    super(Monitoring.this, "DELETE", REST_PATH, null, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+/serviceLevelObjectives/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+/serviceLevelObjectives/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+/serviceLevelObjectives/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends MonitoringRequest<ServiceLevelObjective> {
                private static final String REST_PATH = "v3/{+parent}/serviceLevelObjectives";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String serviceLevelObjectiveId;

                protected Create(String parent, ServiceLevelObjective content) {
                    super(Monitoring.this, "POST", REST_PATH, (Object)content, ServiceLevelObjective.class);
                    this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getServiceLevelObjectiveId() {
                    return this.serviceLevelObjectiveId;
                }

                public Create setServiceLevelObjectiveId(String serviceLevelObjectiveId) {
                    this.serviceLevelObjectiveId = serviceLevelObjectiveId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Patch
        extends MonitoringRequest<Service> {
            private static final String REST_PATH = "v3/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String updateMask;

            protected Patch(String name, Service content) {
                super(Monitoring.this, "PATCH", REST_PATH, (Object)content, Service.class);
                this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Monitoring.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                }
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Patch setName(String name) {
                if (!Monitoring.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                }
                this.name = name;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Patch setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends MonitoringRequest<ListServicesResponse> {
            private static final String REST_PATH = "v3/{+parent}/services";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;
            @Key
            private String filter;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List(String parent) {
                super(Monitoring.this, "GET", REST_PATH, null, ListServicesResponse.class);
                this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!Monitoring.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public List setParent(String parent) {
                if (!Monitoring.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends MonitoringRequest<Service> {
            private static final String REST_PATH = "v3/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(Monitoring.this, "GET", REST_PATH, null, Service.class);
                this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Monitoring.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!Monitoring.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends MonitoringRequest<Empty> {
            private static final String REST_PATH = "v3/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Delete(String name) {
                super(Monitoring.this, "DELETE", REST_PATH, null, Empty.class);
                this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!Monitoring.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Delete setName(String name) {
                if (!Monitoring.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends MonitoringRequest<Service> {
            private static final String REST_PATH = "v3/{+parent}/services";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;
            @Key
            private String serviceId;

            protected Create(String parent, Service content) {
                super(Monitoring.this, "POST", REST_PATH, (Object)content, Service.class);
                this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!Monitoring.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public Create setParent(String parent) {
                if (!Monitoring.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            public String getServiceId() {
                return this.serviceId;
            }

            public Create setServiceId(String serviceId) {
                this.serviceId = serviceId;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Projects {
        public AlertPolicies alertPolicies() {
            return new AlertPolicies();
        }

        public CollectdTimeSeries collectdTimeSeries() {
            return new CollectdTimeSeries();
        }

        public Groups groups() {
            return new Groups();
        }

        public MetricDescriptors metricDescriptors() {
            return new MetricDescriptors();
        }

        public MonitoredResourceDescriptors monitoredResourceDescriptors() {
            return new MonitoredResourceDescriptors();
        }

        public NotificationChannelDescriptors notificationChannelDescriptors() {
            return new NotificationChannelDescriptors();
        }

        public NotificationChannels notificationChannels() {
            return new NotificationChannels();
        }

        public Snoozes snoozes() {
            return new Snoozes();
        }

        public TimeSeries timeSeries() {
            return new TimeSeries();
        }

        public UptimeCheckConfigs uptimeCheckConfigs() {
            return new UptimeCheckConfigs();
        }

        public class UptimeCheckConfigs {
            public Create create(String parent, UptimeCheckConfig content) throws IOException {
                Create result = new Create(parent, content);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String name) throws IOException {
                Delete result = new Delete(name);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String name, UptimeCheckConfig content) throws IOException {
                Patch result = new Patch(name, content);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Patch
            extends MonitoringRequest<UptimeCheckConfig> {
                private static final String REST_PATH = "v3/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String updateMask;

                protected Patch(String name, UptimeCheckConfig content) {
                    super(Monitoring.this, "PATCH", REST_PATH, (Object)content, UptimeCheckConfig.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/uptimeCheckConfigs/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/uptimeCheckConfigs/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/uptimeCheckConfigs/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends MonitoringRequest<ListUptimeCheckConfigsResponse> {
                private static final String REST_PATH = "v3/{+parent}/uptimeCheckConfigs";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String parent) {
                    super(Monitoring.this, "GET", REST_PATH, null, ListUptimeCheckConfigsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends MonitoringRequest<UptimeCheckConfig> {
                private static final String REST_PATH = "v3/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(Monitoring.this, "GET", REST_PATH, null, UptimeCheckConfig.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/uptimeCheckConfigs/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/uptimeCheckConfigs/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/uptimeCheckConfigs/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends MonitoringRequest<Empty> {
                private static final String REST_PATH = "v3/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Delete(String name) {
                    super(Monitoring.this, "DELETE", REST_PATH, null, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/uptimeCheckConfigs/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/uptimeCheckConfigs/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/uptimeCheckConfigs/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends MonitoringRequest<UptimeCheckConfig> {
                private static final String REST_PATH = "v3/{+parent}/uptimeCheckConfigs";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Create(String parent, UptimeCheckConfig content) {
                    super(Monitoring.this, "POST", REST_PATH, (Object)content, UptimeCheckConfig.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class TimeSeries {
            public Create create(String name, CreateTimeSeriesRequest content) throws IOException {
                Create result = new Create(name, content);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public CreateService createService(String name, CreateTimeSeriesRequest content) throws IOException {
                CreateService result = new CreateService(name, content);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String name) throws IOException {
                List result = new List(name);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Query query(String name, QueryTimeSeriesRequest content) throws IOException {
                Query result = new Query(name, content);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Query
            extends MonitoringRequest<QueryTimeSeriesResponse> {
                private static final String REST_PATH = "v3/{+name}/timeSeries:query";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Query(String name, QueryTimeSeriesRequest content) {
                    super(Monitoring.this, "POST", REST_PATH, (Object)content, QueryTimeSeriesResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Query set$Xgafv(String $Xgafv) {
                    return (Query)super.set$Xgafv($Xgafv);
                }

                public Query setAccessToken(String accessToken) {
                    return (Query)super.setAccessToken(accessToken);
                }

                public Query setAlt(String alt) {
                    return (Query)super.setAlt(alt);
                }

                public Query setCallback(String callback) {
                    return (Query)super.setCallback(callback);
                }

                public Query setFields(String fields) {
                    return (Query)super.setFields(fields);
                }

                public Query setKey(String key) {
                    return (Query)super.setKey(key);
                }

                public Query setOauthToken(String oauthToken) {
                    return (Query)super.setOauthToken(oauthToken);
                }

                public Query setPrettyPrint(Boolean prettyPrint) {
                    return (Query)super.setPrettyPrint(prettyPrint);
                }

                public Query setQuotaUser(String quotaUser) {
                    return (Query)super.setQuotaUser(quotaUser);
                }

                public Query setUploadType(String uploadType) {
                    return (Query)super.setUploadType(uploadType);
                }

                public Query setUploadProtocol(String uploadProtocol) {
                    return (Query)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Query setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Query set(String parameterName, Object value) {
                    return (Query)super.set(parameterName, value);
                }
            }

            public class List
            extends MonitoringRequest<ListTimeSeriesResponse> {
                private static final String REST_PATH = "v3/{+name}/timeSeries";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key(value="aggregation.alignmentPeriod")
                private String aggregationAlignmentPeriod;
                @Key(value="aggregation.crossSeriesReducer")
                private String aggregationCrossSeriesReducer;
                @Key(value="aggregation.groupByFields")
                private java.util.List<String> aggregationGroupByFields;
                @Key(value="aggregation.perSeriesAligner")
                private String aggregationPerSeriesAligner;
                @Key
                private String filter;
                @Key(value="interval.endTime")
                private String intervalEndTime;
                @Key(value="interval.startTime")
                private String intervalStartTime;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key(value="secondaryAggregation.alignmentPeriod")
                private String secondaryAggregationAlignmentPeriod;
                @Key(value="secondaryAggregation.crossSeriesReducer")
                private String secondaryAggregationCrossSeriesReducer;
                @Key(value="secondaryAggregation.groupByFields")
                private java.util.List<String> secondaryAggregationGroupByFields;
                @Key(value="secondaryAggregation.perSeriesAligner")
                private String secondaryAggregationPerSeriesAligner;
                @Key
                private String view;

                protected List(String name) {
                    super(Monitoring.this, "GET", REST_PATH, null, ListTimeSeriesResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getAggregationAlignmentPeriod() {
                    return this.aggregationAlignmentPeriod;
                }

                public List setAggregationAlignmentPeriod(String aggregationAlignmentPeriod) {
                    this.aggregationAlignmentPeriod = aggregationAlignmentPeriod;
                    return this;
                }

                public String getAggregationCrossSeriesReducer() {
                    return this.aggregationCrossSeriesReducer;
                }

                public List setAggregationCrossSeriesReducer(String aggregationCrossSeriesReducer) {
                    this.aggregationCrossSeriesReducer = aggregationCrossSeriesReducer;
                    return this;
                }

                public java.util.List<String> getAggregationGroupByFields() {
                    return this.aggregationGroupByFields;
                }

                public List setAggregationGroupByFields(java.util.List<String> aggregationGroupByFields) {
                    this.aggregationGroupByFields = aggregationGroupByFields;
                    return this;
                }

                public String getAggregationPerSeriesAligner() {
                    return this.aggregationPerSeriesAligner;
                }

                public List setAggregationPerSeriesAligner(String aggregationPerSeriesAligner) {
                    this.aggregationPerSeriesAligner = aggregationPerSeriesAligner;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getIntervalEndTime() {
                    return this.intervalEndTime;
                }

                public List setIntervalEndTime(String intervalEndTime) {
                    this.intervalEndTime = intervalEndTime;
                    return this;
                }

                public String getIntervalStartTime() {
                    return this.intervalStartTime;
                }

                public List setIntervalStartTime(String intervalStartTime) {
                    this.intervalStartTime = intervalStartTime;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public String getSecondaryAggregationAlignmentPeriod() {
                    return this.secondaryAggregationAlignmentPeriod;
                }

                public List setSecondaryAggregationAlignmentPeriod(String secondaryAggregationAlignmentPeriod) {
                    this.secondaryAggregationAlignmentPeriod = secondaryAggregationAlignmentPeriod;
                    return this;
                }

                public String getSecondaryAggregationCrossSeriesReducer() {
                    return this.secondaryAggregationCrossSeriesReducer;
                }

                public List setSecondaryAggregationCrossSeriesReducer(String secondaryAggregationCrossSeriesReducer) {
                    this.secondaryAggregationCrossSeriesReducer = secondaryAggregationCrossSeriesReducer;
                    return this;
                }

                public java.util.List<String> getSecondaryAggregationGroupByFields() {
                    return this.secondaryAggregationGroupByFields;
                }

                public List setSecondaryAggregationGroupByFields(java.util.List<String> secondaryAggregationGroupByFields) {
                    this.secondaryAggregationGroupByFields = secondaryAggregationGroupByFields;
                    return this;
                }

                public String getSecondaryAggregationPerSeriesAligner() {
                    return this.secondaryAggregationPerSeriesAligner;
                }

                public List setSecondaryAggregationPerSeriesAligner(String secondaryAggregationPerSeriesAligner) {
                    this.secondaryAggregationPerSeriesAligner = secondaryAggregationPerSeriesAligner;
                    return this;
                }

                public String getView() {
                    return this.view;
                }

                public List setView(String view) {
                    this.view = view;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class CreateService
            extends MonitoringRequest<Empty> {
                private static final String REST_PATH = "v3/{+name}/timeSeries:createService";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected CreateService(String name, CreateTimeSeriesRequest content) {
                    super(Monitoring.this, "POST", REST_PATH, (Object)content, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public CreateService set$Xgafv(String $Xgafv) {
                    return (CreateService)super.set$Xgafv($Xgafv);
                }

                public CreateService setAccessToken(String accessToken) {
                    return (CreateService)super.setAccessToken(accessToken);
                }

                public CreateService setAlt(String alt) {
                    return (CreateService)super.setAlt(alt);
                }

                public CreateService setCallback(String callback) {
                    return (CreateService)super.setCallback(callback);
                }

                public CreateService setFields(String fields) {
                    return (CreateService)super.setFields(fields);
                }

                public CreateService setKey(String key) {
                    return (CreateService)super.setKey(key);
                }

                public CreateService setOauthToken(String oauthToken) {
                    return (CreateService)super.setOauthToken(oauthToken);
                }

                public CreateService setPrettyPrint(Boolean prettyPrint) {
                    return (CreateService)super.setPrettyPrint(prettyPrint);
                }

                public CreateService setQuotaUser(String quotaUser) {
                    return (CreateService)super.setQuotaUser(quotaUser);
                }

                public CreateService setUploadType(String uploadType) {
                    return (CreateService)super.setUploadType(uploadType);
                }

                public CreateService setUploadProtocol(String uploadProtocol) {
                    return (CreateService)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public CreateService setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public CreateService set(String parameterName, Object value) {
                    return (CreateService)super.set(parameterName, value);
                }
            }

            public class Create
            extends MonitoringRequest<Empty> {
                private static final String REST_PATH = "v3/{+name}/timeSeries";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Create(String name, CreateTimeSeriesRequest content) {
                    super(Monitoring.this, "POST", REST_PATH, (Object)content, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Create setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Snoozes {
            public Create create(String parent, Snooze content) throws IOException {
                Create result = new Create(parent, content);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String name, Snooze content) throws IOException {
                Patch result = new Patch(name, content);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Patch
            extends MonitoringRequest<Snooze> {
                private static final String REST_PATH = "v3/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String updateMask;

                protected Patch(String name, Snooze content) {
                    super(Monitoring.this, "PATCH", REST_PATH, (Object)content, Snooze.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/snoozes/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/snoozes/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/snoozes/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends MonitoringRequest<ListSnoozesResponse> {
                private static final String REST_PATH = "v3/{+parent}/snoozes";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String parent) {
                    super(Monitoring.this, "GET", REST_PATH, null, ListSnoozesResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends MonitoringRequest<Snooze> {
                private static final String REST_PATH = "v3/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(Monitoring.this, "GET", REST_PATH, null, Snooze.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/snoozes/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/snoozes/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/snoozes/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Create
            extends MonitoringRequest<Snooze> {
                private static final String REST_PATH = "v3/{+parent}/snoozes";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Create(String parent, Snooze content) {
                    super(Monitoring.this, "POST", REST_PATH, (Object)content, Snooze.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class NotificationChannels {
            public Create create(String name, NotificationChannel content) throws IOException {
                Create result = new Create(name, content);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String name) throws IOException {
                Delete result = new Delete(name);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public GetVerificationCode getVerificationCode(String name, GetNotificationChannelVerificationCodeRequest content) throws IOException {
                GetVerificationCode result = new GetVerificationCode(name, content);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String name) throws IOException {
                List result = new List(name);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String name, NotificationChannel content) throws IOException {
                Patch result = new Patch(name, content);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public SendVerificationCode sendVerificationCode(String name, SendNotificationChannelVerificationCodeRequest content) throws IOException {
                SendVerificationCode result = new SendVerificationCode(name, content);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Verify verify(String name, VerifyNotificationChannelRequest content) throws IOException {
                Verify result = new Verify(name, content);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Verify
            extends MonitoringRequest<NotificationChannel> {
                private static final String REST_PATH = "v3/{+name}:verify";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Verify(String name, VerifyNotificationChannelRequest content) {
                    super(Monitoring.this, "POST", REST_PATH, (Object)content, NotificationChannel.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/notificationChannels/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/notificationChannels/[^/]+$");
                    }
                }

                public Verify set$Xgafv(String $Xgafv) {
                    return (Verify)super.set$Xgafv($Xgafv);
                }

                public Verify setAccessToken(String accessToken) {
                    return (Verify)super.setAccessToken(accessToken);
                }

                public Verify setAlt(String alt) {
                    return (Verify)super.setAlt(alt);
                }

                public Verify setCallback(String callback) {
                    return (Verify)super.setCallback(callback);
                }

                public Verify setFields(String fields) {
                    return (Verify)super.setFields(fields);
                }

                public Verify setKey(String key) {
                    return (Verify)super.setKey(key);
                }

                public Verify setOauthToken(String oauthToken) {
                    return (Verify)super.setOauthToken(oauthToken);
                }

                public Verify setPrettyPrint(Boolean prettyPrint) {
                    return (Verify)super.setPrettyPrint(prettyPrint);
                }

                public Verify setQuotaUser(String quotaUser) {
                    return (Verify)super.setQuotaUser(quotaUser);
                }

                public Verify setUploadType(String uploadType) {
                    return (Verify)super.setUploadType(uploadType);
                }

                public Verify setUploadProtocol(String uploadProtocol) {
                    return (Verify)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Verify setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/notificationChannels/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Verify set(String parameterName, Object value) {
                    return (Verify)super.set(parameterName, value);
                }
            }

            public class SendVerificationCode
            extends MonitoringRequest<Empty> {
                private static final String REST_PATH = "v3/{+name}:sendVerificationCode";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected SendVerificationCode(String name, SendNotificationChannelVerificationCodeRequest content) {
                    super(Monitoring.this, "POST", REST_PATH, (Object)content, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/notificationChannels/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/notificationChannels/[^/]+$");
                    }
                }

                public SendVerificationCode set$Xgafv(String $Xgafv) {
                    return (SendVerificationCode)super.set$Xgafv($Xgafv);
                }

                public SendVerificationCode setAccessToken(String accessToken) {
                    return (SendVerificationCode)super.setAccessToken(accessToken);
                }

                public SendVerificationCode setAlt(String alt) {
                    return (SendVerificationCode)super.setAlt(alt);
                }

                public SendVerificationCode setCallback(String callback) {
                    return (SendVerificationCode)super.setCallback(callback);
                }

                public SendVerificationCode setFields(String fields) {
                    return (SendVerificationCode)super.setFields(fields);
                }

                public SendVerificationCode setKey(String key) {
                    return (SendVerificationCode)super.setKey(key);
                }

                public SendVerificationCode setOauthToken(String oauthToken) {
                    return (SendVerificationCode)super.setOauthToken(oauthToken);
                }

                public SendVerificationCode setPrettyPrint(Boolean prettyPrint) {
                    return (SendVerificationCode)super.setPrettyPrint(prettyPrint);
                }

                public SendVerificationCode setQuotaUser(String quotaUser) {
                    return (SendVerificationCode)super.setQuotaUser(quotaUser);
                }

                public SendVerificationCode setUploadType(String uploadType) {
                    return (SendVerificationCode)super.setUploadType(uploadType);
                }

                public SendVerificationCode setUploadProtocol(String uploadProtocol) {
                    return (SendVerificationCode)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public SendVerificationCode setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/notificationChannels/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public SendVerificationCode set(String parameterName, Object value) {
                    return (SendVerificationCode)super.set(parameterName, value);
                }
            }

            public class Patch
            extends MonitoringRequest<NotificationChannel> {
                private static final String REST_PATH = "v3/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String updateMask;

                protected Patch(String name, NotificationChannel content) {
                    super(Monitoring.this, "PATCH", REST_PATH, (Object)content, NotificationChannel.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/notificationChannels/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/notificationChannels/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/notificationChannels/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends MonitoringRequest<ListNotificationChannelsResponse> {
                private static final String REST_PATH = "v3/{+name}/notificationChannels";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String filter;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String name) {
                    super(Monitoring.this, "GET", REST_PATH, null, ListNotificationChannelsResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class GetVerificationCode
            extends MonitoringRequest<GetNotificationChannelVerificationCodeResponse> {
                private static final String REST_PATH = "v3/{+name}:getVerificationCode";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected GetVerificationCode(String name, GetNotificationChannelVerificationCodeRequest content) {
                    super(Monitoring.this, "POST", REST_PATH, (Object)content, GetNotificationChannelVerificationCodeResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/notificationChannels/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/notificationChannels/[^/]+$");
                    }
                }

                public GetVerificationCode set$Xgafv(String $Xgafv) {
                    return (GetVerificationCode)super.set$Xgafv($Xgafv);
                }

                public GetVerificationCode setAccessToken(String accessToken) {
                    return (GetVerificationCode)super.setAccessToken(accessToken);
                }

                public GetVerificationCode setAlt(String alt) {
                    return (GetVerificationCode)super.setAlt(alt);
                }

                public GetVerificationCode setCallback(String callback) {
                    return (GetVerificationCode)super.setCallback(callback);
                }

                public GetVerificationCode setFields(String fields) {
                    return (GetVerificationCode)super.setFields(fields);
                }

                public GetVerificationCode setKey(String key) {
                    return (GetVerificationCode)super.setKey(key);
                }

                public GetVerificationCode setOauthToken(String oauthToken) {
                    return (GetVerificationCode)super.setOauthToken(oauthToken);
                }

                public GetVerificationCode setPrettyPrint(Boolean prettyPrint) {
                    return (GetVerificationCode)super.setPrettyPrint(prettyPrint);
                }

                public GetVerificationCode setQuotaUser(String quotaUser) {
                    return (GetVerificationCode)super.setQuotaUser(quotaUser);
                }

                public GetVerificationCode setUploadType(String uploadType) {
                    return (GetVerificationCode)super.setUploadType(uploadType);
                }

                public GetVerificationCode setUploadProtocol(String uploadProtocol) {
                    return (GetVerificationCode)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public GetVerificationCode setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/notificationChannels/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public GetVerificationCode set(String parameterName, Object value) {
                    return (GetVerificationCode)super.set(parameterName, value);
                }
            }

            public class Get
            extends MonitoringRequest<NotificationChannel> {
                private static final String REST_PATH = "v3/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(Monitoring.this, "GET", REST_PATH, null, NotificationChannel.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/notificationChannels/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/notificationChannels/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/notificationChannels/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends MonitoringRequest<Empty> {
                private static final String REST_PATH = "v3/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private Boolean force;

                protected Delete(String name) {
                    super(Monitoring.this, "DELETE", REST_PATH, null, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/notificationChannels/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/notificationChannels/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/notificationChannels/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public Boolean getForce() {
                    return this.force;
                }

                public Delete setForce(Boolean force) {
                    this.force = force;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends MonitoringRequest<NotificationChannel> {
                private static final String REST_PATH = "v3/{+name}/notificationChannels";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Create(String name, NotificationChannel content) {
                    super(Monitoring.this, "POST", REST_PATH, (Object)content, NotificationChannel.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Create setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class NotificationChannelDescriptors {
            public Get get(String name) throws IOException {
                Get result = new Get(name);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String name) throws IOException {
                List result = new List(name);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends MonitoringRequest<ListNotificationChannelDescriptorsResponse> {
                private static final String REST_PATH = "v3/{+name}/notificationChannelDescriptors";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String name) {
                    super(Monitoring.this, "GET", REST_PATH, null, ListNotificationChannelDescriptorsResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends MonitoringRequest<NotificationChannelDescriptor> {
                private static final String REST_PATH = "v3/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(Monitoring.this, "GET", REST_PATH, null, NotificationChannelDescriptor.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/notificationChannelDescriptors/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/notificationChannelDescriptors/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/notificationChannelDescriptors/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class MonitoredResourceDescriptors {
            public Get get(String name) throws IOException {
                Get result = new Get(name);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String name) throws IOException {
                List result = new List(name);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends MonitoringRequest<ListMonitoredResourceDescriptorsResponse> {
                private static final String REST_PATH = "v3/{+name}/monitoredResourceDescriptors";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String name) {
                    super(Monitoring.this, "GET", REST_PATH, null, ListMonitoredResourceDescriptorsResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends MonitoringRequest<MonitoredResourceDescriptor> {
                private static final String REST_PATH = "v3/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(Monitoring.this, "GET", REST_PATH, null, MonitoredResourceDescriptor.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/monitoredResourceDescriptors/.*$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/monitoredResourceDescriptors/.*$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/monitoredResourceDescriptors/.*$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class MetricDescriptors {
            public Create create(String name, MetricDescriptor content) throws IOException {
                Create result = new Create(name, content);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String name) throws IOException {
                Delete result = new Delete(name);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String name) throws IOException {
                List result = new List(name);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends MonitoringRequest<ListMetricDescriptorsResponse> {
                private static final String REST_PATH = "v3/{+name}/metricDescriptors";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private Boolean activeOnly;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String name) {
                    super(Monitoring.this, "GET", REST_PATH, null, ListMetricDescriptorsResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public Boolean getActiveOnly() {
                    return this.activeOnly;
                }

                public List setActiveOnly(Boolean activeOnly) {
                    this.activeOnly = activeOnly;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends MonitoringRequest<MetricDescriptor> {
                private static final String REST_PATH = "v3/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(Monitoring.this, "GET", REST_PATH, null, MetricDescriptor.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/metricDescriptors/.*$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/metricDescriptors/.*$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/metricDescriptors/.*$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends MonitoringRequest<Empty> {
                private static final String REST_PATH = "v3/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Delete(String name) {
                    super(Monitoring.this, "DELETE", REST_PATH, null, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/metricDescriptors/.*$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/metricDescriptors/.*$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/metricDescriptors/.*$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends MonitoringRequest<MetricDescriptor> {
                private static final String REST_PATH = "v3/{+name}/metricDescriptors";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Create(String name, MetricDescriptor content) {
                    super(Monitoring.this, "POST", REST_PATH, (Object)content, MetricDescriptor.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Create setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Groups {
            public Create create(String name, Group content) throws IOException {
                Create result = new Create(name, content);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String name) throws IOException {
                Delete result = new Delete(name);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String name) throws IOException {
                List result = new List(name);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String name, Group content) throws IOException {
                Update result = new Update(name, content);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Members members() {
                return new Members();
            }

            public class Members {
                public List list(String name) throws IOException {
                    List result = new List(name);
                    Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends MonitoringRequest<ListGroupMembersResponse> {
                    private static final String REST_PATH = "v3/{+name}/members";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String filter;
                    @Key(value="interval.endTime")
                    private String intervalEndTime;
                    @Key(value="interval.startTime")
                    private String intervalStartTime;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String name) {
                        super(Monitoring.this, "GET", REST_PATH, null, ListGroupMembersResponse.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/groups/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Monitoring.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/groups/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public List setName(String name) {
                        if (!Monitoring.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/groups/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public String getIntervalEndTime() {
                        return this.intervalEndTime;
                    }

                    public List setIntervalEndTime(String intervalEndTime) {
                        this.intervalEndTime = intervalEndTime;
                        return this;
                    }

                    public String getIntervalStartTime() {
                        return this.intervalStartTime;
                    }

                    public List setIntervalStartTime(String intervalStartTime) {
                        this.intervalStartTime = intervalStartTime;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }
            }

            public class Update
            extends MonitoringRequest<Group> {
                private static final String REST_PATH = "v3/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private Boolean validateOnly;

                protected Update(String name, Group content) {
                    super(Monitoring.this, "PUT", REST_PATH, (Object)content, Group.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/groups/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/groups/[^/]+$");
                    }
                }

                public Update set$Xgafv(String $Xgafv) {
                    return (Update)super.set$Xgafv($Xgafv);
                }

                public Update setAccessToken(String accessToken) {
                    return (Update)super.setAccessToken(accessToken);
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setCallback(String callback) {
                    return (Update)super.setCallback(callback);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUploadType(String uploadType) {
                    return (Update)super.setUploadType(uploadType);
                }

                public Update setUploadProtocol(String uploadProtocol) {
                    return (Update)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Update setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/groups/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public Boolean getValidateOnly() {
                    return this.validateOnly;
                }

                public Update setValidateOnly(Boolean validateOnly) {
                    this.validateOnly = validateOnly;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class List
            extends MonitoringRequest<ListGroupsResponse> {
                private static final String REST_PATH = "v3/{+name}/groups";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String ancestorsOfGroup;
                @Key
                private String childrenOfGroup;
                @Key
                private String descendantsOfGroup;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String name) {
                    super(Monitoring.this, "GET", REST_PATH, null, ListGroupsResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getAncestorsOfGroup() {
                    return this.ancestorsOfGroup;
                }

                public List setAncestorsOfGroup(String ancestorsOfGroup) {
                    this.ancestorsOfGroup = ancestorsOfGroup;
                    return this;
                }

                public String getChildrenOfGroup() {
                    return this.childrenOfGroup;
                }

                public List setChildrenOfGroup(String childrenOfGroup) {
                    this.childrenOfGroup = childrenOfGroup;
                    return this;
                }

                public String getDescendantsOfGroup() {
                    return this.descendantsOfGroup;
                }

                public List setDescendantsOfGroup(String descendantsOfGroup) {
                    this.descendantsOfGroup = descendantsOfGroup;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends MonitoringRequest<Group> {
                private static final String REST_PATH = "v3/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(Monitoring.this, "GET", REST_PATH, null, Group.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/groups/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/groups/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/groups/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends MonitoringRequest<Empty> {
                private static final String REST_PATH = "v3/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private Boolean recursive;

                protected Delete(String name) {
                    super(Monitoring.this, "DELETE", REST_PATH, null, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/groups/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/groups/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/groups/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public Boolean getRecursive() {
                    return this.recursive;
                }

                public Delete setRecursive(Boolean recursive) {
                    this.recursive = recursive;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends MonitoringRequest<Group> {
                private static final String REST_PATH = "v3/{+name}/groups";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private Boolean validateOnly;

                protected Create(String name, Group content) {
                    super(Monitoring.this, "POST", REST_PATH, (Object)content, Group.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Create setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public Boolean getValidateOnly() {
                    return this.validateOnly;
                }

                public Create setValidateOnly(Boolean validateOnly) {
                    this.validateOnly = validateOnly;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class CollectdTimeSeries {
            public Create create(String name, CreateCollectdTimeSeriesRequest content) throws IOException {
                Create result = new Create(name, content);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Create
            extends MonitoringRequest<CreateCollectdTimeSeriesResponse> {
                private static final String REST_PATH = "v3/{+name}/collectdTimeSeries";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Create(String name, CreateCollectdTimeSeriesRequest content) {
                    super(Monitoring.this, "POST", REST_PATH, (Object)content, CreateCollectdTimeSeriesResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Create setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class AlertPolicies {
            public Create create(String name, AlertPolicy content) throws IOException {
                Create result = new Create(name, content);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String name) throws IOException {
                Delete result = new Delete(name);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String name) throws IOException {
                List result = new List(name);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String name, AlertPolicy content) throws IOException {
                Patch result = new Patch(name, content);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Patch
            extends MonitoringRequest<AlertPolicy> {
                private static final String REST_PATH = "v3/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String updateMask;

                protected Patch(String name, AlertPolicy content) {
                    super(Monitoring.this, "PATCH", REST_PATH, (Object)content, AlertPolicy.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/alertPolicies/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/alertPolicies/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/alertPolicies/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends MonitoringRequest<ListAlertPoliciesResponse> {
                private static final String REST_PATH = "v3/{+name}/alertPolicies";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String filter;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String name) {
                    super(Monitoring.this, "GET", REST_PATH, null, ListAlertPoliciesResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends MonitoringRequest<AlertPolicy> {
                private static final String REST_PATH = "v3/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(Monitoring.this, "GET", REST_PATH, null, AlertPolicy.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/alertPolicies/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/alertPolicies/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/alertPolicies/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends MonitoringRequest<Empty> {
                private static final String REST_PATH = "v3/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Delete(String name) {
                    super(Monitoring.this, "DELETE", REST_PATH, null, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/alertPolicies/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/alertPolicies/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/alertPolicies/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends MonitoringRequest<AlertPolicy> {
                private static final String REST_PATH = "v3/{+name}/alertPolicies";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Create(String name, AlertPolicy content) {
                    super(Monitoring.this, "POST", REST_PATH, (Object)content, AlertPolicy.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Create setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }
    }

    public class Organizations {
        public TimeSeries timeSeries() {
            return new TimeSeries();
        }

        public class TimeSeries {
            public List list(String name) throws IOException {
                List result = new List(name);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends MonitoringRequest<ListTimeSeriesResponse> {
                private static final String REST_PATH = "v3/{+name}/timeSeries";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key(value="aggregation.alignmentPeriod")
                private String aggregationAlignmentPeriod;
                @Key(value="aggregation.crossSeriesReducer")
                private String aggregationCrossSeriesReducer;
                @Key(value="aggregation.groupByFields")
                private java.util.List<String> aggregationGroupByFields;
                @Key(value="aggregation.perSeriesAligner")
                private String aggregationPerSeriesAligner;
                @Key
                private String filter;
                @Key(value="interval.endTime")
                private String intervalEndTime;
                @Key(value="interval.startTime")
                private String intervalStartTime;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key(value="secondaryAggregation.alignmentPeriod")
                private String secondaryAggregationAlignmentPeriod;
                @Key(value="secondaryAggregation.crossSeriesReducer")
                private String secondaryAggregationCrossSeriesReducer;
                @Key(value="secondaryAggregation.groupByFields")
                private java.util.List<String> secondaryAggregationGroupByFields;
                @Key(value="secondaryAggregation.perSeriesAligner")
                private String secondaryAggregationPerSeriesAligner;
                @Key
                private String view;

                protected List(String name) {
                    super(Monitoring.this, "GET", REST_PATH, null, ListTimeSeriesResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getAggregationAlignmentPeriod() {
                    return this.aggregationAlignmentPeriod;
                }

                public List setAggregationAlignmentPeriod(String aggregationAlignmentPeriod) {
                    this.aggregationAlignmentPeriod = aggregationAlignmentPeriod;
                    return this;
                }

                public String getAggregationCrossSeriesReducer() {
                    return this.aggregationCrossSeriesReducer;
                }

                public List setAggregationCrossSeriesReducer(String aggregationCrossSeriesReducer) {
                    this.aggregationCrossSeriesReducer = aggregationCrossSeriesReducer;
                    return this;
                }

                public java.util.List<String> getAggregationGroupByFields() {
                    return this.aggregationGroupByFields;
                }

                public List setAggregationGroupByFields(java.util.List<String> aggregationGroupByFields) {
                    this.aggregationGroupByFields = aggregationGroupByFields;
                    return this;
                }

                public String getAggregationPerSeriesAligner() {
                    return this.aggregationPerSeriesAligner;
                }

                public List setAggregationPerSeriesAligner(String aggregationPerSeriesAligner) {
                    this.aggregationPerSeriesAligner = aggregationPerSeriesAligner;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getIntervalEndTime() {
                    return this.intervalEndTime;
                }

                public List setIntervalEndTime(String intervalEndTime) {
                    this.intervalEndTime = intervalEndTime;
                    return this;
                }

                public String getIntervalStartTime() {
                    return this.intervalStartTime;
                }

                public List setIntervalStartTime(String intervalStartTime) {
                    this.intervalStartTime = intervalStartTime;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public String getSecondaryAggregationAlignmentPeriod() {
                    return this.secondaryAggregationAlignmentPeriod;
                }

                public List setSecondaryAggregationAlignmentPeriod(String secondaryAggregationAlignmentPeriod) {
                    this.secondaryAggregationAlignmentPeriod = secondaryAggregationAlignmentPeriod;
                    return this;
                }

                public String getSecondaryAggregationCrossSeriesReducer() {
                    return this.secondaryAggregationCrossSeriesReducer;
                }

                public List setSecondaryAggregationCrossSeriesReducer(String secondaryAggregationCrossSeriesReducer) {
                    this.secondaryAggregationCrossSeriesReducer = secondaryAggregationCrossSeriesReducer;
                    return this;
                }

                public java.util.List<String> getSecondaryAggregationGroupByFields() {
                    return this.secondaryAggregationGroupByFields;
                }

                public List setSecondaryAggregationGroupByFields(java.util.List<String> secondaryAggregationGroupByFields) {
                    this.secondaryAggregationGroupByFields = secondaryAggregationGroupByFields;
                    return this;
                }

                public String getSecondaryAggregationPerSeriesAligner() {
                    return this.secondaryAggregationPerSeriesAligner;
                }

                public List setSecondaryAggregationPerSeriesAligner(String secondaryAggregationPerSeriesAligner) {
                    this.secondaryAggregationPerSeriesAligner = secondaryAggregationPerSeriesAligner;
                    return this;
                }

                public String getView() {
                    return this.view;
                }

                public List setView(String view) {
                    this.view = view;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }
        }
    }

    public class Folders {
        public TimeSeries timeSeries() {
            return new TimeSeries();
        }

        public class TimeSeries {
            public List list(String name) throws IOException {
                List result = new List(name);
                Monitoring.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends MonitoringRequest<ListTimeSeriesResponse> {
                private static final String REST_PATH = "v3/{+name}/timeSeries";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key(value="aggregation.alignmentPeriod")
                private String aggregationAlignmentPeriod;
                @Key(value="aggregation.crossSeriesReducer")
                private String aggregationCrossSeriesReducer;
                @Key(value="aggregation.groupByFields")
                private java.util.List<String> aggregationGroupByFields;
                @Key(value="aggregation.perSeriesAligner")
                private String aggregationPerSeriesAligner;
                @Key
                private String filter;
                @Key(value="interval.endTime")
                private String intervalEndTime;
                @Key(value="interval.startTime")
                private String intervalStartTime;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key(value="secondaryAggregation.alignmentPeriod")
                private String secondaryAggregationAlignmentPeriod;
                @Key(value="secondaryAggregation.crossSeriesReducer")
                private String secondaryAggregationCrossSeriesReducer;
                @Key(value="secondaryAggregation.groupByFields")
                private java.util.List<String> secondaryAggregationGroupByFields;
                @Key(value="secondaryAggregation.perSeriesAligner")
                private String secondaryAggregationPerSeriesAligner;
                @Key
                private String view;

                protected List(String name) {
                    super(Monitoring.this, "GET", REST_PATH, null, ListTimeSeriesResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^folders/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String name) {
                    if (!Monitoring.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getAggregationAlignmentPeriod() {
                    return this.aggregationAlignmentPeriod;
                }

                public List setAggregationAlignmentPeriod(String aggregationAlignmentPeriod) {
                    this.aggregationAlignmentPeriod = aggregationAlignmentPeriod;
                    return this;
                }

                public String getAggregationCrossSeriesReducer() {
                    return this.aggregationCrossSeriesReducer;
                }

                public List setAggregationCrossSeriesReducer(String aggregationCrossSeriesReducer) {
                    this.aggregationCrossSeriesReducer = aggregationCrossSeriesReducer;
                    return this;
                }

                public java.util.List<String> getAggregationGroupByFields() {
                    return this.aggregationGroupByFields;
                }

                public List setAggregationGroupByFields(java.util.List<String> aggregationGroupByFields) {
                    this.aggregationGroupByFields = aggregationGroupByFields;
                    return this;
                }

                public String getAggregationPerSeriesAligner() {
                    return this.aggregationPerSeriesAligner;
                }

                public List setAggregationPerSeriesAligner(String aggregationPerSeriesAligner) {
                    this.aggregationPerSeriesAligner = aggregationPerSeriesAligner;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getIntervalEndTime() {
                    return this.intervalEndTime;
                }

                public List setIntervalEndTime(String intervalEndTime) {
                    this.intervalEndTime = intervalEndTime;
                    return this;
                }

                public String getIntervalStartTime() {
                    return this.intervalStartTime;
                }

                public List setIntervalStartTime(String intervalStartTime) {
                    this.intervalStartTime = intervalStartTime;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public String getSecondaryAggregationAlignmentPeriod() {
                    return this.secondaryAggregationAlignmentPeriod;
                }

                public List setSecondaryAggregationAlignmentPeriod(String secondaryAggregationAlignmentPeriod) {
                    this.secondaryAggregationAlignmentPeriod = secondaryAggregationAlignmentPeriod;
                    return this;
                }

                public String getSecondaryAggregationCrossSeriesReducer() {
                    return this.secondaryAggregationCrossSeriesReducer;
                }

                public List setSecondaryAggregationCrossSeriesReducer(String secondaryAggregationCrossSeriesReducer) {
                    this.secondaryAggregationCrossSeriesReducer = secondaryAggregationCrossSeriesReducer;
                    return this;
                }

                public java.util.List<String> getSecondaryAggregationGroupByFields() {
                    return this.secondaryAggregationGroupByFields;
                }

                public List setSecondaryAggregationGroupByFields(java.util.List<String> secondaryAggregationGroupByFields) {
                    this.secondaryAggregationGroupByFields = secondaryAggregationGroupByFields;
                    return this;
                }

                public String getSecondaryAggregationPerSeriesAligner() {
                    return this.secondaryAggregationPerSeriesAligner;
                }

                public List setSecondaryAggregationPerSeriesAligner(String secondaryAggregationPerSeriesAligner) {
                    this.secondaryAggregationPerSeriesAligner = secondaryAggregationPerSeriesAligner;
                    return this;
                }

                public String getView() {
                    return this.view;
                }

                public List setView(String view) {
                    this.view = view;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }
        }
    }
}

